/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.print;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.print.IPrinter;
import com.elixirtech.print.Printable;
import com.elixirtech.print.PrinterUtil;
import com.elixirtech.ui.print.PrintDialog;
import java.awt.Frame;
import java.util.Properties;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.PageRanges;

public final class CanvasPrinter14
implements IPrinter {
    public static final String PRINTER_NAME = "PrinterName";
    public static final String SHOW_RANGE_DIALOG = "ShowRangeDialog";
    public static final String SHOW_PRINT_DIALOG = "ShowPrintDialog";
    public static final String PRINTJOB_NAME = "PrintJobName";
    public static final String PRINT_COPIES = "PrintCopies";
    public static final String PRINT_RANGE = "PrintRange";
    protected Printable m_Printable;
    protected PageRanges m_Range;
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(CanvasPrinter14.class);

    @Override
    public boolean print(Printable printable, Properties properties, Frame frame) {
        this.m_Printable = printable;
        String string = properties.getProperty(PRINTER_NAME);
        String string2 = properties.getProperty(SHOW_RANGE_DIALOG);
        String string3 = properties.getProperty(PRINTJOB_NAME);
        String string4 = properties.getProperty(PRINT_COPIES);
        String string5 = properties.getProperty(PRINT_RANGE);
        int n = 1;
        try {
            if (string4 != null) {
                n = Integer.parseInt(string4);
            }
        }
        catch (Exception exception) {
            m_Log.warn((Object)("Set number of copies (" + string4 + ") error: " + String.valueOf(exception)));
        }
        if ("No".equals(string2)) {
            this.m_Range = string5.length() == 0 ? PrinterUtil.generateRange(this.m_Printable.getNumberOfPages()) : PrinterUtil.generateRange(string5, this.m_Printable.getNumberOfPages());
        } else if (PrintDialog.showPrintDialog(frame, this.m_Printable.getNumberOfPages())) {
            this.m_Range = PrintDialog.getPages();
        }
        if (this.m_Range != null) {
            if (string3 == null) {
                string3 = "Elixir Report PrintJob";
            }
            HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
            hashPrintRequestAttributeSet.add(new Copies(n));
            JobName jobName = new JobName(string3, null);
            hashPrintRequestAttributeSet.add(jobName);
            hashPrintRequestAttributeSet.add(this.m_Range);
            try {
                PrintService printService = null;
                if (string != null) {
                    printService = this.getSelectedPrintService(string);
                    if (printService == null) {
                        m_Log.warn((Object)("No print service '" + string + "' found, using default printer"));
                        printService = CanvasPrinter14.getDefaultPrintService();
                    }
                } else {
                    printService = CanvasPrinter14.getDefaultPrintService();
                }
                if (printService == null) {
                    m_Log.error((Object)"No printer specified");
                    return false;
                }
                MediaPrintableArea mediaPrintableArea = (MediaPrintableArea)printService.getDefaultAttributeValue(MediaPrintableArea.class);
                if (mediaPrintableArea == null) {
                    m_Log.error((Object)"Can't get MediaPrintableArea");
                    return false;
                }
                m_Log.info((Object)"Building printer data");
                DocPrintJob docPrintJob = printService.createPrintJob();
                SimpleDoc simpleDoc = new SimpleDoc(this.m_Printable, DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
                m_Log.info((Object)"Printing");
                docPrintJob.print(simpleDoc, hashPrintRequestAttributeSet);
                m_Log.info((Object)"Printing complete");
                return true;
            }
            catch (PrintException printException) {
                System.err.println(printException);
            }
        }
        return false;
    }

    private static PrintService getDefaultPrintService() {
        return PrintServiceLookup.lookupDefaultPrintService();
    }

    public PrintService[] getPrintServices() {
        DocFlavor.SERVICE_FORMATTED sERVICE_FORMATTED = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
        return PrintServiceLookup.lookupPrintServices(sERVICE_FORMATTED, new HashPrintRequestAttributeSet());
    }

    public PrintService getSelectedPrintService(String string) {
        PrintService[] printServiceArray = this.getPrintServices();
        for (int i = 0; i < printServiceArray.length; ++i) {
            String string2 = printServiceArray[i].getName();
            if (!string2.equals(string)) continue;
            return printServiceArray[i];
        }
        return null;
    }
}

