/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.qb.jdbc;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class ResultSetTableModel
extends AbstractTableModel {
    private String[] m_ColumnLabels;
    private List<String[]> m_Rows = new ArrayList<String[]>();

    public ResultSetTableModel(ResultSet resultSet) throws SQLException {
        this.buildArray(resultSet);
    }

    private void buildArray(ResultSet resultSet) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        this.m_ColumnLabels = new String[n];
        for (int i = 0; i < n; ++i) {
            this.m_ColumnLabels[i] = resultSetMetaData.getColumnLabel(i + 1);
        }
        while (resultSet.next()) {
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = resultSet.getString(i + 1);
                this.m_Rows.add(stringArray);
            }
        }
    }

    @Override
    public int getRowCount() {
        return this.m_Rows.size();
    }

    @Override
    public int getColumnCount() {
        return this.m_ColumnLabels.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.m_ColumnLabels[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        String[] stringArray = this.m_Rows.get(n);
        return stringArray[n2];
    }
}

