/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.qb.jdbc;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.data2.Data2Constants;
import com.elixirtech.data2.DataAttribute;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.TableIdentifier;
import com.elixirtech.data2.attributes.ForeignKey;
import com.elixirtech.data2.datasource.jdbc.JDBCConnector;
import com.elixirtech.jdom.Document;
import com.elixirtech.jdom.Element;
import com.elixirtech.qb.jdbc.SchemaExtractor2;
import com.elixirtech.qb.model.QBColumn;
import com.elixirtech.qb.model.QBModel;
import com.elixirtech.qb.model.QBTable;
import com.elixirtech.remote.ISchemaAccess;
import com.elixirtech.util.Pair;
import java.util.ArrayList;
import java.util.List;

public class SchemaExtractor3 {
    private JDBCConnector m_Connector;
    private final QBModel m_Model;
    private final List<Pair<ForeignKey, QBColumn>> m_FKeys = new ArrayList<Pair<ForeignKey, QBColumn>>();
    public static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(SchemaExtractor2.class);

    public SchemaExtractor3(QBModel qBModel) {
        this.m_Model = qBModel;
    }

    public void setConnector(JDBCConnector jDBCConnector) {
        this.m_Connector = jDBCConnector;
    }

    public void load(JDBCConnector jDBCConnector, boolean bl) throws DataException {
        this.m_Connector = jDBCConnector;
        ISchemaAccess iSchemaAccess = (ISchemaAccess)Elixir.get(ISchemaAccess.class);
        Document document = iSchemaAccess.getTableMetadata(this.m_Connector);
        Element element = document.getRootElement();
        this.m_Model.setQuoteString(element.getAttributeValue("identifier-quote-string"));
        this.buildTables(element);
        if (bl) {
            this.buildViews(element);
        }
    }

    public void fillTable(QBTable qBTable) throws DataException {
        ISchemaAccess iSchemaAccess = (ISchemaAccess)Elixir.get(ISchemaAccess.class);
        Document document = iSchemaAccess.getColumnMetadata(this.m_Connector, qBTable.getCatalog(), qBTable.getSchema(), qBTable.getName());
        Element element = document.getRootElement();
        this.buildColumns(element, qBTable);
    }

    private void buildTables(Element element) {
        List list = element.getChildren("table", Data2Constants.NS_DATASOURCE);
        for (Element element2 : list) {
            TableIdentifier tableIdentifier = new TableIdentifier();
            tableIdentifier.type = "TABLE";
            tableIdentifier.catalog = element2.getAttributeValue("catalog");
            tableIdentifier.schema = element2.getAttributeValue("schema");
            tableIdentifier.table = element2.getAttributeValue("name");
            boolean bl = this.m_Model.getTable(tableIdentifier) != null;
            if (bl) continue;
            new QBTable(this.m_Model, tableIdentifier);
        }
    }

    private void buildViews(Element element) {
        List list = element.getChildren("view", Data2Constants.NS_DATASOURCE);
        for (Element element2 : list) {
            TableIdentifier tableIdentifier = new TableIdentifier();
            tableIdentifier.type = "VIEW";
            tableIdentifier.catalog = element2.getAttributeValue("catalog");
            tableIdentifier.schema = element2.getAttributeValue("schema");
            tableIdentifier.table = element2.getAttributeValue("name");
            boolean bl = this.m_Model.getTable(tableIdentifier) != null;
            if (bl) continue;
            new QBTable(this.m_Model, tableIdentifier);
        }
    }

    private void buildColumns(Element element, QBTable qBTable) {
        if (!qBTable.hasColumns()) {
            List list = element.getChildren("column", Data2Constants.NS_DATASOURCE);
            for (Element element2 : list) {
                String string = element2.getAttributeValue("name");
                int n = Integer.parseInt(element2.getAttributeValue("type"));
                QBColumn qBColumn = new QBColumn(qBTable, string, n);
                qBTable.addColumn(qBColumn);
                this.buildAttributes(element2, qBColumn);
            }
        }
        this.buildLinks();
    }

    private void buildAttributes(Element element, QBColumn qBColumn) {
        List list = element.getChildren("attribute", Data2Constants.NS_DATASOURCE);
        for (Element element2 : list) {
            DataAttribute dataAttribute = DataAttribute.newDataAttribute((Element)element2);
            if (dataAttribute == null) continue;
            qBColumn.addAttribute(dataAttribute);
            if (!(dataAttribute instanceof ForeignKey)) continue;
            this.m_FKeys.add(new Pair<ForeignKey, QBColumn>((ForeignKey)dataAttribute, qBColumn));
        }
    }

    private void buildLinks() {
        ArrayList<Pair<ForeignKey, QBColumn>> arrayList = new ArrayList<Pair<ForeignKey, QBColumn>>(this.m_FKeys);
        for (Pair pair : arrayList) {
            QBTable qBTable = this.m_Model.getTable(((ForeignKey)pair.first).getTable());
            if (qBTable == null) continue;
            QBColumn qBColumn = qBTable.getColumn(((ForeignKey)pair.first).getColumn());
            QBColumn qBColumn2 = (QBColumn)pair.second;
            if (qBColumn == null) continue;
            this.m_Model.addLink(1, qBColumn, qBColumn2);
        }
    }
}

