/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.qb.model;

import com.elixirtech.data2.Data2Constants;
import com.elixirtech.data2.DataAttribute;
import com.elixirtech.data2.DataAttributes;
import com.elixirtech.data2.attributes.PrimaryKey;
import com.elixirtech.jdom.Content;
import com.elixirtech.jdom.Element;
import com.elixirtech.qb.model.QBTable;

public class QBColumn
implements Comparable<QBColumn> {
    private QBTable m_Table;
    private String m_Name;
    private int m_Type;
    private DataAttributes m_Attributes;
    private boolean m_IsSelected;
    private String m_ColumnAlias;
    private int m_Sort = 0;
    private String m_Where;
    private String m_Aggregate;
    private String m_Having;
    public static final int SORT_NONE = 0;
    public static final int SORT_ASCENDING = 1;
    public static final int SORT_DESCENDING = 2;

    public QBColumn(QBTable qBTable) {
        this.setTable(qBTable);
        this.m_Attributes = new DataAttributes();
    }

    public QBColumn(QBTable qBTable, String string, int n) {
        this(qBTable);
        this.setName(string);
        this.setType(n);
        this.m_Attributes = new DataAttributes();
    }

    public QBColumn(QBTable qBTable, Element element) {
        this(qBTable);
        this.m_Attributes = new DataAttributes();
        this.fromXML(element);
    }

    public void addAttribute(DataAttribute dataAttribute) {
        this.m_Attributes.addAttribute(dataAttribute);
    }

    public void removeAttribute(DataAttribute dataAttribute) {
        this.m_Attributes.removeAttribute(dataAttribute);
    }

    public DataAttributes getAttributes() {
        return this.m_Attributes;
    }

    public boolean isPrimaryKey() {
        return this.getAttributes().getAttribute(PrimaryKey.class) != null;
    }

    @Override
    public int compareTo(QBColumn qBColumn) {
        return this.getFullName().compareTo(qBColumn.getFullName());
    }

    public String toString() {
        return this.m_Name;
    }

    public QBTable getTable() {
        return this.m_Table;
    }

    public void setTable(QBTable qBTable) {
        this.m_Table = qBTable;
    }

    public String getName() {
        return this.m_Name;
    }

    public void setName(String string) {
        this.m_Name = string;
    }

    public String getFullName() {
        return this.m_Table.getName() + "." + this.getName();
    }

    public int getType() {
        return this.m_Type;
    }

    public void setType(int n) {
        this.m_Type = n;
    }

    public boolean isSelected() {
        return this.m_IsSelected;
    }

    public void setSelected(boolean bl) {
        this.m_IsSelected = bl;
    }

    public String getColumnAlias() {
        return this.m_ColumnAlias;
    }

    public void setColumnAlias(String string) {
        this.m_ColumnAlias = string;
    }

    public int getSort() {
        return this.m_Sort;
    }

    public void setSort(int n) {
        this.m_Sort = n;
    }

    public String getWhere() {
        return this.m_Where;
    }

    public void setWhere(String string) {
        this.m_Where = string;
    }

    public String getAggregate() {
        return this.m_Aggregate;
    }

    public void setAggregate(String string) {
        this.m_Aggregate = string;
    }

    public String getHaving() {
        return this.m_Having;
    }

    public void setHaving(String string) {
        this.m_Having = string;
    }

    public Element toXML() {
        Element element = new Element("column");
        element.setAttribute("name", this.m_Name);
        element.setAttribute("type", String.valueOf(this.m_Type));
        for (DataAttribute dataAttribute : this.m_Attributes.getAttributes()) {
            element.addContent((Content)dataAttribute.getElement());
        }
        element.setAttribute("isSelected", this.m_IsSelected ? "true" : "false");
        if (this.m_ColumnAlias != null) {
            element.setAttribute("alias", this.m_ColumnAlias);
        }
        element.setAttribute("sort", String.valueOf(this.m_Sort));
        if (this.m_Where != null) {
            element.setAttribute("where", this.m_Where);
        }
        if (this.m_Aggregate != null) {
            element.setAttribute("aggregate", this.m_Aggregate);
        }
        if (this.m_Having != null) {
            element.setAttribute("having", this.m_Having);
        }
        return element;
    }

    public void fromXML(Element element) {
        this.m_Name = element.getAttributeValue("name");
        this.m_Type = Integer.parseInt(element.getAttributeValue("type"));
        for (Element element2 : element.getChildren("attribute", Data2Constants.NS_DATASOURCE)) {
            DataAttribute dataAttribute = DataAttribute.newDataAttribute((Element)element2);
            if (dataAttribute == null) continue;
            this.m_Attributes.addAttribute(dataAttribute);
        }
        this.m_IsSelected = "true".equals(element.getAttributeValue("isSelected"));
        this.m_ColumnAlias = element.getAttributeValue("alias");
        this.m_Sort = Integer.parseInt(element.getAttributeValue("sort"));
        this.m_Where = element.getAttributeValue("where");
        this.m_Aggregate = element.getAttributeValue("aggregate");
        this.m_Having = element.getAttributeValue("having");
    }
}

