/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.qb.model;

import com.elixirtech.data2.TableIdentifier;
import com.elixirtech.jdom.Content;
import com.elixirtech.jdom.Element;
import com.elixirtech.qb.model.QBColumn;
import com.elixirtech.qb.model.QBModel;
import com.elixirtech.qb.model.QBTable;

public final class QBLink {
    public static final int TYPE_INFERRED = 1;
    public static final int TYPE_MANUAL = 2;
    private int m_Type;
    private QBColumn m_Column1;
    private QBColumn m_Column2;
    private String m_JoinType = "Inner Join";

    public static QBLink create(int n, QBColumn qBColumn, QBColumn qBColumn2) {
        if (qBColumn.isPrimaryKey()) {
            return new QBLink(n, qBColumn, qBColumn2);
        }
        if (qBColumn2.isPrimaryKey()) {
            return new QBLink(n, qBColumn2, qBColumn);
        }
        int n2 = qBColumn.compareTo(qBColumn2);
        if (n2 < 0) {
            return new QBLink(n, qBColumn, qBColumn2);
        }
        if (n2 > 0) {
            return new QBLink(n, qBColumn2, qBColumn);
        }
        return null;
    }

    private QBLink(int n, QBColumn qBColumn, QBColumn qBColumn2) {
        this.m_Type = n;
        this.m_Column1 = qBColumn;
        this.m_Column2 = qBColumn2;
        this.m_Column1.getTable().addLink(this);
        this.m_Column2.getTable().addLink(this);
    }

    public QBLink(QBModel qBModel, Element element) {
        this.fromXML(qBModel, element);
    }

    public boolean isValid() {
        return this.m_Column1 != null && this.m_Column2 != null;
    }

    public String toString() {
        return this.getColumn1().getFullName() + "=" + this.getColumn2().getFullName();
    }

    public int getType() {
        return this.m_Type;
    }

    public QBColumn getColumn1() {
        return this.m_Column1;
    }

    public QBColumn getColumn2() {
        return this.m_Column2;
    }

    public QBTable getTable1() {
        return this.m_Column1.getTable();
    }

    public QBTable getTable2() {
        return this.m_Column2.getTable();
    }

    public String getJoinType() {
        return this.m_JoinType;
    }

    public void setJoinType(String string) {
        this.m_JoinType = string;
    }

    public void dispose() {
        this.m_Column1.getTable().removeLink(this);
        this.m_Column2.getTable().removeLink(this);
    }

    public Element toXML() {
        Element element = new Element("link");
        element.setAttribute("type", String.valueOf(this.m_Type));
        Element element2 = new Element("column1");
        element2.setAttribute("name", this.m_Column1.getName());
        element2.addContent((Content)this.m_Column1.getTable().getIdentifier().toXML());
        element.addContent((Content)element2);
        Element element3 = new Element("column2");
        element3.setAttribute("name", this.m_Column2.getName());
        element3.addContent((Content)this.m_Column2.getTable().getIdentifier().toXML());
        element.addContent((Content)element3);
        element.setAttribute("joinType", this.m_JoinType);
        return element;
    }

    public void fromXML(QBModel qBModel, Element element) {
        this.m_Type = Integer.parseInt(element.getAttributeValue("type"));
        Element element2 = element.getChild("column1");
        this.m_Column1 = this.getColumn(qBModel, element2);
        Element element3 = element.getChild("column2");
        this.m_Column2 = this.getColumn(qBModel, element3);
        this.m_JoinType = element.getAttributeValue("joinType");
    }

    private QBColumn getColumn(QBModel qBModel, Element element) {
        String string = element.getAttributeValue("name");
        TableIdentifier tableIdentifier = new TableIdentifier(element.getChild("id"));
        QBTable qBTable = qBModel.getTable(tableIdentifier);
        if (qBTable != null) {
            qBTable.addLink(this);
            return qBTable.getColumn(string);
        }
        return null;
    }
}

