/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.qb.model;

import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.TableIdentifier;
import com.elixirtech.data2.datasource.jdbc.JDBCConnector;
import com.elixirtech.jdom.Content;
import com.elixirtech.jdom.Element;
import com.elixirtech.qb.jdbc.SchemaExtractor3;
import com.elixirtech.qb.model.QBColumn;
import com.elixirtech.qb.model.QBLink;
import com.elixirtech.qb.model.QBTable;
import com.elixirtech.remote.ConnectionPool;
import com.elixirtech.remote.HikariPool;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class QBModel {
    private transient ArgumentMap.ICallback m_Callback;
    private String m_Name;
    private JDBCConnector.Pool m_Connector;
    private SchemaExtractor3 m_Extractor;
    private String m_DefaultSchema;
    private String m_QuoteString;
    private ArrayList<String> m_SelectedSchema = new ArrayList();
    private boolean m_SelectViewsOnly;
    private Set<QBTable> m_Tables = new TreeSet<QBTable>();
    private List<QBLink> m_Links = new LinkedList<QBLink>();
    private List<QBColumn> m_SelectedColumns = new LinkedList<QBColumn>();
    private List<QBTable> m_SelectedTables = new LinkedList<QBTable>();
    private boolean m_SelectDistinct;
    private PropertyChangeSupport m_PropertyChangeSupport;
    public static final int SQL_SELECT_DISTINCT = 1;
    public static final int SQL_SELECT_ALL = 2;
    public static final int SQL_UPDATE = 3;
    public static final int SQL_DELETE = 4;

    public QBModel() {
        this.m_PropertyChangeSupport = new PropertyChangeSupport(this);
        this.m_Extractor = new SchemaExtractor3(this);
    }

    public QBModel(JDBCConnector.Pool pool, Element element) {
        this.setJDBCConnector(pool);
        this.m_PropertyChangeSupport = new PropertyChangeSupport(this);
        this.m_Extractor = new SchemaExtractor3(this);
        this.m_Extractor.setConnector((JDBCConnector)pool);
        this.fromXML(element);
    }

    public SchemaExtractor3 getExtractor() {
        return this.m_Extractor;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        QBTable[] qBTableArray = this.getTables();
        for (int i = 0; i < qBTableArray.length; ++i) {
            stringBuffer.append("T" + qBTableArray[i].getName() + "\n");
            QBColumn[] qBColumnArray = qBTableArray[i].getColumns();
            for (int j = 0; j < qBColumnArray.length; ++j) {
                stringBuffer.append("C" + qBColumnArray[j].getName() + "\n");
            }
        }
        return stringBuffer.toString();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_PropertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_PropertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        this.m_PropertyChangeSupport.firePropertyChange(string, object, object2);
    }

    public String getName() {
        return this.m_Name;
    }

    public void setName(String string) {
        this.m_Name = string;
        this.m_PropertyChangeSupport.firePropertyChange("name", null, this.m_Name);
    }

    public void setJDBCConnector(JDBCConnector.Pool pool) {
        this.m_Connector = pool;
    }

    public JDBCConnector.Pool getJDBCConnector() {
        return this.m_Connector;
    }

    public String getDriverKey() {
        HikariPool hikariPool = ConnectionPool.getPoolJ(this.m_Connector.pool);
        if (hikariPool != null) {
            return hikariPool.ds().getDataSourceClassName();
        }
        return null;
    }

    public void addTable(QBTable qBTable) {
        this.m_Tables.add(qBTable);
        this.m_PropertyChangeSupport.firePropertyChange("tables", null, qBTable);
    }

    public void removeTable(QBTable qBTable) {
        this.m_Tables.remove(qBTable);
        this.m_PropertyChangeSupport.firePropertyChange("tables", qBTable, null);
    }

    public String[] getSchemas() {
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.add("");
        for (QBTable stringArray2 : this.m_Tables) {
            String string = stringArray2.getSchema();
            if (string == null) continue;
            treeSet.add(string);
        }
        String[] stringArray = new String[treeSet.size()];
        treeSet.toArray(stringArray);
        return stringArray;
    }

    public int getTableCount() {
        return this.m_Tables.size();
    }

    public QBTable getTable(String string) {
        for (QBTable qBTable : this.m_Tables) {
            if (!qBTable.getName().equals(string)) continue;
            return qBTable;
        }
        return null;
    }

    public QBTable getTable(TableIdentifier tableIdentifier) {
        for (QBTable qBTable : this.m_Tables) {
            if (!tableIdentifier.equals((Object)qBTable.getIdentifier())) continue;
            return qBTable;
        }
        return null;
    }

    public QBTable[] getTables() {
        QBTable[] qBTableArray = new QBTable[this.m_Tables.size()];
        this.m_Tables.toArray(qBTableArray);
        return qBTableArray;
    }

    public Set<QBTable> getTableSet() {
        return Collections.unmodifiableSet(this.m_Tables);
    }

    public QBLink getLinkBetween(QBColumn qBColumn, QBColumn qBColumn2) {
        for (QBLink qBLink : this.m_Links) {
            if (qBLink.getColumn1() == qBColumn && qBLink.getColumn2() == qBColumn2) {
                return qBLink;
            }
            if (qBLink.getColumn1() != qBColumn2 || qBLink.getColumn2() != qBColumn) continue;
            return qBLink;
        }
        return null;
    }

    public boolean isLinkBetween(QBColumn qBColumn, QBColumn qBColumn2) {
        return this.getLinkBetween(qBColumn, qBColumn2) != null;
    }

    public QBLink addLink(int n, QBColumn qBColumn, QBColumn qBColumn2) {
        QBLink qBLink = this.getLinkBetween(qBColumn, qBColumn2);
        if (qBLink != null) {
            return qBLink;
        }
        QBLink qBLink2 = QBLink.create(n, qBColumn, qBColumn2);
        if (qBLink2 != null) {
            this.m_Links.add(qBLink2);
            this.m_PropertyChangeSupport.firePropertyChange("links", null, qBLink2);
        }
        return qBLink2;
    }

    public void removeLink(QBLink qBLink) {
        qBLink.dispose();
        this.m_Links.remove(qBLink);
        this.m_PropertyChangeSupport.firePropertyChange("links", qBLink, null);
    }

    public QBLink[] getLinks() {
        QBLink[] qBLinkArray = new QBLink[this.m_Links.size()];
        this.m_Links.toArray(qBLinkArray);
        return qBLinkArray;
    }

    public int getLinkCount() {
        return this.m_Links.size();
    }

    public QBLink getLink(int n) {
        return this.m_Links.get(n);
    }

    public int getSelectedColumnCount() {
        return this.m_SelectedColumns.size();
    }

    public QBColumn getSelectedColumn(int n) {
        return this.m_SelectedColumns.get(n);
    }

    public void selectColumn(QBColumn qBColumn) {
        this.m_SelectedColumns.add(qBColumn);
        qBColumn.setSelected(true);
        this.m_PropertyChangeSupport.firePropertyChange("selected-columns", null, qBColumn);
    }

    public void deselectColumn(QBColumn qBColumn) {
        this.m_SelectedColumns.remove(qBColumn);
        qBColumn.setSelected(false);
        this.m_PropertyChangeSupport.firePropertyChange("selected-columns", qBColumn, null);
    }

    public Set<QBTable> getSelectedColumnsTableSet() {
        TreeSet<QBTable> treeSet = new TreeSet<QBTable>();
        for (QBColumn qBColumn : this.m_SelectedColumns) {
            treeSet.add(qBColumn.getTable());
        }
        return treeSet;
    }

    public int getSelectedTableCount() {
        return this.m_SelectedTables.size();
    }

    public QBTable getSelectedTable(int n) {
        return this.m_SelectedTables.get(n);
    }

    public void selectTable(QBTable qBTable) {
        this.m_SelectedTables.add(qBTable);
        qBTable.setSelected(true);
        this.m_PropertyChangeSupport.firePropertyChange("selected-tables", null, qBTable);
    }

    public void deselectTable(QBTable qBTable) {
        QBColumn[] qBColumnArray = qBTable.getColumns();
        for (int i = 0; i < qBColumnArray.length; ++i) {
            if (!qBColumnArray[i].isSelected()) continue;
            this.deselectColumn(qBColumnArray[i]);
        }
        this.m_SelectedTables.remove(qBTable);
        qBTable.setSelected(false);
        this.m_PropertyChangeSupport.firePropertyChange("selected-tables", qBTable, null);
    }

    public Set<QBTable> getSelectedTableSet() {
        TreeSet<QBTable> treeSet = new TreeSet<QBTable>();
        treeSet.addAll(this.m_SelectedTables);
        return treeSet;
    }

    public void setSelectDistinct(boolean bl) {
        this.m_SelectDistinct = bl;
        this.m_PropertyChangeSupport.firePropertyChange("select-distinct", null, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean isSelectDistinct() {
        return this.m_SelectDistinct;
    }

    public void setDefaultSchema(String string) {
        this.m_DefaultSchema = string;
        this.m_PropertyChangeSupport.firePropertyChange("default-schema", null, this.m_DefaultSchema);
    }

    public String getDefaultSchema() {
        return this.m_DefaultSchema;
    }

    public void setQuoteString(String string) {
        this.m_QuoteString = string;
    }

    public String getQuoteString() {
        return this.m_QuoteString;
    }

    public void wipeQuery() {
        QBTable[] qBTableArray = this.getTables();
        for (int i = 0; i < qBTableArray.length; ++i) {
            QBColumn[] qBColumnArray = qBTableArray[i].getColumns();
            for (int j = 0; j < qBColumnArray.length; ++j) {
                QBColumn qBColumn = qBColumnArray[j];
                qBColumn.setColumnAlias("");
                qBColumn.setSort(0);
                qBColumn.setWhere("");
                qBColumn.setAggregate("");
                qBColumn.setHaving("");
            }
        }
        this.m_SelectedColumns.clear();
        this.m_SelectedTables.clear();
    }

    public void setCallBack(ArgumentMap.ICallback iCallback) {
        this.m_Callback = iCallback;
    }

    public ArrayList<String> getSelectedSchemas() {
        return this.m_SelectedSchema;
    }

    public void clearSelectedSchemas() {
        this.m_SelectedSchema.clear();
    }

    public boolean isSelectViewOnly() {
        return this.m_SelectViewsOnly;
    }

    public void setSelectViewOnly(boolean bl) {
        this.m_SelectViewsOnly = bl;
    }

    /*
     * WARNING - void declaration
     */
    public Element toXML() {
        void var3_7;
        Element element = new Element("qb");
        element.setAttribute("version", "1");
        if (this.m_Name != null) {
            element.setAttribute("name", this.m_Name);
        }
        if (this.m_DefaultSchema != null) {
            element.setAttribute("defaultSchema", this.m_DefaultSchema);
        }
        if (this.m_QuoteString != null) {
            element.setAttribute("quoteString", this.m_QuoteString);
        }
        element.setAttribute("selectDistinct", this.m_SelectDistinct ? "true" : "false");
        element.setAttribute("selectView", this.m_SelectViewsOnly ? "true" : "false");
        for (QBTable object : this.m_SelectedTables) {
            element.addContent((Content)object.toXML());
        }
        for (QBLink qBLink : this.m_Links) {
            element.addContent((Content)qBLink.toXML());
        }
        Iterator<Object> iterator = new Element("selectedschema");
        boolean bl = false;
        while (var3_7 < this.m_SelectedSchema.size()) {
            Element element2 = new Element("schema");
            element2.setAttribute("name", this.m_SelectedSchema.get((int)var3_7));
            iterator.addContent((Content)element2);
            ++var3_7;
        }
        element.addContent(iterator);
        return element;
    }

    public void fromXML(Element element) {
        String string = element.getAttributeValue("version");
        if (string == null || "1".equals(string)) {
            this.fromVersion1(element);
        }
    }

    public void fromVersion1(Element element) {
        this.m_Name = element.getAttributeValue("name");
        this.m_DefaultSchema = element.getAttributeValue("defaultSchema");
        this.m_QuoteString = element.getAttributeValue("quoteString");
        this.m_SelectDistinct = "true".equals(element.getAttributeValue("selectDistinct"));
        this.m_SelectViewsOnly = "true".equals(element.getAttributeValue("selectView"));
        for (Element object2 : element.getChildren("table")) {
            new QBTable(this, object2);
        }
        for (Element element2 : element.getChildren("link")) {
            QBColumn[] qBColumnArray = new QBLink(this, element2);
            if (!qBColumnArray.isValid() || this.isLinkBetween(qBColumnArray.getColumn1(), qBColumnArray.getColumn2())) continue;
            this.m_Links.add((QBLink)qBColumnArray);
        }
        for (QBTable qBTable : this.m_Tables) {
            if (qBTable.isSelected()) {
                this.m_SelectedTables.add(qBTable);
            }
            for (QBColumn qBColumn : qBTable.getColumns()) {
                if (!qBColumn.isSelected()) continue;
                this.m_SelectedColumns.add(qBColumn);
            }
        }
        this.m_SelectedSchema.clear();
        Iterator<Object> iterator = element.getChild("selectedschema");
        if (iterator != null) {
            List list = iterator.getChildren();
            for (Element element3 : list) {
                this.m_SelectedSchema.add(element3.getAttributeValue("name"));
            }
        }
    }
}

