/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.qb.model;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.TableIdentifier;
import com.elixirtech.jdom.Content;
import com.elixirtech.jdom.Element;
import com.elixirtech.qb.model.QBColumn;
import com.elixirtech.qb.model.QBLink;
import com.elixirtech.qb.model.QBModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class QBTable
implements Comparable<QBTable> {
    private QBModel m_Model;
    private TableIdentifier m_Identifier;
    private boolean m_IsSelected;
    private String m_PositionMemento;
    private Set<QBColumn> m_Columns = new TreeSet<QBColumn>();
    private List<QBLink> m_Links = new ArrayList<QBLink>();
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(QBTable.class);

    public QBTable(QBModel qBModel, TableIdentifier tableIdentifier) {
        this.m_Model = qBModel;
        this.m_Identifier = tableIdentifier;
        this.m_Model.addTable(this);
    }

    public QBTable(QBModel qBModel, Element element) {
        this.m_Model = qBModel;
        this.fromXML(element);
        this.m_Model.addTable(this);
    }

    public boolean hasColumns() {
        return !this.m_Columns.isEmpty();
    }

    public TableIdentifier getIdentifier() {
        return new TableIdentifier(this.m_Identifier);
    }

    @Override
    public int compareTo(QBTable qBTable) {
        return this.getName().compareTo(qBTable.getName());
    }

    public String toString() {
        return this.m_Identifier.toString();
    }

    public QBModel getModel() {
        return this.m_Model;
    }

    public String getType() {
        return this.m_Identifier.type;
    }

    public String getCatalog() {
        return this.m_Identifier.catalog;
    }

    public String getSchema() {
        return this.m_Identifier.schema;
    }

    public String getName() {
        return this.m_Identifier.table;
    }

    public void addColumn(QBColumn qBColumn) {
        this.m_Columns.add(qBColumn);
    }

    public QBColumn getColumn(String string) {
        if (this.m_Columns.isEmpty()) {
            this.loadColumns();
        }
        for (QBColumn qBColumn : this.m_Columns) {
            if (!qBColumn.getName().equals(string)) continue;
            return qBColumn;
        }
        return null;
    }

    public QBColumn[] getColumns() {
        if (this.m_Columns.isEmpty()) {
            this.loadColumns();
        }
        QBColumn[] qBColumnArray = new QBColumn[this.m_Columns.size()];
        this.m_Columns.toArray(qBColumnArray);
        return qBColumnArray;
    }

    public void addLink(QBLink qBLink) {
        this.m_Links.add(qBLink);
    }

    public void removeLink(QBLink qBLink) {
        this.m_Links.remove(qBLink);
    }

    public QBLink[] getLinks() {
        QBLink[] qBLinkArray = new QBLink[this.m_Links.size()];
        this.m_Links.toArray(qBLinkArray);
        return qBLinkArray;
    }

    public String getPositionMemento() {
        return this.m_PositionMemento;
    }

    public void setPositionMemento(String string) {
        this.m_PositionMemento = string;
    }

    public boolean isSelected() {
        return this.m_IsSelected;
    }

    public void setSelected(boolean bl) {
        this.m_IsSelected = bl;
        if (!this.m_IsSelected) {
            this.m_PositionMemento = null;
        }
    }

    protected void loadColumns() {
        try {
            this.getModel().getExtractor().fillTable(this);
        }
        catch (DataException dataException) {
            m_Log.warn((Object)("Can't load columns for " + this.getName()));
        }
    }

    public Element toXML() {
        Element element = new Element("table");
        element.setAttribute("isSelected", this.m_IsSelected ? "true" : "false");
        if (this.m_PositionMemento != null) {
            element.setAttribute("positionMemento", this.m_PositionMemento);
        }
        element.addContent((Content)this.m_Identifier.toXML());
        for (QBColumn qBColumn : this.m_Columns) {
            element.addContent((Content)qBColumn.toXML());
        }
        return element;
    }

    public void fromXML(Element element) {
        this.m_IsSelected = "true".equals(element.getAttributeValue("isSelected"));
        this.m_PositionMemento = element.getAttributeValue("positionMemento");
        this.m_Identifier = new TableIdentifier(element.getChild("id"));
        for (Element element2 : element.getChildren("column")) {
            this.m_Columns.add(new QBColumn(this, element2));
        }
    }
}

