/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.qb.sqlfactory;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.qb.model.QBColumn;
import com.elixirtech.qb.model.QBLink;
import com.elixirtech.qb.model.QBModel;
import com.elixirtech.qb.model.QBTable;
import com.elixirtech.qb.sqlfactory.ISQLFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public class BasicSQLFactory
implements ISQLFactory {
    public static final String SCHEMAS_IN_SELECT = "SchemasInSelect";
    private QBModel m_Model;
    private Properties m_Properties;

    public BasicSQLFactory(QBModel qBModel, Properties properties) {
        this.m_Model = qBModel;
        this.m_Properties = properties;
    }

    @Override
    public String[] getJoinTypes() {
        return new String[]{"Inner Join"};
    }

    @Override
    public String buildStatement() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.buildSelect());
        stringBuffer.append(this.buildFrom());
        stringBuffer.append(this.buildJoin());
        stringBuffer.append(this.buildWhere());
        if (this.hasAggregate()) {
            stringBuffer.append(this.buildGroupBy());
        }
        stringBuffer.append(this.buildOrder());
        stringBuffer.append(this.buildHaving());
        return stringBuffer.toString();
    }

    protected String buildSelect() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_Model.isSelectDistinct()) {
            stringBuffer.append("SELECT DISTINCT\n");
        } else {
            stringBuffer.append("SELECT\n");
        }
        int n = this.m_Model.getSelectedColumnCount();
        for (int i = 0; i < n; ++i) {
            String string;
            boolean bl;
            QBColumn qBColumn = this.m_Model.getSelectedColumn(i);
            String string2 = qBColumn.getAggregate();
            boolean bl2 = bl = string2 != null && string2.trim().length() > 0;
            if (bl) {
                stringBuffer.append(string2);
                stringBuffer.append('(');
            }
            QBTable qBTable = qBColumn.getTable();
            if (this.isSchemasInSelect()) {
                stringBuffer.append(this.identityName(qBTable));
            } else {
                stringBuffer.append(this.identityName(qBTable.getName()));
            }
            stringBuffer.append('.');
            stringBuffer.append(this.identityName(qBColumn.getName()));
            if (bl) {
                stringBuffer.append(')');
            }
            if (StringUtil.notEmpty((String)(string = qBColumn.getColumnAlias()))) {
                stringBuffer.append(" AS ");
                stringBuffer.append(this.identityName(string));
            }
            if (i >= n - 1) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    protected String buildFrom() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.m_Model.getSelectedColumnCount();
        TreeSet<QBTable> treeSet = new TreeSet<QBTable>();
        for (int i = 0; i < n; ++i) {
            QBColumn comparable = this.m_Model.getSelectedColumn(i);
            QBTable qBTable = comparable.getTable();
            treeSet.add(qBTable);
        }
        treeSet.removeAll(this.innerJoinTables(this.m_Model));
        for (QBTable qBTable : treeSet) {
            if (stringBuffer.length() == 0) {
                stringBuffer.append("\nFROM ");
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.identityName(qBTable));
        }
        return stringBuffer.toString();
    }

    protected String buildJoin() {
        if (this.m_Model.getSelectedColumnCount() == 0) {
            return "";
        }
        HashSet<QBTable> hashSet = new HashSet<QBTable>();
        QBTable qBTable = this.getPrimaryTable(this.m_Model);
        hashSet.add(qBTable);
        StringBuffer stringBuffer = new StringBuffer();
        Set<QBTable> set = this.m_Model.getSelectedColumnsTableSet();
        QBLink[] qBLinkArray = this.m_Model.getLinks();
        HashMap<String, List<QBLink>> hashMap = new HashMap<String, List<QBLink>>();
        for (int i = 0; i < qBLinkArray.length; ++i) {
            List<QBLink> list;
            String string;
            QBColumn qBColumn = qBLinkArray[i].getColumn1();
            QBColumn qBColumn2 = qBLinkArray[i].getColumn2();
            if (hashSet.contains(qBColumn.getTable())) {
                string = qBColumn2.getTable().getName();
                list = (ArrayList<QBLink>)hashMap.get(string);
                if (list == null) {
                    list = new ArrayList<QBLink>();
                    hashMap.put(string, list);
                }
                list.add(qBLinkArray[i]);
                continue;
            }
            if (!hashSet.contains(qBColumn2.getTable())) continue;
            string = qBColumn.getTable().getName();
            list = (List)hashMap.get(string);
            if (list == null) {
                list = new ArrayList();
                hashMap.put(string, list);
            }
            list.add(qBLinkArray[i]);
        }
        stringBuffer.append(this.buildInnerJoin(hashSet, set, hashMap));
        return stringBuffer.toString();
    }

    private String buildInnerJoin(Set<QBTable> set, Set<QBTable> set2, Map<String, List<QBLink>> map) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : map.keySet()) {
            List<QBLink> list = map.get(string);
            boolean bl = true;
            for (int i = 0; i < list.size(); ++i) {
                QBLink qBLink = list.get(i);
                QBColumn qBColumn = qBLink.getColumn1();
                QBColumn qBColumn2 = qBLink.getColumn2();
                if (!set2.contains(qBColumn.getTable()) || !set2.contains(qBColumn2.getTable())) continue;
                Linked linked = this.isPotentialLink(set, qBColumn, qBColumn2);
                if (linked.linked) {
                    if (bl) {
                        stringBuffer.append("\nINNER JOIN ");
                        stringBuffer.append(this.identityName(linked.left.getTable()));
                        stringBuffer.append(" ON ");
                        bl = false;
                    } else {
                        stringBuffer.append(" AND ");
                    }
                    stringBuffer.append(this.getColumnNameOrAlias(linked.left));
                    stringBuffer.append('=');
                    stringBuffer.append(this.getColumnNameOrAlias(linked.right));
                }
                stringBuffer.append(' ');
            }
        }
        return stringBuffer.toString();
    }

    private Linked isPotentialLink(Set<QBTable> set, QBColumn qBColumn, QBColumn qBColumn2) {
        Linked linked = new Linked();
        if (set.contains(qBColumn.getTable())) {
            linked.left = qBColumn2;
            linked.right = qBColumn;
            set.add(qBColumn2.getTable());
            linked.linked = true;
        } else if (set.contains(qBColumn2.getTable())) {
            linked.left = qBColumn;
            linked.right = qBColumn2;
            set.add(qBColumn.getTable());
            linked.linked = true;
        } else {
            linked.linked = false;
        }
        return linked;
    }

    protected String buildWhere() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.m_Model.getSelectedColumnCount();
        for (int i = 0; i < n; ++i) {
            QBColumn qBColumn = this.m_Model.getSelectedColumn(i);
            Object object = qBColumn.getWhere();
            if (!StringUtil.notEmpty((String)object)) continue;
            if (stringBuffer.length() == 0) {
                stringBuffer.append("\nWHERE ");
            } else {
                stringBuffer.append(" AND ");
            }
            if (((String)object).indexOf("$c") < 0) {
                object = "$c" + (String)object;
            }
            stringBuffer.append(this.format((String)object, qBColumn));
        }
        return stringBuffer.toString();
    }

    protected String buildGroupBy() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.m_Model.getSelectedColumnCount();
        for (int i = 0; i < n; ++i) {
            QBColumn qBColumn = this.m_Model.getSelectedColumn(i);
            String string = qBColumn.getAggregate();
            if (string != null && string.trim().length() != 0) continue;
            if (stringBuffer.length() == 0) {
                stringBuffer.append("\nGROUP BY ");
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.identityName(qBColumn.getFullName()));
        }
        return stringBuffer.toString();
    }

    protected String buildOrder() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.m_Model.getSelectedColumnCount();
        for (int i = 0; i < n; ++i) {
            QBColumn qBColumn = this.m_Model.getSelectedColumn(i);
            int n2 = qBColumn.getSort();
            if (n2 == 0) continue;
            if (stringBuffer.length() == 0) {
                stringBuffer.append("\nORDER BY ");
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.getColumnName(qBColumn));
            if (n2 == 1) {
                stringBuffer.append(" ASC");
                continue;
            }
            stringBuffer.append(" DESC");
        }
        return stringBuffer.toString();
    }

    protected String buildHaving() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.m_Model.getSelectedColumnCount();
        for (int i = 0; i < n; ++i) {
            QBColumn qBColumn = this.m_Model.getSelectedColumn(i);
            Object object = qBColumn.getHaving();
            if (object == null || ((String)object).trim().length() <= 0) continue;
            if (stringBuffer.length() == 0) {
                stringBuffer.append("\nHAVING ");
            } else {
                stringBuffer.append(", ");
            }
            if (((String)object).indexOf("$c") < 0) {
                object = "$c" + (String)object;
            }
            stringBuffer.append(this.format((String)object, qBColumn));
        }
        return stringBuffer.toString();
    }

    protected String identityName(String string) {
        String string2 = string.trim();
        if (this.needsQuoting(string2)) {
            String string3 = this.m_Model.getQuoteString();
            return string3 + string2 + string3;
        }
        return string2;
    }

    protected boolean needsQuoting(String string) {
        String string2 = string.trim();
        int n = string2.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isLetter(string2.charAt(i))) continue;
            return true;
        }
        return false;
    }

    protected String identityName(QBTable qBTable) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = qBTable.getSchema();
        if (StringUtil.notEmpty((String)string) && !string.equals(this.m_Model.getDefaultSchema())) {
            stringBuilder.append(this.identityName(string));
            stringBuilder.append(".");
        }
        stringBuilder.append(this.identityName(qBTable.getName()));
        return stringBuilder.toString();
    }

    protected String format(String string, QBColumn qBColumn) {
        int n = string.indexOf("$c");
        if (n < 0) {
            return string;
        }
        return string.substring(0, n) + this.getColumnName(qBColumn) + string.substring(n + 2);
    }

    protected String getColumnNameOrAlias(QBColumn qBColumn) {
        String string = qBColumn.getColumnAlias();
        if (StringUtil.notEmpty((String)string)) {
            return string;
        }
        return this.getColumnName(qBColumn);
    }

    protected String getColumnName(QBColumn qBColumn) {
        return this.identityName(qBColumn.getTable()) + "." + this.identityName(qBColumn.getName());
    }

    protected boolean hasAggregate() {
        int n = this.m_Model.getSelectedColumnCount();
        for (int i = 0; i < n; ++i) {
            QBColumn qBColumn = this.m_Model.getSelectedColumn(i);
            String string = qBColumn.getAggregate();
            if (!StringUtil.notEmpty((String)string)) continue;
            return true;
        }
        return false;
    }

    protected Set<QBTable> innerJoinTables(QBModel qBModel) {
        HashSet<QBTable> hashSet = new HashSet<QBTable>();
        if (qBModel.getSelectedColumnCount() == 0) {
            return hashSet;
        }
        QBTable qBTable = this.getPrimaryTable(qBModel);
        HashSet<QBTable> hashSet2 = new HashSet<QBTable>();
        hashSet2.add(qBTable);
        Set<QBTable> set = qBModel.getSelectedColumnsTableSet();
        QBLink[] qBLinkArray = qBModel.getLinks();
        for (int i = 0; i < qBLinkArray.length; ++i) {
            QBColumn qBColumn = qBLinkArray[i].getColumn1();
            QBColumn qBColumn2 = qBLinkArray[i].getColumn2();
            if (!set.contains(qBColumn.getTable()) || !set.contains(qBColumn2.getTable())) continue;
            boolean bl = hashSet2.contains(qBColumn.getTable());
            boolean bl2 = hashSet2.contains(qBColumn2.getTable());
            if (bl && !bl2) {
                hashSet.add(qBColumn2.getTable());
                hashSet2.add(qBColumn2.getTable());
                continue;
            }
            if (!bl2 || bl) continue;
            hashSet.add(qBColumn.getTable());
            hashSet2.add(qBColumn.getTable());
        }
        return hashSet;
    }

    private QBTable getPrimaryTable(QBModel qBModel) {
        Object[] objectArray;
        Object object;
        Set<QBTable> set = qBModel.getSelectedColumnsTableSet();
        QBLink[] qBLinkArray = qBModel.getLinks();
        HashSet<QBTable> hashSet = new HashSet<QBTable>();
        HashSet<QBTable> hashSet2 = new HashSet<QBTable>();
        for (int i = 0; i < qBLinkArray.length; ++i) {
            object = qBLinkArray[i].getColumn1();
            objectArray = qBLinkArray[i].getColumn2();
            QBTable qBTable = ((QBColumn)object).getTable();
            QBTable qBTable2 = objectArray.getTable();
            if (set.contains(qBTable)) {
                hashSet2.add(qBTable);
            }
            if (!set.contains(qBTable2)) continue;
            hashSet.add(qBTable2);
        }
        HashSet hashSet3 = new HashSet(hashSet);
        hashSet3.removeAll(hashSet2);
        if (hashSet3.size() == 1) {
            object = (QBTable)hashSet3.iterator().next();
        } else if (hashSet3.isEmpty()) {
            object = qBModel.getSelectedColumn(0).getTable();
        } else {
            objectArray = hashSet3.toArray(new QBTable[0]);
            Arrays.sort(objectArray);
            object = objectArray[0];
        }
        return object;
    }

    private boolean isSchemasInSelect() {
        return "Yes".equals(this.m_Properties.get(SCHEMAS_IN_SELECT));
    }

    private static class Linked {
        public QBColumn left;
        public QBColumn right;
        public boolean linked;

        private Linked() {
        }
    }
}

