/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.qb.ui;

import com.elixirtech.qb.jdbc.JDBCDialect;
import com.elixirtech.qb.jdbc.JDBCDialects$;
import com.elixirtech.qb.model.QBModel;
import com.elixirtech.qb.sqlfactory.BasicSQLFactory;
import com.elixirtech.qb.sqlfactory.ISQLFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Properties;
import javax.swing.JTextArea;
import scala.Function1;

public class BottomSQLView
extends JTextArea
implements PropertyChangeListener {
    private ISQLFactory m_SQLFactory = null;
    private String m_Error = "";
    private QBModel m_Model;

    public BottomSQLView(QBModel model) {
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.m_Model = model;
        this.loadFactory();
        this.m_Model().addPropertyChangeListener(this);
        this.buildStatement();
    }

    public ISQLFactory m_SQLFactory() {
        return this.m_SQLFactory;
    }

    public void m_SQLFactory_$eq(ISQLFactory x$1) {
        this.m_SQLFactory = x$1;
    }

    public String m_Error() {
        return this.m_Error;
    }

    public void m_Error_$eq(String x$1) {
        this.m_Error = x$1;
    }

    public QBModel m_Model() {
        return this.m_Model;
    }

    public void m_Model_$eq(QBModel x$1) {
        this.m_Model = x$1;
    }

    private void loadFactory() {
        String key = this.m_Model().getDriverKey();
        JDBCDialect dialect = JDBCDialects$.MODULE$.getDriverDialect(key);
        try {
            Properties props = new Properties();
            dialect.properties().foreach((Function1 & Serializable)pair -> props.setProperty((String)pair._1(), (String)pair._2()));
            this.m_SQLFactory_$eq(new BasicSQLFactory(this.m_Model(), props));
        }
        catch (Exception ex) {
            this.m_Error_$eq("Can't load SQLFactory for " + dialect.name());
        }
    }

    public ISQLFactory getFactory() {
        return this.m_SQLFactory();
    }

    public void setModel(QBModel model) {
        if (this.m_Model() != null) {
            this.m_Model().removePropertyChangeListener(this);
        }
        this.m_Model_$eq(model);
        this.loadFactory();
        this.m_Model().addPropertyChangeListener(this);
    }

    public void buildStatement() {
        if (this.m_SQLFactory() == null) {
            this.setText(this.m_Error());
            return;
        }
        this.setText(this.m_SQLFactory().buildStatement());
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        String string = ev.getPropertyName();
        String string2 = "driver";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.loadFactory();
        }
        this.buildStatement();
    }

    public String getSQLString() {
        return this.getText();
    }
}

