/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.qb.ui;

import com.elixirtech.qb.I18N;
import com.elixirtech.qb.model.QBColumn;
import com.elixirtech.qb.model.QBModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.table.AbstractTableModel;

class BottomTableModel
extends AbstractTableModel
implements PropertyChangeListener {
    private QBModel m_Model;
    public static final String[] SORTS = new String[]{"None", "Ascending", "Descending"};
    public static final String[] AGGREGATES = new String[]{"", "AVG", "COUNT", "MAX", "MIN", "SUM"};
    static final String[] ROWS = new String[]{"Column", "Schema", "Table", "Alias", "Sort", "Where", "Aggregate", "Having"};
    static final String[] ROWS_UI = new String[ROWS.length];

    public BottomTableModel(QBModel qBModel) {
        this.m_Model = qBModel;
        this.m_Model.addPropertyChangeListener(this);
    }

    public void setModel(QBModel qBModel) {
        if (this.m_Model != null) {
            this.m_Model.removePropertyChangeListener(this);
        }
        this.m_Model = qBModel;
        this.m_Model.addPropertyChangeListener(this);
        this.fireTableStructureChanged();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("selected-columns")) {
            this.fireTableStructureChanged();
        }
    }

    @Override
    public int getColumnCount() {
        return this.m_Model.getSelectedColumnCount();
    }

    @Override
    public String getColumnName(int n) {
        return this.m_Model.getSelectedColumn(n).getName();
    }

    @Override
    public int getRowCount() {
        return ROWS_UI.length - 1;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        QBColumn qBColumn = this.m_Model.getSelectedColumn(n2);
        switch (n) {
            case 0: {
                return qBColumn.getTable().getSchema();
            }
            case 1: {
                return qBColumn.getTable().getName();
            }
            case 2: {
                return qBColumn.getColumnAlias();
            }
            case 3: {
                return SORTS[qBColumn.getSort()];
            }
            case 4: {
                return qBColumn.getWhere();
            }
            case 5: {
                return qBColumn.getAggregate();
            }
            case 6: {
                return qBColumn.getHaving();
            }
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (n == 0) {
            return false;
        }
        return n != 1;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (object == null) {
            return;
        }
        QBColumn qBColumn = this.m_Model.getSelectedColumn(n2);
        switch (n) {
            case 2: {
                qBColumn.setColumnAlias(object.toString());
                break;
            }
            case 3: {
                qBColumn.setSort(this.getSortIndex((String)object));
                break;
            }
            case 4: {
                qBColumn.setWhere(object.toString());
                break;
            }
            case 5: {
                qBColumn.setAggregate(object.toString());
                break;
            }
            case 6: {
                qBColumn.setHaving(object.toString());
                break;
            }
        }
        this.m_Model.firePropertyChange("column", null, qBColumn);
    }

    private int getSortIndex(String string) {
        for (int i = 0; i < SORTS.length; ++i) {
            if (!SORTS[i].equals(string)) continue;
            return i;
        }
        return 0;
    }

    static {
        for (int i = 0; i < ROWS.length; ++i) {
            BottomTableModel.ROWS_UI[i] = I18N.QueryBuilder().getString("QBTable." + ROWS[i]);
        }
    }
}

