/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.qb.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;
import java.util.Hashtable;

public class LabelLayoutEx
implements LayoutManager,
Serializable {
    public static final int TOP = 1;
    public static final int CENTER = 2;
    public static final int BOTTOM = 3;
    private int m_HGap;
    private int m_VGap;
    private int m_Alignment;
    private Hashtable<Component, String> m_Map = new Hashtable();

    public LabelLayoutEx() {
        this(5, 0);
    }

    public LabelLayoutEx(int n, int n2) {
        this(n, n2, 1);
    }

    public LabelLayoutEx(int n, int n2, int n3) {
        this.m_HGap = n;
        this.m_VGap = n2;
        this.m_Alignment = n3;
    }

    public void setVerticalAlignment(int n) {
        this.m_Alignment = n;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        this.m_Map.put(component, string == null ? "" : string);
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this.m_Map.remove(component);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        return this.minimumLayoutSize(container);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        Component[] componentArray = container.getComponents();
        Insets insets = container.getInsets();
        int n = componentArray.length;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n / 2; ++i) {
            Dimension dimension = this.minimumLayoutSize(container, i);
            if (n2 < dimension.width) {
                n2 = dimension.width;
            }
            n3 += dimension.height;
            if (i + 1 >= n / 2) continue;
            n3 += this.m_VGap;
        }
        return new Dimension(insets.left + n2 + insets.right, insets.top + n3 + insets.bottom);
    }

    private Dimension minimumLayoutSize(Container container, int n) {
        Component[] componentArray = container.getComponents();
        Component component = componentArray[n * 2];
        Component component2 = componentArray[n * 2 + 1];
        Dimension dimension = component.getPreferredSize();
        Dimension dimension2 = component2.getPreferredSize();
        return new Dimension(dimension.width + this.m_HGap + dimension2.width, Math.max(dimension.height, dimension2.height));
    }

    @Override
    public void layoutContainer(Container container) {
        int n;
        Component[] componentArray = container.getComponents();
        Dimension dimension = container.getSize();
        if (dimension.width == 0 || dimension.height == 0) {
            return;
        }
        Insets insets = container.getInsets();
        int n2 = 0;
        int n3 = componentArray.length;
        for (n = 0; n < n3; n += 2) {
            Component component = componentArray[n];
            Dimension dimension2 = component.getPreferredSize();
            if (dimension2.width <= n2) continue;
            n2 = dimension2.width;
        }
        n = insets.top;
        int n4 = insets.left + this.m_HGap + n2;
        int n5 = dimension.width - insets.right - n4;
        for (int i = 0; i < n3 / 2; ++i) {
            Component component = componentArray[i * 2];
            Component component2 = componentArray[i * 2 + 1];
            Dimension dimension3 = component.getPreferredSize();
            Dimension dimension4 = component2.getPreferredSize();
            int n6 = 0;
            if (this.m_Alignment == 2) {
                n6 = dimension3.height > dimension4.height ? (dimension3.height - dimension4.height) / 2 : (dimension4.height - dimension3.height) / 2;
            } else if (this.m_Alignment == 3) {
                n6 = dimension3.height > dimension4.height ? dimension3.height - dimension4.height : dimension4.height - dimension3.height;
            }
            String string = this.m_Map.get(component2);
            if (dimension4.height > dimension3.height) {
                component.setBounds(insets.left, n + n6, n2, dimension3.height);
                if (string != null && string.equals("FIXED")) {
                    component2.setBounds(n4, n, dimension4.width, dimension4.height);
                } else {
                    component2.setBounds(n4, n, n5, dimension4.height);
                }
            } else {
                component.setBounds(insets.left, n, n2, dimension3.height);
                if (string != null && string.equals("FIXED")) {
                    component2.setBounds(n4, n + n6, dimension4.width, dimension4.height);
                } else {
                    component2.setBounds(n4, n + n6, n5, dimension4.height);
                }
            }
            n += Math.max(dimension3.height, dimension4.height);
            n += this.m_VGap;
        }
    }
}

