/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.qb.ui;

import com.elixirtech.qb.model.QBLink;
import com.elixirtech.qb.model.QBTable;
import com.elixirtech.qb.ui.LeftTreeView;
import com.elixirtech.qb.ui.QBFrame;
import com.elixirtech.qb.ui.QBLinkTreeNode;
import com.elixirtech.qb.ui.QBTableTreeNode;
import com.elixirtech.qb.ui.action.AddLinkDialog;
import com.elixirtech.qb.ui.action.DeleteLink;
import com.elixirtech.qb.ui.action.HideTable;
import com.elixirtech.qb.ui.action.ShowTable;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class LeftTreeListener
extends MouseAdapter {
    private QBFrame m_Frame;
    private JTree m_Tree;

    public LeftTreeListener(QBFrame qBFrame, JTree jTree) {
        this.m_Frame = qBFrame;
        this.m_Tree = jTree;
        this.m_Tree.addMouseListener(this);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        TreePath treePath = this.m_Tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        this.m_Tree.setSelectionPath(treePath);
        if (mouseEvent.isPopupTrigger()) {
            this.doPopup(mouseEvent);
        } else if (mouseEvent.getClickCount() == 2) {
            this.doDoubleClick(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        TreePath treePath = this.m_Tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        this.m_Tree.setSelectionPath(treePath);
        if (mouseEvent.isPopupTrigger()) {
            this.doPopup(mouseEvent);
        }
    }

    protected void doPopup(MouseEvent mouseEvent) {
        LeftTreeView leftTreeView = (LeftTreeView)this.m_Tree.getModel();
        TreePath treePath = this.m_Tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (defaultMutableTreeNode == leftTreeView.getTablesNode()) {
                return;
            }
            JPopupMenu jPopupMenu = new JPopupMenu();
            if (defaultMutableTreeNode == leftTreeView.getRelationshipsNode()) {
                jPopupMenu.add(new JMenuItem(new AddLinkDialog(this.m_Frame)));
            } else if (defaultMutableTreeNode.getUserObject() instanceof QBTableTreeNode) {
                QBTableTreeNode qBTableTreeNode = (QBTableTreeNode)defaultMutableTreeNode.getUserObject();
                QBTable qBTable = qBTableTreeNode.getTable();
                jPopupMenu.add(new JMenuItem(new ShowTable(qBTable)));
                jPopupMenu.add(new JMenuItem(new HideTable(qBTable)));
            } else if (defaultMutableTreeNode.getUserObject() instanceof QBLinkTreeNode) {
                QBLink qBLink = ((QBLinkTreeNode)defaultMutableTreeNode.getUserObject()).getLink();
                jPopupMenu.add(new JMenuItem(new DeleteLink(this.m_Frame, qBLink)));
            }
            jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void doDoubleClick(MouseEvent mouseEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        Object object;
        TreePath treePath = this.m_Tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath != null && (object = (defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject()) instanceof QBTableTreeNode) {
            QBTable qBTable = ((QBTableTreeNode)object).getTable();
            if (qBTable.isSelected()) {
                Toolkit.getDefaultToolkit().beep();
            } else {
                qBTable.getModel().selectTable(qBTable);
            }
        }
    }
}

