/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.qb.ui;

import com.elixirtech.i18n.I18NBypass;
import com.elixirtech.i18n.I18NUtil;
import com.elixirtech.icons.StandardIcons;
import com.elixirtech.qb.I18N;
import com.elixirtech.qb.model.QBLink;
import com.elixirtech.qb.model.QBModel;
import com.elixirtech.qb.model.QBTable;
import com.elixirtech.qb.ui.QBLinkTreeNode;
import com.elixirtech.qb.ui.QBTableTreeNode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.JLabel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class LeftTreeView
extends DefaultTreeModel
implements PropertyChangeListener {
    private QBModel m_Model;
    private DefaultMutableTreeNode m_Tables;
    private DefaultMutableTreeNode m_Relationships;
    private boolean m_ShowViews;

    public LeftTreeView(QBModel qBModel) {
        super(new DefaultMutableTreeNode("Root"));
        this.m_Model = qBModel;
        this.m_Model.addPropertyChangeListener(this);
        this.m_Tables = new DefaultMutableTreeNode(this.getObject("Tables"));
        this.m_Relationships = new DefaultMutableTreeNode(this.getObject("Relationships"));
        ((DefaultMutableTreeNode)this.getRoot()).insert(this.m_Tables, 0);
        ((DefaultMutableTreeNode)this.getRoot()).insert(this.m_Relationships, 1);
        this.buildTree();
    }

    public void setModel(QBModel qBModel) {
        if (this.m_Model != null) {
            this.m_Model.removePropertyChangeListener(this);
        }
        this.m_Model = qBModel;
        this.m_Model.addPropertyChangeListener(this);
        this.buildTree();
    }

    public void showViews(boolean bl) {
        this.m_ShowViews = bl;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("links")) {
            this.buildTree();
        }
    }

    public QBModel getModel() {
        return this.m_Model;
    }

    public DefaultMutableTreeNode getTablesNode() {
        return this.m_Tables;
    }

    public DefaultMutableTreeNode getRelationshipsNode() {
        return this.m_Relationships;
    }

    private void buildTree() {
        QBTable[] qBTableArray = this.m_Model.getTables();
        this.m_Tables.removeAllChildren();
        TreeMap<String, Set<String>> treeMap = new TreeMap<String, Set<String>>();
        TreeMap<String, Set<QBTable>> treeMap2 = new TreeMap<String, Set<QBTable>>();
        for (int i = 0; i < qBTableArray.length; ++i) {
            TreeSet<String> treeSet;
            String string;
            if (!this.isVisible(qBTableArray[i])) continue;
            String string2 = qBTableArray[i].getCatalog();
            if (string2 == null) {
                string2 = "";
            }
            if ((string = qBTableArray[i].getSchema()) == null) {
                string = "";
            }
            if ((treeSet = (TreeSet<String>)treeMap.get(string2)) == null) {
                treeSet = new TreeSet<String>();
                treeMap.put(string2, treeSet);
            }
            treeSet.add(string);
            TreeSet<QBTable> treeSet2 = (TreeSet<QBTable>)treeMap2.get(string);
            if (treeSet2 == null) {
                treeSet2 = new TreeSet<QBTable>();
                treeMap2.put(string, treeSet2);
            }
            treeSet2.add(qBTableArray[i]);
        }
        if (treeMap.size() > 1) {
            this.buildCatalog(treeMap, treeMap2);
        } else if (treeMap2.size() > 1) {
            this.buildSchemas(this.m_Tables, treeMap2);
        } else if (treeMap2.size() == 1) {
            Set set = (Set)treeMap2.values().iterator().next();
            this.buildTables(this.m_Tables, set);
        }
        QBLink[] qBLinkArray = this.m_Model.getLinks();
        this.m_Relationships.removeAllChildren();
        for (int i = 0; i < qBLinkArray.length; ++i) {
            this.m_Relationships.add(new DefaultMutableTreeNode(new QBLinkTreeNode(qBLinkArray[i])));
        }
        this.nodeStructureChanged(this.m_Tables);
        this.nodeStructureChanged(this.m_Relationships);
    }

    private void buildCatalog(Map<String, Set<String>> map, Map<String, Set<QBTable>> map2) {
        for (String string : map.keySet()) {
            Set<String> set = map.get(string);
            DefaultMutableTreeNode defaultMutableTreeNode = this.getFolder(string);
            this.m_Tables.add(defaultMutableTreeNode);
            TreeMap<String, Set<QBTable>> treeMap = new TreeMap<String, Set<QBTable>>();
            for (String string2 : set) {
                treeMap.put(string2, map2.get(string2));
            }
            this.buildSchemas(defaultMutableTreeNode, treeMap);
        }
    }

    private void buildSchemas(DefaultMutableTreeNode defaultMutableTreeNode, Map<String, Set<QBTable>> map) {
        for (String string : map.keySet()) {
            Set<QBTable> set = map.get(string);
            DefaultMutableTreeNode defaultMutableTreeNode2 = this.getFolder(string);
            this.m_Tables.add(defaultMutableTreeNode2);
            this.buildTables(defaultMutableTreeNode2, set);
        }
    }

    private void buildTables(DefaultMutableTreeNode defaultMutableTreeNode, Set<QBTable> set) {
        for (QBTable qBTable : set) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(new QBTableTreeNode(qBTable)));
        }
    }

    private boolean isVisible(QBTable qBTable) {
        if (!this.m_Model.getSelectedSchemas().isEmpty() && !this.m_Model.getSelectedSchemas().contains(qBTable.getSchema())) {
            return false;
        }
        if ("VIEW".equals(qBTable.getType())) {
            return this.m_ShowViews;
        }
        return "TABLE".equals(qBTable.getType());
    }

    private Object getObject(String string) {
        JLabel jLabel = new JLabel(I18N.QueryBuilder().getString(string), I18NUtil.getIcon(I18N.QueryBuilder(), string), 0);
        jLabel.setOpaque(false);
        return jLabel;
    }

    private DefaultMutableTreeNode getFolder(String string) {
        JLabel jLabel = I18NBypass.newLabel(string);
        jLabel.setIcon(StandardIcons.FOLDER);
        jLabel.setOpaque(false);
        return new DefaultMutableTreeNode(jLabel);
    }
}

