/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.qb.ui;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.IErrorHandler;
import com.elixirtech.arch.IUser;
import com.elixirtech.arch.ManagedDialog;
import com.elixirtech.data2.datasource.jdbc.JDBCConnector;
import com.elixirtech.i18n.I18NUtilJ;
import com.elixirtech.i18n.IUIFactory;
import com.elixirtech.icons.EnsembleIcons;
import com.elixirtech.qb.I18N;
import com.elixirtech.qb.QBAction;
import com.elixirtech.qb.jdbc.SchemaExtractor3;
import com.elixirtech.qb.model.QBModel;
import com.elixirtech.qb.model.QBTable;
import com.elixirtech.qb.ui.BottomSQLView;
import com.elixirtech.qb.ui.BottomTableModel;
import com.elixirtech.qb.ui.I18NCellRenderer;
import com.elixirtech.qb.ui.IQBHost;
import com.elixirtech.qb.ui.LeftTree;
import com.elixirtech.qb.ui.QBSchemaFilterDialog;
import com.elixirtech.qb.ui.QBView;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.TableUtil;
import com.elixirtech.ui.table.ElxTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class QBFrame {
    IUIFactory m_Factory;
    IQBHost m_Host;
    private JDialog m_Dialog;
    private JSplitPane m_VSplitter;
    private JSplitPane m_HSplitter;
    JCheckBox m_SelectDistinct;
    JComboBox m_DefaultSchema;
    JButton m_FilterSchema;
    JCheckBox m_CBView;
    QBView m_View;
    QBModel m_Model;
    private JTable m_BottomTable;
    private BottomTableModel m_BottomTableModel;
    private BottomSQLView m_BottomSQLView;
    private LeftTree m_LeftTree;
    private ItemListener m_ItemListener = new MyItemListener();
    private String m_Filter = "";

    public QBFrame(JFrame jFrame, IQBHost iQBHost, QBModel qBModel, boolean bl) {
        this.m_Factory = (IUIFactory)Elixir.get(IUIFactory.class);
        this.m_Host = iQBHost;
        this.m_Model = qBModel;
        this.m_Dialog = new ManagedDialog("QueryBuilder", jFrame, this.getString("QB.ELIXIR-Query-Builder"), bl);
        this.m_Dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (QBFrame.this.canExit()) {
                    QBFrame.this.savePreferences();
                    QBFrame.this.dispose();
                }
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                QBFrame.this.dispose();
            }
        });
        this.m_View = new QBView(this);
        this.m_BottomTableModel = new BottomTableModel(qBModel);
        this.m_BottomSQLView = new BottomSQLView(qBModel);
        this.m_LeftTree = new LeftTree(this, qBModel);
        Container container = this.m_Dialog.getContentPane();
        this.m_VSplitter = SwingFactory.newVerticalSplit(this.getTopPanel(), this.getBottomPanel());
        IUser iUser = (IUser)Elixir.get(IUser.class);
        this.m_VSplitter.setDividerLocation(iUser.getSplit("QueryBuilder_VSplit", 260));
        container.add(this.m_VSplitter);
        container.add((Component)this.getButtonPanel(), "South");
        this.m_Dialog.setSize(new Dimension(700, 500));
        this.m_Dialog.setLocationRelativeTo(jFrame);
        this.m_Dialog.setDefaultCloseOperation(0);
        this.m_FilterSchema.setEnabled(qBModel.getSchemas().length > 1);
        this.m_CBView.setSelected(qBModel.isSelectViewOnly());
    }

    public QBModel getModel() {
        return this.m_Model;
    }

    public void setModel(QBModel qBModel) {
        this.m_Model = qBModel;
        this.m_View.setModel(qBModel);
        this.m_BottomTableModel.setModel(qBModel);
        this.m_BottomSQLView.setModel(qBModel);
        this.m_LeftTree.setModel(qBModel);
        this.m_SelectDistinct.setSelected(qBModel.isSelectDistinct());
        String[] stringArray = qBModel.getSchemas();
        this.m_DefaultSchema.setModel(new DefaultComboBoxModel<String>(stringArray));
        this.m_DefaultSchema.setSelectedItem(qBModel.getDefaultSchema());
        this.m_FilterSchema.setEnabled(stringArray.length > 1);
        this.m_CBView.setSelected(qBModel.isSelectViewOnly());
    }

    public JDialog getDialog() {
        return this.m_Dialog;
    }

    public boolean canExit() {
        return true;
    }

    public void error(String string) {
        ((IErrorHandler)Elixir.get(IErrorHandler.class)).userError(string);
    }

    public String getSQLString() {
        return this.m_BottomSQLView.getSQLString();
    }

    public String getFilter() {
        return this.m_Filter;
    }

    public void setFilter(String string) {
        this.m_Filter = string;
    }

    public boolean checkShowView() {
        return this.m_CBView.isSelected();
    }

    protected JComponent getButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2));
        if (this.m_Host != null) {
            JButton jButton = SwingFactory.newOkButton(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableUtil.disposeEditor(QBFrame.this.m_BottomTable);
                    QBFrame.this.savePreferences();
                    String string = QBFrame.this.getSQLString();
                    QBFrame.this.dispose();
                    QBFrame.this.m_Host.queryBuilt(QBFrame.this.m_Model, string);
                }
            });
            JButton jButton2 = SwingFactory.newCancelButton(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    QBFrame.this.savePreferences();
                    QBFrame.this.dispose();
                    QBFrame.this.m_Host.queryCancelled();
                }
            });
            jPanel.add(jButton);
            jPanel.add(jButton2);
        }
        I18N.QueryBuilderMap().injectComponents("QB.", jPanel);
        return jPanel;
    }

    protected JComponent getTopPanel() {
        this.m_HSplitter = SwingFactory.newHorizontalSplit(this.getLeftPanel(), this.getRightPanel());
        IUser iUser = (IUser)Elixir.get(IUser.class);
        this.m_HSplitter.setDividerLocation(iUser.getSplit("QueryBuilder_HSplit", 200));
        return this.m_HSplitter;
    }

    protected JComponent getBottomPanel() {
        final JTabbedPane jTabbedPane = new JTabbedPane(3);
        jTabbedPane.add((Component)this.getTablePane(), this.getString("QB.Details"));
        jTabbedPane.add((Component)this.getSQLPane(), this.getString("QB.SQL"));
        jTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n = jTabbedPane.getSelectedIndex();
                if (n == 1) {
                    TableUtil.disposeEditor(QBFrame.this.m_BottomTable);
                }
            }
        });
        return jTabbedPane;
    }

    protected JComponent getLeftPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JToolBar jToolBar = SwingFactory.newToolBar();
        JButton jButton = SwingFactory.newButton("QB.Refresh", new ExtractAction());
        jButton.setText("");
        jButton.setIcon(EnsembleIcons.REFRESH);
        jButton.setToolTipText(this.getString("QB.Refresh"));
        jToolBar.add(jButton);
        this.m_FilterSchema = SwingFactory.newButton("QB.Filter", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                QBSchemaFilterDialog qBSchemaFilterDialog = new QBSchemaFilterDialog(QBFrame.this.m_Model);
                qBSchemaFilterDialog.setLocationRelativeTo(QBFrame.this.m_Dialog);
                qBSchemaFilterDialog.setVisible(true);
                QBFrame.this.m_LeftTree.refresh();
                QBFrame.this.updateToolTips();
            }
        });
        this.m_FilterSchema.setIcon(EnsembleIcons.FILTER);
        jToolBar.add(this.m_FilterSchema);
        this.updateToolTips();
        this.m_CBView = new JCheckBox(this.getString("QB.Show-Views"));
        this.m_CBView.setOpaque(false);
        this.m_CBView.addItemListener(this.m_ItemListener);
        jToolBar.add(this.m_CBView);
        this.m_CBView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                QBFrame.this.m_View.getModel().setSelectViewOnly(QBFrame.this.m_CBView.isSelected());
            }
        });
        jPanel.add((Component)jToolBar, "North");
        JScrollPane jScrollPane = new JScrollPane(this.m_LeftTree.getComponent());
        jScrollPane.setBorder(null);
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private void updateToolTips() {
        ArrayList<String> arrayList = this.m_Model.getSelectedSchemas();
        if (arrayList.isEmpty()) {
            this.m_FilterSchema.setToolTipText(this.getString("QB.Filter"));
            return;
        }
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder(this.getString("QB.Filter")).append(": ");
        for (String string : arrayList) {
            if (!bl) {
                bl = true;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string);
        }
        this.m_FilterSchema.setToolTipText(stringBuilder.toString());
    }

    protected JComponent getRightPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JToolBar jToolBar = SwingFactory.newToolBar();
        this.m_SelectDistinct = new JCheckBox(this.getString("QB.Select-Distinct"));
        this.m_SelectDistinct.setOpaque(false);
        this.m_SelectDistinct.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                QBFrame.this.m_View.getModel().setSelectDistinct(QBFrame.this.m_SelectDistinct.isSelected());
            }
        });
        jToolBar.add(this.m_SelectDistinct);
        jToolBar.add(Box.createHorizontalStrut(10));
        jToolBar.add(new JLabel(this.getString("QB.Default-Schema")));
        jToolBar.add(Box.createHorizontalStrut(10));
        this.m_DefaultSchema = new JComboBox();
        Dimension dimension = this.m_DefaultSchema.getPreferredSize();
        dimension.width = 150;
        this.m_DefaultSchema.setPreferredSize(dimension);
        jToolBar.add(this.m_DefaultSchema);
        jToolBar.add(Box.createHorizontalGlue());
        this.m_DefaultSchema.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                QBFrame.this.m_View.getModel().setDefaultSchema((String)QBFrame.this.m_DefaultSchema.getSelectedItem());
            }
        });
        jPanel.add((Component)jToolBar, "North");
        JScrollPane jScrollPane = new JScrollPane(this.m_View);
        jScrollPane.setBorder(null);
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    protected JComponent getTablePane() {
        this.m_BottomTable = new BottomTable();
        this.m_BottomTable.setModel(this.m_BottomTableModel);
        this.m_BottomTable.setAutoResizeMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.m_BottomTable);
        jScrollPane.setRowHeaderView(new BottomTableRowHeader());
        return jScrollPane;
    }

    protected JComponent getSQLPane() {
        return new JScrollPane(this.m_BottomSQLView);
    }

    public void extract() {
        try {
            SchemaExtractor3 schemaExtractor3;
            int n;
            QBModel qBModel = this.getModel();
            JDBCConnector.Pool pool = qBModel.getJDBCConnector();
            QBTable[] qBTableArray = qBModel.getTables();
            HashMap<SchemaExtractor3, QBTable> hashMap = new HashMap<SchemaExtractor3, QBTable>();
            for (n = 0; n < qBTableArray.length; ++n) {
                qBModel.removeTable(qBTableArray[n]);
                schemaExtractor3 = qBTableArray[n].getIdentifier();
                hashMap.put(schemaExtractor3, qBTableArray[n]);
            }
            n = this.checkShowView() ? 1 : 0;
            schemaExtractor3 = qBModel.getExtractor();
            schemaExtractor3.load((JDBCConnector)pool, n != 0);
            this.setModel(qBModel);
        }
        catch (Exception exception) {
            String string = I18NUtilJ.getString(I18N.QueryBuilder(), "QB.ConnectionError", exception.getMessage());
            ((IErrorHandler)Elixir.get(IErrorHandler.class)).error(string, (Throwable)exception);
        }
    }

    public void extractPreservingSelection() {
        try {
            QBModel qBModel = this.getModel();
            JDBCConnector.Pool pool = qBModel.getJDBCConnector();
            QBTable[] qBTableArray = qBModel.getTables();
            for (int i = 0; i < qBTableArray.length; ++i) {
                qBModel.removeTable(qBTableArray[i]);
            }
            for (QBTable object2 : qBModel.getSelectedTableSet()) {
                qBModel.addTable(object2);
            }
            boolean bl = this.checkShowView();
            SchemaExtractor3 schemaExtractor3 = qBModel.getExtractor();
            schemaExtractor3.load((JDBCConnector)pool, bl);
            this.setModel(qBModel);
        }
        catch (Exception exception) {
            String string = I18NUtilJ.getString(I18N.QueryBuilder(), "QB.ConnectionError", exception.getMessage());
            ((IErrorHandler)Elixir.get(IErrorHandler.class)).error(string, (Throwable)exception);
        }
    }

    void savePreferences() {
        IUser iUser = (IUser)Elixir.get(IUser.class);
        iUser.setSplit("QueryBuilder_HSplit", this.m_HSplitter.getDividerLocation());
        iUser.setSplit("QueryBuilder_VSplit", this.m_VSplitter.getDividerLocation());
    }

    void dispose() {
        if (this.m_Dialog != null) {
            this.m_Dialog.dispose();
            this.m_Dialog = null;
        }
    }

    public String getString(String string) {
        return I18N.QueryBuilder().getString(string);
    }

    class MyItemListener
    implements ItemListener {
        MyItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            QBFrame.this.m_LeftTree.showViews(QBFrame.this.m_CBView.isSelected());
        }
    }

    private class ExtractAction
    extends QBAction {
        public ExtractAction() {
            super("Refresh");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            QBFrame.this.m_Model.clearSelectedSchemas();
            QBFrame.this.extract();
            QBFrame.this.updateToolTips();
        }
    }

    private static class BottomTable
    extends ElxTable {
        private DefaultCellEditor m_SortEditor;
        private DefaultCellEditor m_AggregateEditor;
        private TableCellRenderer m_SortRenderer;

        private BottomTable() {
            try {
                Font font = UIManager.getFont("Table.font");
                JComboBox<String> jComboBox = new JComboBox<String>(BottomTableModel.SORTS);
                jComboBox.setRenderer(new I18NCellRenderer(I18N.QueryBuilder()));
                jComboBox.setFont(font);
                jComboBox.setBorder(BorderFactory.createEmptyBorder());
                this.m_SortEditor = new DefaultCellEditor(jComboBox);
                JComboBox<String> jComboBox2 = new JComboBox<String>(BottomTableModel.AGGREGATES);
                jComboBox2.setFont(font);
                jComboBox2.setBorder(BorderFactory.createEmptyBorder());
                jComboBox2.setEditable(true);
                ((JComponent)jComboBox2.getEditor().getEditorComponent()).setBorder(BorderFactory.createEmptyBorder());
                this.m_AggregateEditor = new DefaultCellEditor(jComboBox2);
                this.m_SortRenderer = new I18NCellRenderer(I18N.QueryBuilder());
            }
            catch (Exception exception) {
                System.err.println("Exception: " + String.valueOf(exception));
            }
        }

        @Override
        public TableCellEditor getCellEditor(int n, int n2) {
            if (n == 3) {
                return this.m_SortEditor;
            }
            if (n == 5) {
                return this.m_AggregateEditor;
            }
            return super.getCellEditor(n, n2);
        }

        @Override
        public TableCellRenderer getCellRenderer(int n, int n2) {
            if (n == 3) {
                return this.m_SortRenderer;
            }
            return super.getCellRenderer(n, n2);
        }
    }

    private class BottomTableRowHeader
    extends ElxTable {
        public BottomTableRowHeader() {
            this.setDragEnabled(false);
            BottomTableRowHeaderModel bottomTableRowHeaderModel = new BottomTableRowHeaderModel();
            this.setModel(bottomTableRowHeaderModel);
            this.setPreferredScrollableViewportSize(new Dimension(bottomTableRowHeaderModel.getMaxStringWidth(), this.getHeight()));
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public TableCellRenderer getCellRenderer(int n, int n2) {
            return this.getTableHeader().getDefaultRenderer();
        }
    }

    public static class BottomTableRowHeaderModel
    extends AbstractTableModel {
        private String m_MaxString = BottomTableModel.ROWS_UI[0];

        public BottomTableRowHeaderModel() {
            for (String string : BottomTableModel.ROWS_UI) {
                int n = this.m_MaxString.length();
                int n2 = string.length();
                if (n2 <= n) continue;
                this.m_MaxString = string;
            }
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int n) {
            return BottomTableModel.ROWS_UI[0];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public int getRowCount() {
            return BottomTableModel.ROWS_UI.length - 1;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return BottomTableModel.ROWS_UI[n + 1];
        }

        public int getMaxStringWidth() {
            Font font = UIManager.getFont("Table.font");
            FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
            return (int)(font.getStringBounds(this.m_MaxString, fontRenderContext).getWidth() * 1.5);
        }
    }
}

