/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.qb.ui;

import com.elixirtech.data2.TableIdentifier;
import com.elixirtech.qb.I18N;
import com.elixirtech.qb.model.QBColumn;
import com.elixirtech.qb.model.QBTable;
import com.elixirtech.qb.ui.QBFrame;
import com.elixirtech.qb.ui.QBLinkTreeNode;
import com.elixirtech.qb.ui.QBTableTreeNode;
import com.elixirtech.qb.ui.action.AddLink;
import com.elixirtech.qb.ui.action.DeleteLinkFromList;
import com.elixirtech.ui.LCellRenderer;
import com.elixirtech.ui.SwingFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class QBLinkBuilder {
    private final QBFrame m_Frame;
    private final JDialog m_Dialog;
    private JComboBox m_LeftTables;
    private JList m_LeftColumns;
    private JComboBox m_RightTables;
    private JList m_RightColumns;
    private final QBTableTreeNode[] m_Tables;
    private final LinkListModel m_ListModel;
    private AddLink m_Add;
    private DeleteLinkFromList m_Delete;

    public QBLinkBuilder(QBFrame qBFrame) {
        this.m_Frame = qBFrame;
        QBTable[] qBTableArray = this.m_Frame.getModel().getTables();
        this.m_ListModel = new LinkListModel();
        this.m_Frame.getModel().addPropertyChangeListener(this.m_ListModel);
        ArrayList<QBTableTreeNode> arrayList = new ArrayList<QBTableTreeNode>();
        boolean bl = this.m_Frame.getModel().getSelectedSchemas().isEmpty();
        for (int i = 0; i < qBTableArray.length; ++i) {
            if (!bl) {
                if (!this.m_Frame.getModel().getSelectedSchemas().contains(qBTableArray[i].getSchema())) continue;
                arrayList.add(new QBTableTreeNode(qBTableArray[i]));
                continue;
            }
            arrayList.add(new QBTableTreeNode(qBTableArray[i]));
        }
        this.m_Tables = arrayList.toArray(new QBTableTreeNode[arrayList.size()]);
        this.m_Dialog = new JDialog(this.m_Frame.getDialog(), I18N.QueryBuilder().getString("Relationship-Builder"), true);
        this.m_Dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                windowEvent.getWindow().dispose();
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                QBLinkBuilder.this.m_Frame.getModel().removePropertyChangeListener(QBLinkBuilder.this.m_ListModel);
            }
        });
        Container container = this.m_Dialog.getContentPane();
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.add(this.getLeftPanel());
        jPanel.add(this.getRightPanel());
        container.add(jPanel);
        container.add((Component)this.getBottomPanel(), "South");
        this.m_LeftTables.setSelectedIndex(0);
        this.m_LeftColumns.setListData(qBTableArray[0].getColumns());
        this.m_RightTables.setSelectedIndex(1);
        this.m_RightColumns.setListData(qBTableArray[1].getColumns());
        I18N.QueryBuilderMap().injectComponents("QBLinkBuilder.", this.m_Dialog);
        this.m_Dialog.pack();
        this.m_Dialog.setLocationRelativeTo(this.m_Frame.getDialog());
    }

    public QBFrame getFrame() {
        return this.m_Frame;
    }

    public void checkState() {
        this.m_Add.checkState();
        this.m_Delete.checkState();
    }

    public void setFirst(TableIdentifier tableIdentifier, String string) {
        int n = this.lookupTableId(tableIdentifier);
        if (n >= 0) {
            this.m_LeftTables.setSelectedIndex(n);
            int n2 = this.lookupColumnIndex(this.m_Tables[n].getTable().getColumns(), string);
            if (n2 >= 0) {
                this.m_LeftColumns.setSelectedIndex(n2);
            }
        }
    }

    public void setSecond(TableIdentifier tableIdentifier, String string) {
        int n = this.lookupTableId(tableIdentifier);
        if (n >= 0) {
            this.m_RightTables.setSelectedIndex(n);
            int n2 = this.lookupColumnIndex(this.m_Tables[n].getTable().getColumns(), string);
            if (n2 >= 0) {
                this.m_RightColumns.setSelectedIndex(n2);
            }
        }
    }

    protected JComponent getLeftPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.m_LeftTables = new JComboBox<QBTableTreeNode>(this.m_Tables);
        this.m_LeftTables.setRenderer(new LCellRenderer());
        this.m_LeftColumns = SwingFactory.newList();
        this.m_LeftTables.addItemListener(new ComboListener(this.m_LeftColumns));
        jPanel.add((Component)this.m_LeftTables, "North");
        this.m_LeftColumns.setVisibleRowCount(8);
        jPanel.add((Component)new JScrollPane(this.m_LeftColumns), "Center");
        return jPanel;
    }

    protected JComponent getRightPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.m_RightTables = new JComboBox<QBTableTreeNode>(this.m_Tables);
        this.m_RightTables.setRenderer(new LCellRenderer());
        this.m_RightColumns = SwingFactory.newList();
        this.m_RightTables.addItemListener(new ComboListener(this.m_RightColumns));
        jPanel.add((Component)this.m_RightTables, "North");
        this.m_RightColumns.setVisibleRowCount(8);
        jPanel.add((Component)new JScrollPane(this.m_RightColumns), "Center");
        return jPanel;
    }

    protected JComponent getBottomPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JList jList = SwingFactory.newList(this.m_ListModel);
        jList.setVisibleRowCount(8);
        jList.setCellRenderer(new LCellRenderer());
        jPanel.add(new JScrollPane(jList));
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        this.m_Add = new AddLink(this, this.m_Frame, this.m_LeftColumns, this.m_RightColumns);
        JButton jButton = new JButton(this.m_Add);
        this.m_Delete = new DeleteLinkFromList(this, this.m_Frame, jList);
        JButton jButton2 = new JButton(this.m_Delete);
        JButton jButton3 = SwingFactory.newButton("close", null);
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                QBLinkBuilder.this.m_Dialog.dispose();
            }
        });
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel3.add(jButton3);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel3, "South");
        return jPanel;
    }

    public void setVisible(boolean bl) {
        this.m_Dialog.setVisible(bl);
    }

    private int lookupTableId(TableIdentifier tableIdentifier) {
        int n = this.m_Tables.length;
        for (int i = 0; i < n; ++i) {
            if (!this.m_Tables[i].getTable().getIdentifier().equals((Object)tableIdentifier)) continue;
            return i;
        }
        return -1;
    }

    private int lookupColumnIndex(QBColumn[] qBColumnArray, String string) {
        int n = qBColumnArray.length;
        for (int i = 0; i < n; ++i) {
            if (!qBColumnArray[i].getName().equals(string)) continue;
            return i;
        }
        return -1;
    }

    private class LinkListModel
    extends AbstractListModel
    implements PropertyChangeListener {
        private LinkListModel() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("links")) {
                ListDataEvent listDataEvent = new ListDataEvent(this, 0, 0, this.getSize() - 1);
                EventListener[] eventListenerArray = this.getListeners(ListDataListener.class);
                for (int i = 0; i < eventListenerArray.length; ++i) {
                    ((ListDataListener)eventListenerArray[i]).contentsChanged(listDataEvent);
                }
            }
        }

        @Override
        public int getSize() {
            return QBLinkBuilder.this.m_Frame.getModel().getLinkCount();
        }

        @Override
        public Object getElementAt(int n) {
            return new QBLinkTreeNode(QBLinkBuilder.this.m_Frame.getModel().getLink(n));
        }
    }

    private static class ComboListener
    implements ItemListener {
        private JList m_List;

        public ComboListener(JList jList) {
            this.m_List = jList;
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            QBTableTreeNode qBTableTreeNode = (QBTableTreeNode)itemEvent.getItem();
            if (qBTableTreeNode != null) {
                this.m_List.setListData(qBTableTreeNode.getTable().getColumns());
            } else {
                this.m_List.setListData(new Object[0]);
            }
        }
    }
}

