/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.qb.ui;

import com.elixirtech.qb.model.QBColumn;
import com.elixirtech.qb.model.QBLink;
import com.elixirtech.qb.model.QBTable;
import com.elixirtech.qb.ui.QBLinkView$;
import com.elixirtech.qb.ui.QBLinkView$CL$;
import com.elixirtech.qb.ui.QBTableView;
import com.elixirtech.qb.ui.QBView;
import com.elixirtech.ui.StandardColor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.ToolTipManager;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.math.package$;
import scala.runtime.IntRef;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;

public class QBLinkView {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(QBLinkView.class.getDeclaredField("CL$lzy1"));
    private final QBView view;
    public final QBLink com$elixirtech$qb$ui$QBLinkView$$link;
    private final LinkIcon m_Icon;
    private Rectangle m_BoundingRect;
    private int m_Direction;
    private volatile Object CL$lzy1;

    public static Color ARROW_BACKGROUND() {
        return QBLinkView$.MODULE$.ARROW_BACKGROUND();
    }

    public static StandardColor ARROW_COLOR() {
        return QBLinkView$.MODULE$.ARROW_COLOR();
    }

    public static BTIcon BOTTOM_TOP() {
        return QBLinkView$.MODULE$.BOTTOM_TOP();
    }

    public static int BOTTOM_TO_TOP() {
        return QBLinkView$.MODULE$.BOTTOM_TO_TOP();
    }

    public static StandardColor CIRCLE_LINE() {
        return QBLinkView$.MODULE$.CIRCLE_LINE();
    }

    public static LRIcon LEFT_RIGHT() {
        return QBLinkView$.MODULE$.LEFT_RIGHT();
    }

    public static int LEFT_TO_RIGHT() {
        return QBLinkView$.MODULE$.LEFT_TO_RIGHT();
    }

    public static RLIcon RIGHT_LEFT() {
        return QBLinkView$.MODULE$.RIGHT_LEFT();
    }

    public static int RIGHT_TO_LEFT() {
        return QBLinkView$.MODULE$.RIGHT_TO_LEFT();
    }

    public static StandardColor THICK_LINE() {
        return QBLinkView$.MODULE$.THICK_LINE();
    }

    public static StandardColor THIN_LINE() {
        return QBLinkView$.MODULE$.THIN_LINE();
    }

    public static TBIcon TOP_BOTTOM() {
        return QBLinkView$.MODULE$.TOP_BOTTOM();
    }

    public static int TOP_TO_BOTTOM() {
        return QBLinkView$.MODULE$.TOP_TO_BOTTOM();
    }

    public static UnknownIcon UNKNOWN() {
        return QBLinkView$.MODULE$.UNKNOWN();
    }

    public QBLinkView(QBView view, QBLink link) {
        this.view = view;
        this.com$elixirtech$qb$ui$QBLinkView$$link = link;
        this.m_Icon = new LinkIcon();
        this.m_BoundingRect = null;
        this.m_Direction = 0;
        this.getViews().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                QBTableView v1 = (QBTableView)tuple2._1();
                QBTableView v2 = (QBTableView)tuple2._2();
                v1.addComponentListener(this.CL());
                v2.addComponentListener(this.CL());
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        this.m_Icon.setSize(this.m_Icon.getPreferredSize());
        view.add(this.m_Icon);
    }

    public void dispose() {
        this.getViews().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                QBTableView v1 = (QBTableView)tuple2._1();
                QBTableView v2 = (QBTableView)tuple2._2();
                v1.removeComponentListener(this.CL());
                v2.removeComponentListener(this.CL());
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        this.view.remove(this.m_Icon);
        this.m_Icon.dispose();
    }

    public QBView getView() {
        return this.view;
    }

    public QBLink getLink() {
        return this.com$elixirtech$qb$ui$QBLinkView$$link;
    }

    public Rectangle getBoundingRect() {
        if (this.m_BoundingRect == null) {
            this.calcBoundingRect();
        }
        return this.m_BoundingRect;
    }

    public void calcBoundingRect() {
        this.getConnectors().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                QBTableView.Connector c1 = (QBTableView.Connector)tuple2._1();
                QBTableView.Connector c2 = (QBTableView.Connector)tuple2._2();
                List pts = (List)new .colon.colon((Object)c1.touchingPoint(), (List)new .colon.colon((Object)c1.protrudingPoint(), (List)new .colon.colon((Object)c2.touchingPoint(), (List)new .colon.colon((Object)c2.protrudingPoint(), (List)Nil$.MODULE$))));
                IntRef minX = IntRef.create((int)Integer.MAX_VALUE);
                IntRef minY = IntRef.create((int)Integer.MAX_VALUE);
                IntRef maxX = IntRef.create((int)Integer.MIN_VALUE);
                IntRef maxY = IntRef.create((int)Integer.MIN_VALUE);
                pts.foreach((Function1)(JProcedure1 & Serializable)pt -> {
                    minX$1.elem = package$.MODULE$.min(minX$1.elem, pt.x);
                    maxX$1.elem = package$.MODULE$.max(maxX$1.elem, pt.x);
                    minY$1.elem = package$.MODULE$.min(minY$1.elem, pt.y);
                    maxY$1.elem = package$.MODULE$.max(maxY$1.elem, pt.y);
                });
                this.m_BoundingRect = new Rectangle(minX.elem, minY.elem, maxX.elem - minX.elem, maxY.elem - minY.elem);
                return;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Point midPoint(Point c1, Point c2) {
        int midx = c1.x + (c2.x - c1.x) / 2;
        int midy = c1.y + (c2.y - c1.y) / 2;
        return new Point(midx, midy);
    }

    public void positionIcon() {
        this.getConnectors().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                int dy;
                int dx;
                QBTableView.Connector c1 = (QBTableView.Connector)tuple2._1();
                QBTableView.Connector c2 = (QBTableView.Connector)tuple2._2();
                Rectangle rc = this.m_Icon.getBounds();
                Point mid = this.midPoint(c1.protrudingPoint(), c2.protrudingPoint());
                int midx = mid.x - rc.width / 2;
                int midy = mid.y - rc.height / 2;
                if (rc.x != midx || rc.y != midy) {
                    this.m_Icon.setLocation(midx, midy);
                }
                this.m_Direction = (dx = package$.MODULE$.abs(c1.protrudingPoint().x - c2.protrudingPoint().x)) >= (dy = package$.MODULE$.abs(c1.protrudingPoint().y - c2.protrudingPoint().y)) ? (c1.protrudingPoint().x <= c2.protrudingPoint().x ? QBLinkView$.MODULE$.LEFT_TO_RIGHT() : QBLinkView$.MODULE$.RIGHT_TO_LEFT()) : (c1.protrudingPoint().y < c2.protrudingPoint().y ? QBLinkView$.MODULE$.TOP_TO_BOTTOM() : QBLinkView$.MODULE$.BOTTOM_TO_TOP());
                this.m_Icon.setIcon(this.getIcon());
                return;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Icon getIcon() {
        int n = this.m_Direction;
        if (QBLinkView$.MODULE$.LEFT_TO_RIGHT() == n) {
            return QBLinkView$.MODULE$.LEFT_RIGHT();
        }
        if (QBLinkView$.MODULE$.RIGHT_TO_LEFT() == n) {
            return QBLinkView$.MODULE$.RIGHT_LEFT();
        }
        if (QBLinkView$.MODULE$.TOP_TO_BOTTOM() == n) {
            return QBLinkView$.MODULE$.TOP_BOTTOM();
        }
        if (QBLinkView$.MODULE$.BOTTOM_TO_TOP() == n) {
            return QBLinkView$.MODULE$.BOTTOM_TOP();
        }
        return QBLinkView$.MODULE$.UNKNOWN();
    }

    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        this.getConnectors().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                QBTableView.Connector c1 = (QBTableView.Connector)tuple2._1();
                QBTableView.Connector c2 = (QBTableView.Connector)tuple2._2();
                GeneralPath gp = new GeneralPath();
                gp.moveTo(c1.touchingPoint().x, c1.touchingPoint().y);
                gp.curveTo(c1.protrudingPoint().x, c1.protrudingPoint().y, c2.protrudingPoint().x, c2.protrudingPoint().y, c2.touchingPoint().x, c2.touchingPoint().y);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setColor(QBLinkView$.MODULE$.THICK_LINE());
                Stroke originalStroke = g2.getStroke();
                g2.setStroke(new BasicStroke(5.0f));
                g2.draw(gp);
                g2.setStroke(originalStroke);
                g2.setColor(QBLinkView$.MODULE$.THIN_LINE());
                g2.draw(gp);
                return;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Option<Tuple2<QBTableView, QBTableView>> getViews() {
        QBColumn col1 = this.com$elixirtech$qb$ui$QBLinkView$$link.getColumn1();
        QBColumn col2 = this.com$elixirtech$qb$ui$QBLinkView$$link.getColumn2();
        QBTable tab1 = col1.getTable();
        QBTable tab2 = col2.getTable();
        return Option$.MODULE$.apply((Object)this.view.lookupView(tab1)).flatMap((Function1 & Serializable)first -> Option$.MODULE$.apply((Object)this.view.lookupView(tab2)).map((Function1 & Serializable)second -> Tuple2$.MODULE$.apply(first, second)));
    }

    public Option<Tuple2<QBTableView.Connector, QBTableView.Connector>> getConnectors() {
        QBColumn col1 = this.com$elixirtech$qb$ui$QBLinkView$$link.getColumn1();
        QBColumn col2 = this.com$elixirtech$qb$ui$QBLinkView$$link.getColumn2();
        return this.getViews().flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                QBTableView v1 = (QBTableView)tuple2._1();
                QBTableView v2 = (QBTableView)tuple2._2();
                if (v1.getLocation().x < v2.getLocation().x) {
                    return v1.getRightConnector(col1).flatMap((Function1 & Serializable)c1 -> v2.getLeftConnector(col2).map((Function1 & Serializable)c2 -> Tuple2$.MODULE$.apply(c1, c2)));
                }
                return v1.getLeftConnector(col1).flatMap((Function1 & Serializable)c1 -> v2.getRightConnector(col2).map((Function1 & Serializable)c2 -> Tuple2$.MODULE$.apply(c1, c2)));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public final QBLinkView$CL$ CL() {
        Object object = this.CL$lzy1;
        if (object instanceof QBLinkView$CL$) {
            return (QBLinkView$CL$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (QBLinkView$CL$)this.CL$lzyINIT1();
    }

    private Object CL$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.CL$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    QBLinkView$CL$ qBLinkView$CL$ = null;
                    try {
                        qBLinkView$CL$ = new QBLinkView$CL$(this);
                        object2 = qBLinkView$CL$ == null ? LazyVals.NullValue$.MODULE$ : qBLinkView$CL$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.CL$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return qBLinkView$CL$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public static abstract class AbstractLinkIcon
    implements Icon {
        @Override
        public int getIconWidth() {
            return 20;
        }

        @Override
        public int getIconHeight() {
            return 20;
        }
    }

    public static class ArrowIcon
    extends AbstractLinkIcon {
        private final Polygon polygon;

        public ArrowIcon(Polygon polygon) {
            this.polygon = polygon;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.translate(x, y);
            g.setColor(QBLinkView$.MODULE$.ARROW_BACKGROUND());
            g.fillOval(2, 2, 16, 16);
            g.setColor(QBLinkView$.MODULE$.CIRCLE_LINE());
            g.drawOval(2, 2, 16, 16);
            g.setColor(QBLinkView$.MODULE$.ARROW_COLOR());
            g.fillPolygon(this.polygon);
            g.setColor(QBLinkView$.MODULE$.THIN_LINE());
            g.drawPolygon(this.polygon);
            g.translate(-x, -y);
        }
    }

    public static class BTIcon
    extends ArrowIcon {
        public BTIcon() {
            super(new Polygon(new int[]{4, 10, 16}, new int[]{16, 4, 16}, 3));
        }
    }

    public static class LRIcon
    extends ArrowIcon {
        public LRIcon() {
            super(new Polygon(new int[]{4, 16, 4}, new int[]{4, 10, 16}, 3));
        }
    }

    public class LinkIcon
    extends JLabel {
        public LinkIcon() {
            if (QBLinkView.this == null) {
                throw new NullPointerException();
            }
            super(QBLinkView$.MODULE$.UNKNOWN());
            this.setSize(this.getPreferredSize());
        }

        @Override
        public String getToolTipText() {
            QBColumn col1 = QBLinkView.this.com$elixirtech$qb$ui$QBLinkView$$link.getColumn1();
            QBColumn col2 = QBLinkView.this.com$elixirtech$qb$ui$QBLinkView$$link.getColumn2();
            return col1.getFullName() + "=" + col2.getFullName();
        }

        public void dispose() {
            ToolTipManager.sharedInstance().unregisterComponent(this);
        }

        public final /* synthetic */ QBLinkView com$elixirtech$qb$ui$QBLinkView$LinkIcon$$$outer() {
            return QBLinkView.this;
        }
    }

    public static class RLIcon
    extends ArrowIcon {
        public RLIcon() {
            super(new Polygon(new int[]{16, 4, 16}, new int[]{4, 10, 16}, 3));
        }
    }

    public static class TBIcon
    extends ArrowIcon {
        public TBIcon() {
            super(new Polygon(new int[]{4, 10, 16}, new int[]{4, 16, 4}, 3));
        }
    }

    public static class UnknownIcon
    extends AbstractLinkIcon {
        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(Color.red);
            g.drawOval(x + 2, y + 2, 16, 16);
        }
    }
}

