/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.qb.ui;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.qb.I18N;
import com.elixirtech.qb.model.QBModel;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.util.CodeBlock;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class QBSchemaFilterDialog
extends JDialog {
    private QBModel m_Model;
    private JList m_List;
    private JButton m_Ok;

    public QBSchemaFilterDialog(QBModel qBModel) {
        super(((ElixirFrame)Elixir.get(ElixirFrame.class)).getFrame());
        this.m_Model = qBModel;
        this.setTitle(I18N.QueryBuilder().getString("QB.ShowSchemaFilterDialog"));
        this.setPreferredSize(new Dimension(250, 300));
        this.setModal(true);
        this.setLayout(new BorderLayout(5, 5));
        this.setDefaultCloseOperation(2);
        Object[] objectArray = this.m_Model.getSchemas();
        ArrayList<String> arrayList = this.m_Model.getSelectedSchemas();
        this.m_List = SwingFactory.newList(objectArray);
        this.m_List.setSelectionMode(2);
        this.add("Center", new JScrollPane(this.m_List));
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!arrayList.contains(objectArray[i])) continue;
            arrayList2.add(i);
        }
        int[] nArray = new int[arrayList2.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)arrayList2.get(i);
        }
        this.m_List.setSelectedIndices(nArray);
        JPanel jPanel = new JPanel(new FlowLayout(1));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
        this.m_Ok = SwingFactory.newOkButton(new CodeBlock((Object)this, "ok"));
        this.m_Ok.setText(I18N.QueryBuilder().getString("QB.ShowSchemaFilterDialog.Ok"));
        jPanel2.add("ok", this.m_Ok);
        JButton jButton = SwingFactory.newCancelButton(new CodeBlock((Object)this, "cancel"));
        jPanel2.add("cancel", jButton);
        jButton.setText(I18N.QueryBuilder().getString("QB.ShowSchemaFilterDialog.Cancel"));
        jPanel.add(jPanel2);
        this.add("South", jPanel);
        this.pack();
    }

    public void ok() {
        this.m_Model.clearSelectedSchemas();
        Object[] objectArray = this.m_List.getSelectedValues();
        for (int i = 0; i < objectArray.length; ++i) {
            this.m_Model.getSelectedSchemas().add((String)objectArray[i]);
        }
        this.dispose();
    }

    public void cancel() {
        this.dispose();
    }
}

