/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.qb.ui;

import com.elixirtech.arch.LoggingHelper;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.arch.logging.SLF4J;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.TableIdentifier;
import com.elixirtech.qb.I18N$;
import com.elixirtech.qb.model.QBColumn;
import com.elixirtech.qb.model.QBTable;
import com.elixirtech.qb.ui.QBLinkBuilder;
import com.elixirtech.qb.ui.QBTableView$;
import com.elixirtech.qb.ui.QBTableView$Connector$;
import com.elixirtech.qb.ui.QBTableView$PopupML$;
import com.elixirtech.qb.ui.QBTableView$ScrollTracker$;
import com.elixirtech.qb.ui.QBTableViewListener;
import com.elixirtech.qb.ui.QBView;
import com.elixirtech.qb.ui.StringTransferHandler;
import com.elixirtech.ui.TCellRenderer;
import com.elixirtech.ui.table.ElxTable;
import com.elixirtech.v2.swing.ElxTableModel;
import com.elixirtech.v2.swing.ElxTableModel$;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.Serializable;
import javax.swing.DropMode;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameListener;
import javax.swing.table.TableColumn;
import org.slf4j.Logger;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import sourcecode.FullName$;
import sourcecode.Line$;

public class QBTableView
extends JInternalFrame
implements SLF4J,
LoggingHelper {
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(QBTableView.class.getDeclaredField("logger$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(QBTableView.class.getDeclaredField("PopupML$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(QBTableView.class.getDeclaredField("ScrollTracker$lzy1"));
    private volatile Object logger$lzy1;
    public final QBView com$elixirtech$qb$ui$QBTableView$$view;
    public final QBTable com$elixirtech$qb$ui$QBTableView$$table;
    private Option<QBTableViewListener> listener;
    private final Container c;
    private final String schema;
    private final ElxTableModel model;
    private final ElxTable colTable;
    private final JScrollPane sp;
    private final String memento;
    private volatile Object ScrollTracker$lzy1;
    private volatile Object PopupML$lzy1;

    public static int CONNECTOR_LENGTH() {
        return QBTableView$.MODULE$.CONNECTOR_LENGTH();
    }

    public static JLabel EMPTY_LABEL() {
        return QBTableView$.MODULE$.EMPTY_LABEL();
    }

    public static ImageIcon ICON() {
        return QBTableView$.MODULE$.ICON();
    }

    public static JLabel PRIMARY_KEY_LABEL() {
        return QBTableView$.MODULE$.PRIMARY_KEY_LABEL();
    }

    public QBTableView(QBView view, QBTable table) {
        this.com$elixirtech$qb$ui$QBTableView$$view = view;
        this.com$elixirtech$qb$ui$QBTableView$$table = table;
        this.listener = None$.MODULE$;
        try {
            table.getModel().getExtractor().fillTable(table);
        }
        catch (DataException ex) {
            this.warn(() -> QBTableView.$init$$$anonfun$1(table), Line$.MODULE$.apply(39), FullName$.MODULE$.apply("com.elixirtech.qb.ui.QBTableView"));
        }
        this.c = this.getContentPane();
        this.schema = table.getSchema();
        if (StringUtil.isEmpty((String)this.schema())) {
            this.setTitle(table.getName());
        } else {
            this.setTitle(table.getName() + " (" + this.schema() + ")");
        }
        this.setFrameIcon(QBTableView$.MODULE$.ICON());
        this.setClosable(true);
        this.model = new ElxTableModel<QBColumn>(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super($outer.com$elixirtech$qb$ui$QBTableView$$_$$anon$superArg$1$1(), ElxTableModel$.MODULE$.$lessinit$greater$default$2());
            }

            public Class getColumnClass(int idx) {
                int n = idx;
                switch (n) {
                    case 0: {
                        return JLabel.class;
                    }
                    case 1: {
                        return Boolean.class;
                    }
                    case 2: {
                        return String.class;
                    }
                }
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        };
        this.colTable = new ElxTable(this.model());
        this.colTable().setSelectionMode(0);
        this.colTable().setTableHeader(null);
        this.colTable().setDefaultRenderer(JLabel.class, new TCellRenderer());
        this.setHeaderWidth(this.colTable().getColumnModel().getColumn(0), 24);
        this.setHeaderWidth(this.colTable().getColumnModel().getColumn(1), 24);
        this.colTable().addMouseListener(this.PopupML());
        this.colTable().addMouseMotionListener(this.PopupML());
        this.colTable().setTransferHandler(new StringTransferHandler(this){
            private final /* synthetic */ QBTableView $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public String exportString(JComponent c) {
                int vIdx = this.$outer.colTable().getSelectedRow();
                int idx = this.$outer.colTable().convertRowIndexToModel(vIdx);
                QBColumn col = this.$outer.model().entry(idx);
                return this.$outer.com$elixirtech$qb$ui$QBTableView$$buildString(this.$outer.com$elixirtech$qb$ui$QBTableView$$table.getIdentifier(), col.getName());
            }

            public void importString(JComponent c, String str) {
                int idx = str.indexOf("\n");
                if (idx > 0) {
                    Tuple2<TableIdentifier, String> tuple2 = this.$outer.com$elixirtech$qb$ui$QBTableView$$fromString(str);
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    TableIdentifier tid = (TableIdentifier)tuple2._1();
                    String colName = (String)tuple2._2();
                    Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)tid, (Object)colName);
                    TableIdentifier tid2 = (TableIdentifier)tuple22._1();
                    String colName2 = (String)tuple22._2();
                    QBLinkBuilder dlg = new QBLinkBuilder(this.$outer.com$elixirtech$qb$ui$QBTableView$$view.getFrame());
                    dlg.setFirst(tid2, colName2);
                    int vIdx = this.$outer.colTable().getSelectedRow();
                    int idx2 = this.$outer.colTable().convertRowIndexToModel(vIdx);
                    QBColumn col = this.$outer.model().entry(idx2);
                    dlg.setSecond(this.$outer.com$elixirtech$qb$ui$QBTableView$$table.getIdentifier(), col.getName());
                    dlg.setVisible(true);
                    return;
                }
            }

            public void cleanup(JComponent c, boolean remove) {
            }
        });
        this.colTable().setDragEnabled(true);
        this.colTable().setDropMode(DropMode.USE_SELECTION);
        this.colTable().setToolTipText(I18N$.MODULE$.QueryBuilder().getString("QB.TableTip"));
        this.model().setRows((Seq<QBColumn>)Predef$.MODULE$.wrapRefArray((Object[])table.getColumns()).toList());
        this.sp = new JScrollPane(this.colTable());
        this.sp().getVerticalScrollBar().addAdjustmentListener(this.ScrollTracker());
        this.c().add((Component)this.sp(), "Center");
        this.setResizable(true);
        this.pack();
        this.memento = table.getPositionMemento();
        if (this.memento() != null) {
            Object object = Predef$.MODULE$.refArrayOps((Object[])this.memento().split(","));
            int[] is = (int[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$1 -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(_$1)), ClassTag$.MODULE$.apply(Integer.TYPE));
            Rectangle rc = new Rectangle(is[0], is[1], is[2], is[3]);
            this.setBounds(rc);
        } else {
            Dimension sz = this.getSize();
            sz.width = 180;
            Object object = Predef$.MODULE$.refArrayOps((Object[])table.getColumns());
            sz.height = 30 + ArrayOps$.MODULE$.size$extension(object) * 18;
            if (sz.height > 800) {
                sz.height = 800;
            }
            this.setSize(sz);
        }
        this.setVisible(true);
    }

    public Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LoggingHelper.logger$((LoggingHelper)this);
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Container c() {
        return this.c;
    }

    public String schema() {
        return this.schema;
    }

    public ElxTableModel<QBColumn> model() {
        return this.model;
    }

    public ElxTable colTable() {
        return this.colTable;
    }

    public JScrollPane sp() {
        return this.sp;
    }

    public String memento() {
        return this.memento;
    }

    public QBColumn setSel(QBColumn row, Object o) {
        row.setSelected(BoxesRunTime.unboxToBoolean((Object)o));
        this.listener.foreach((Function1)(JProcedure1 & Serializable)_$2 -> _$2.columnChanged(row));
        return row;
    }

    public void setTableViewListener(QBTableViewListener newListener) {
        this.listener.foreach((Function1)(JProcedure1 & Serializable)o -> {
            this.removeComponentListener((ComponentListener)o);
            this.removeInternalFrameListener((InternalFrameListener)o);
        });
        this.listener = Option$.MODULE$.apply((Object)newListener);
        this.listener.foreach((Function1)(JProcedure1 & Serializable)o -> {
            this.addComponentListener((ComponentListener)o);
            this.addInternalFrameListener((InternalFrameListener)o);
        });
    }

    public QBView getView() {
        return this.com$elixirtech$qb$ui$QBTableView$$view;
    }

    public QBTable getTable() {
        return this.com$elixirtech$qb$ui$QBTableView$$table;
    }

    public JLabel iconLabel(QBColumn col) {
        if (col.isPrimaryKey()) {
            return QBTableView$.MODULE$.PRIMARY_KEY_LABEL();
        }
        return QBTableView$.MODULE$.EMPTY_LABEL();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Rectangle rc = this.getBounds();
        this.com$elixirtech$qb$ui$QBTableView$$table.setPositionMemento(rc.x + "," + rc.y + "," + rc.width + "," + rc.height);
    }

    public Point getCenter() {
        Rectangle rc = this.getBounds();
        return new Point(rc.x + rc.width / 2, rc.y + rc.height / 2);
    }

    public Option<Connector> getLeftConnector(QBColumn col) {
        int mIdx = this.model().indexOf(col);
        if (mIdx >= 0) {
            int idx = this.colTable().convertRowIndexToView(mIdx);
            Rectangle rc = this.colTable().getCellRect(idx, 0, true);
            rc = SwingUtilities.convertRectangle(this.colTable(), rc, this.com$elixirtech$qb$ui$QBTableView$$view);
            Rectangle rc2 = this.getBounds();
            rc.y = package$.MODULE$.max(rc.y, rc2.y);
            rc.y = package$.MODULE$.min(rc.y, rc2.y + rc2.height - rc.height);
            Point touching = new Point(rc2.x, rc.y + rc.height / 2);
            Point protruding = new Point(touching.x - QBTableView$.MODULE$.CONNECTOR_LENGTH(), touching.y);
            return Some$.MODULE$.apply((Object)new Connector(touching, protruding));
        }
        return None$.MODULE$;
    }

    public Option<Connector> getRightConnector(QBColumn col) {
        int mIdx = this.model().indexOf(col);
        if (mIdx >= 0) {
            int idx = this.colTable().convertRowIndexToView(mIdx);
            Rectangle rc = this.colTable().getCellRect(idx, 0, true);
            rc = SwingUtilities.convertRectangle(this.colTable(), rc, this.com$elixirtech$qb$ui$QBTableView$$view);
            Rectangle rc2 = this.getBounds();
            rc.y = package$.MODULE$.max(rc.y, rc2.y);
            rc.y = package$.MODULE$.min(rc.y, rc2.y + rc2.height - rc.height);
            Point touching = new Point(rc2.x + rc2.width, rc.y + rc.height / 2);
            Point protruding = new Point(touching.x + QBTableView$.MODULE$.CONNECTOR_LENGTH(), touching.y);
            return Some$.MODULE$.apply((Object)new Connector(touching, protruding));
        }
        return None$.MODULE$;
    }

    public void selectAll() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.com$elixirtech$qb$ui$QBTableView$$table.getColumns());
        ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)col -> {
            if (!col.isSelected()) {
                col.setSelected(true);
                this.listener.foreach((Function1)(JProcedure1 & Serializable)_$3 -> _$3.columnChanged((QBColumn)col));
                return;
            }
        });
        this.model().fireTableDataChanged();
    }

    public void deselectAll() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.com$elixirtech$qb$ui$QBTableView$$table.getColumns());
        ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)col -> {
            if (col.isSelected()) {
                col.setSelected(false);
                this.listener.foreach((Function1)(JProcedure1 & Serializable)_$4 -> _$4.columnChanged((QBColumn)col));
                return;
            }
        });
        this.model().fireTableDataChanged();
    }

    private void setHeaderWidth(TableColumn tc, int w) {
        tc.setMinWidth(w);
        tc.setMaxWidth(w);
        tc.setPreferredWidth(w);
    }

    public String com$elixirtech$qb$ui$QBTableView$$buildString(TableIdentifier tid, String columnName) {
        List items = (List)new .colon.colon((Object)tid.type, (List)new .colon.colon((Object)((String)Option$.MODULE$.apply((Object)tid.catalog).getOrElse(QBTableView::$anonfun$2)), (List)new .colon.colon((Object)((String)Option$.MODULE$.apply((Object)tid.schema).getOrElse(QBTableView::$anonfun$3)), (List)new .colon.colon((Object)tid.table, (List)new .colon.colon((Object)columnName, (List)Nil$.MODULE$)))));
        return items.mkString("\n");
    }

    public Tuple2<TableIdentifier, String> com$elixirtech$qb$ui$QBTableView$$fromString(String s) {
        String[] ss = s.split("\n");
        TableIdentifier tid = new TableIdentifier();
        tid.type = ss[0];
        tid.catalog = ss[1].isEmpty() ? null : ss[1];
        tid.schema = ss[2].isEmpty() ? null : ss[2];
        tid.table = ss[3];
        return Tuple2$.MODULE$.apply((Object)tid, (Object)ss[4]);
    }

    public final QBTableView$ScrollTracker$ ScrollTracker() {
        Object object = this.ScrollTracker$lzy1;
        if (object instanceof QBTableView$ScrollTracker$) {
            return (QBTableView$ScrollTracker$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (QBTableView$ScrollTracker$)this.ScrollTracker$lzyINIT1();
    }

    private Object ScrollTracker$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.ScrollTracker$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    QBTableView$ScrollTracker$ qBTableView$ScrollTracker$ = null;
                    try {
                        qBTableView$ScrollTracker$ = new QBTableView$ScrollTracker$(this);
                        object2 = qBTableView$ScrollTracker$ == null ? LazyVals.NullValue$.MODULE$ : qBTableView$ScrollTracker$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.ScrollTracker$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return qBTableView$ScrollTracker$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public final QBTableView$PopupML$ PopupML() {
        Object object = this.PopupML$lzy1;
        if (object instanceof QBTableView$PopupML$) {
            return (QBTableView$PopupML$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (QBTableView$PopupML$)this.PopupML$lzyINIT1();
    }

    private Object PopupML$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.PopupML$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    QBTableView$PopupML$ qBTableView$PopupML$ = null;
                    try {
                        qBTableView$PopupML$ = new QBTableView$PopupML$(this);
                        object2 = qBTableView$PopupML$ == null ? LazyVals.NullValue$.MODULE$ : qBTableView$PopupML$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.PopupML$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return qBTableView$PopupML$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private static final Object $init$$$anonfun$1(QBTable table$1) {
        return "Can't load columns for " + table$1.getName();
    }

    public final List com$elixirtech$qb$ui$QBTableView$$_$$anon$superArg$1$1() {
        return (List)new .colon.colon(new ElxTableModel.Column("", (Function1 & Serializable)col -> this.iconLabel((QBColumn)col)), (List)new .colon.colon(new ElxTableModel.EditableColumn("", (Function1 & Serializable)col -> BoxesRunTime.boxToBoolean((boolean)col.isSelected()), (Function2 & Serializable)(row, o) -> this.setSel((QBColumn)row, o)), (List)new .colon.colon(new ElxTableModel.Column("Name", (Function1 & Serializable)col -> col.getName()), (List)Nil$.MODULE$)));
    }

    private static final String $anonfun$2() {
        return "";
    }

    private static final String $anonfun$3() {
        return "";
    }

    public static final /* synthetic */ void com$elixirtech$qb$ui$QBTableView$ScrollTracker$$$_$adjustmentValueChanged$$anonfun$1(ComponentEvent cev$1, ComponentListener o) {
        o.componentResized(cev$1);
    }

    public static class Connector
    implements Product,
    Serializable {
        private final Point touchingPoint;
        private final Point protrudingPoint;

        public static Connector apply(Point point, Point point2) {
            return QBTableView$Connector$.MODULE$.apply(point, point2);
        }

        public static Connector fromProduct(Product product) {
            return QBTableView$Connector$.MODULE$.fromProduct(product);
        }

        public static Connector unapply(Connector connector) {
            return QBTableView$Connector$.MODULE$.unapply(connector);
        }

        public Connector(Point touchingPoint, Point protrudingPoint) {
            this.touchingPoint = touchingPoint;
            this.protrudingPoint = protrudingPoint;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Connector)) return false;
            Connector connector = (Connector)object;
            Point point = this.touchingPoint();
            Point point2 = connector.touchingPoint();
            if (point == null) {
                if (point2 != null) {
                    return false;
                }
            } else if (!((Object)point).equals(point2)) return false;
            Point point3 = this.protrudingPoint();
            Point point4 = connector.protrudingPoint();
            if (point3 == null) {
                if (point4 != null) {
                    return false;
                }
            } else if (!((Object)point3).equals(point4)) return false;
            if (!connector.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof Connector;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Connector";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "touchingPoint";
            }
            if (1 == n2) {
                return "protrudingPoint";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Point touchingPoint() {
            return this.touchingPoint;
        }

        public Point protrudingPoint() {
            return this.protrudingPoint;
        }

        public String toString() {
            return "[" + this.touchingPoint() + "][" + this.protrudingPoint() + "]";
        }

        public Connector copy(Point touchingPoint, Point protrudingPoint) {
            return new Connector(touchingPoint, protrudingPoint);
        }

        public Point copy$default$1() {
            return this.touchingPoint();
        }

        public Point copy$default$2() {
            return this.protrudingPoint();
        }

        public Point _1() {
            return this.touchingPoint();
        }

        public Point _2() {
            return this.protrudingPoint();
        }
    }
}

