/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.qb.ui;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.qb.model.QBLink;
import com.elixirtech.qb.model.QBModel;
import com.elixirtech.qb.model.QBTable;
import com.elixirtech.qb.ui.QBFrame;
import com.elixirtech.qb.ui.QBLinkView;
import com.elixirtech.qb.ui.QBTableView;
import com.elixirtech.qb.ui.QBTableViewListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JDesktopPane;

class QBView
extends JDesktopPane
implements PropertyChangeListener {
    private QBFrame m_Frame;
    private QBModel m_Model;
    private QBTableViewListener m_Listener;
    private Map<QBTable, QBTableView> m_Tables;
    private Map<QBLink, QBLinkView> m_Links;
    private static final int XOFFSET = 10;
    private static final int YOFFSET = 10;
    private static final int XGAP = 40;

    public QBView(QBFrame qBFrame) {
        this.m_Frame = qBFrame;
        this.m_Listener = new QBTableViewListener(this);
        this.setModel(qBFrame.getModel());
        this.setLayout(null);
        this.setBackground(Color.white);
    }

    public QBFrame getFrame() {
        return this.m_Frame;
    }

    public QBModel getModel() {
        return this.m_Model;
    }

    public void setModel(QBModel qBModel) {
        this.setSize(new Dimension(1024, 1024));
        if (this.m_Model != null) {
            this.m_Model.removePropertyChangeListener(this);
        }
        this.m_Model = qBModel;
        if (this.m_Model != null) {
            this.m_Model.addPropertyChangeListener(this);
        }
        this.removeAll();
        this.m_Tables = new HashMap<QBTable, QBTableView>();
        this.m_Links = new HashMap<QBLink, QBLinkView>();
        int n = this.m_Model.getSelectedTableCount();
        for (int i = 0; i < n; ++i) {
            QBTable qBTable = this.m_Model.getSelectedTable(i);
            QBTableView qBTableView = this.buildView(qBTable);
            String string = qBTable.getPositionMemento();
            if (string == null) {
                Point point = this.getNextTableLocation(qBTableView);
                qBTableView.setLocation(point.x, point.y);
            }
            this.add(qBTableView);
            qBTableView.moveToFront();
        }
        this.buildLinks();
        this.updateSize();
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        QBLink[] qBLinkArray = this.m_Model.getLinks();
        for (int i = 0; i < qBLinkArray.length; ++i) {
            QBLinkView qBLinkView = this.lookupView(qBLinkArray[i]);
            if (qBLinkView == null) continue;
            qBLinkView.positionIcon();
            qBLinkView.paint(graphics);
        }
    }

    public void repaint(QBTableView qBTableView) {
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getSize();
    }

    public QBTableView buildView(QBTable qBTable) {
        QBTableView qBTableView = this.lookupView(qBTable);
        if (qBTableView == null) {
            qBTableView = new QBTableView(this, qBTable);
            this.m_Tables.put(qBTable, qBTableView);
            qBTableView.setTableViewListener(this.m_Listener);
        }
        return qBTableView;
    }

    public QBLinkView buildView(QBLink qBLink) {
        QBLinkView qBLinkView = this.lookupView(qBLink);
        if (qBLinkView == null) {
            qBLinkView = new QBLinkView(this, qBLink);
            this.m_Links.put(qBLink, qBLinkView);
            qBLinkView.positionIcon();
        }
        return qBLinkView;
    }

    public void removeView(QBTableView qBTableView) {
        QBTable qBTable = qBTableView.getTable();
        ArrayList<QBLinkView> arrayList = new ArrayList<QBLinkView>();
        for (QBLink qBLink : this.m_Links.keySet()) {
            if (qBLink.getColumn1().getTable() != qBTable && qBLink.getColumn2().getTable() != qBTable) continue;
            arrayList.add(this.lookupView(qBLink));
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            this.removeView((QBLinkView)arrayList.get(i));
        }
        this.m_Tables.remove(qBTable);
        qBTableView.dispose();
        qBTableView.setTableViewListener(null);
        this.repaint();
    }

    public void removeView(QBLinkView qBLinkView) {
        this.m_Links.remove(qBLinkView.getLink());
        qBLinkView.dispose();
        this.repaint();
    }

    public QBTableView lookupView(QBTable qBTable) {
        return this.m_Tables.get(qBTable);
    }

    public QBLinkView lookupView(QBLink qBLink) {
        return this.m_Links.get(qBLink);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("selected-tables")) {
            QBTable qBTable = (QBTable)propertyChangeEvent.getOldValue();
            if (qBTable != null) {
                QBTableView qBTableView = this.lookupView(qBTable);
                if (qBTableView != null) {
                    this.removeView(qBTableView);
                }
            } else {
                qBTable = (QBTable)propertyChangeEvent.getNewValue();
                QBTableView qBTableView = this.buildView(qBTable);
                Point point = this.getNextTableLocation(qBTableView);
                qBTableView.setLocation(point.x, point.y);
                this.add(qBTableView);
                qBTableView.moveToFront();
                try {
                    qBTableView.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                this.buildLinks();
                this.updateSize();
            }
            this.repaint();
        } else if (propertyChangeEvent.getPropertyName().equals("links")) {
            QBLink qBLink = (QBLink)propertyChangeEvent.getOldValue();
            if (qBLink != null) {
                QBLinkView qBLinkView = this.lookupView(qBLink);
                if (qBLinkView != null) {
                    this.removeView(qBLinkView);
                }
            } else {
                qBLink = (QBLink)propertyChangeEvent.getNewValue();
                if (qBLink.getTable1().isSelected() && qBLink.getTable2().isSelected()) {
                    this.buildView(qBLink);
                }
            }
            this.repaint();
        }
    }

    protected Point getNextTableLocation(QBTableView qBTableView) {
        Dimension dimension = qBTableView.getSize();
        Component[] componentArray = this.getComponents();
        if (componentArray.length == 0) {
            return new Point(10, 10);
        }
        Rectangle rectangle = componentArray[0].getBounds();
        for (int i = 1; i < componentArray.length; ++i) {
            rectangle.add(componentArray[i].getBounds());
        }
        if (rectangle.x >= 10 + dimension.width + 40) {
            return new Point(10, 10);
        }
        return new Point(rectangle.x + rectangle.width + 40, 10);
    }

    protected void updateSize() {
        Dimension dimension = new Dimension(1024, 1024);
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Rectangle rectangle = componentArray[i].getBounds();
            dimension.width = Math.max(dimension.width, rectangle.x + rectangle.width + 50);
            dimension.height = Math.max(dimension.height, rectangle.y + rectangle.height + 50);
        }
        if (dimension.width != 1024 || dimension.height != 1024) {
            this.setSize(dimension);
            this.invalidate();
            Container container = this.getParent();
            if (container != null) {
                container.getParent().validate();
            } else {
                this.validate();
            }
        }
    }

    private void buildLinks() {
        try {
            QBLink[] qBLinkArray = this.m_Model.getLinks();
            for (int i = 0; i < qBLinkArray.length; ++i) {
                if (qBLinkArray[i] == null) continue;
                QBTable qBTable = qBLinkArray[i].getTable1();
                QBTable qBTable2 = qBLinkArray[i].getTable2();
                if (qBTable == null || qBTable2 == null || !qBTable.isSelected() || !qBTable2.isSelected()) continue;
                this.buildView(qBLinkArray[i]);
            }
        }
        catch (Throwable throwable) {
            ElxLoggerJ.getLogger(QBView.class).warn((Object)"Exception throw in buildLinks, I guess your JDBC driver is buggy.", throwable);
        }
    }
}

