/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.qb.ui.action;

import com.elixirtech.qb.QBAction;
import com.elixirtech.qb.model.QBLink;
import com.elixirtech.qb.model.QBModel;
import com.elixirtech.qb.ui.QBFrame;
import com.elixirtech.qb.ui.QBLinkBuilder;
import com.elixirtech.qb.ui.QBLinkTreeNode;
import java.awt.event.ActionEvent;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DeleteLinkFromList
extends QBAction
implements ListSelectionListener {
    private QBLinkBuilder m_Parent;
    private QBFrame m_Frame;
    private JList m_List;

    public DeleteLinkFromList(QBLinkBuilder qBLinkBuilder, QBFrame qBFrame, JList jList) {
        super("QB.Delete");
        this.m_Parent = qBLinkBuilder;
        this.m_Frame = qBFrame;
        this.m_List = jList;
        this.m_List.addListSelectionListener(this);
        this.checkState();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n = this.m_List.getSelectedIndex();
        if (n >= 0) {
            QBLink qBLink = ((QBLinkTreeNode)this.m_List.getSelectedValue()).getLink();
            QBModel qBModel = this.m_Frame.getModel();
            qBModel.removeLink(qBLink);
            if (n > 0) {
                --n;
            }
            if (this.m_List.getModel().getSize() > 0) {
                this.m_List.setSelectedIndex(n);
            }
            this.checkState();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.m_Parent.checkState();
    }

    public void checkState() {
        if (this.m_List.getModel().getSize() == 0) {
            this.setEnabled(false);
        } else {
            this.setEnabled(this.m_List.getSelectedValue() != null);
        }
    }
}

