/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.qb.ui.action;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.qb.I18N;
import com.elixirtech.qb.QBAction;
import com.elixirtech.qb.model.QBLink;
import com.elixirtech.qb.ui.LabelLayoutEx;
import com.elixirtech.qb.ui.QBFrame;
import com.elixirtech.ui.SwingFactory;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ShowLinkProperties
extends QBAction {
    private QBFrame m_Frame;
    private QBLink m_Link;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(ShowLinkProperties.class);

    public ShowLinkProperties(QBFrame qBFrame, QBLink qBLink) {
        super("ShowLinkProperties");
        this.m_Frame = qBFrame;
        this.m_Link = qBLink;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ShowLinkProperties.show(this.m_Frame, this.m_Link);
    }

    public static void show(final QBFrame qBFrame, final QBLink qBLink) {
        try {
            final JDialog jDialog = new JDialog(qBFrame.getDialog(), ShowLinkProperties.getString(I18N.QueryBuilder(), "QB.Properties"), true);
            Container container = jDialog.getContentPane();
            JLabel jLabel = new JLabel("  " + qBLink.toString() + "  ");
            container.add((Component)jLabel, "North");
            JPanel jPanel = new JPanel(new LabelLayoutEx());
            jPanel.add(new JLabel(ShowLinkProperties.getString(I18N.QueryBuilder(), "QB.Join-Type")));
            String[] stringArray = new String[]{"Inner Join"};
            final JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
            jComboBox.setSelectedItem(qBLink.getJoinType());
            jPanel.add(jComboBox);
            container.add((Component)jPanel, "Center");
            JPanel jPanel2 = new JPanel();
            JButton jButton = SwingFactory.newOkButton();
            I18N.QueryBuilderMap().injectComponents("QB.", jButton);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = (String)jComboBox.getSelectedItem();
                    qBLink.setJoinType(string);
                    qBFrame.getModel().firePropertyChange("link.join", null, string);
                    jDialog.dispose();
                }
            });
            jPanel2.add(jButton);
            container.add((Component)jPanel2, "South");
            jDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    qBLink.setJoinType((String)jComboBox.getSelectedItem());
                    jDialog.dispose();
                }
            });
            jDialog.pack();
            jDialog.setLocationRelativeTo(qBFrame.getDialog());
            jDialog.setVisible(true);
        }
        catch (Exception exception) {
            m_Log.error((Object)("Exception: " + String.valueOf(exception)));
        }
    }
}

