/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.remote;

import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.remote.ConnectionPoolLoader$;
import com.elixirtech.remote.HikariPool;
import com.elixirtech.remote.HikariPool$;
import com.elixirtech.remote.JDBCConfig;
import com.elixirtech.remote.JDBCConfig$;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.concurrent.Map;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class ConnectionPool$
implements LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(ConnectionPool$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private static final Map<String, Option<HikariPool>> cache;
    public static final ConnectionPool$ MODULE$;

    private ConnectionPool$() {
    }

    static {
        MODULE$ = new ConnectionPool$();
        cache = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ConnectionPool$.class);
    }

    public Set<String> getPoolNames() {
        return JDBCConfig$.MODULE$.ConnectionPoolMap().keySet();
    }

    public void prestartPools() {
        ((List)JDBCConfig$.MODULE$.ConnectionPoolMap().keySet().toList().sorted((Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable)name -> MODULE$.getPool((String)name));
    }

    public HikariPool getPoolJ(String name) {
        return (HikariPool)this.getPool(name).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Option<HikariPool> getPool(String name) {
        Option option;
        ConnectionPool$ connectionPool$ = this;
        synchronized (connectionPool$) {
            Option option2;
            Option optPool;
            Option option3 = optPool = (Option)cache.getOrElseUpdate((Object)name, () -> ConnectionPool$.$anonfun$1(name));
            if (option3 instanceof Some) {
                HikariPool pool = (HikariPool)((Some)option3).value();
                option2 = optPool;
            } else if (None$.MODULE$.equals(option3)) {
                this.log().error(() -> ConnectionPool$.getPool$$anonfun$1(name), Line$.MODULE$.apply(27), FullName$.MODULE$.apply("com.elixirtech.remote.ConnectionPool.getPool"));
                option2 = optPool;
            } else {
                throw new MatchError((Object)option3);
            }
            option = option2;
        }
        return option;
    }

    public void resetPool(String name) {
        cache.replace((Object)name, this.buildPool(name));
    }

    private Option<HikariPool> buildPool(String name) {
        None$ none$;
        block5: {
            String string = JDBCConfig$.MODULE$.ConnectionPoolImplementation();
            String string2 = "hikari";
            if (string == null ? string2 != null : !string.equals(string2)) {
                this.log().error(ConnectionPool$::buildPool$$anonfun$1, Line$.MODULE$.apply(39), FullName$.MODULE$.apply("com.elixirtech.remote.ConnectionPool.buildPool"));
            }
            try {
                Option option = JDBCConfig$.MODULE$.ConnectionPoolMap().get((Object)name);
                if (option instanceof Some) {
                    JDBCConfig.PoolConfig poolConfig = (JDBCConfig.PoolConfig)((Some)option).value();
                    Properties properties = ConnectionPoolLoader$.MODULE$.load(poolConfig.file());
                    HikariConfig hconfig = new HikariConfig(properties);
                    none$ = Some$.MODULE$.apply((Object)HikariPool$.MODULE$.apply(new HikariDataSource(hconfig), poolConfig.optCatalogPattern(), poolConfig.optSchemaPattern(), poolConfig.optTablePattern()));
                    break block5;
                }
                if (None$.MODULE$.equals(option)) {
                    this.log().error(() -> ConnectionPool$.buildPool$$anonfun$2(name), Line$.MODULE$.apply(51), FullName$.MODULE$.apply("com.elixirtech.remote.ConnectionPool.buildPool"));
                    none$ = None$.MODULE$;
                    break block5;
                }
                throw new MatchError((Object)option);
            }
            catch (Exception ex) {
                this.log().error(() -> ConnectionPool$.buildPool$$anonfun$3(name, ex), (Throwable)ex, Line$.MODULE$.apply(57), FullName$.MODULE$.apply("com.elixirtech.remote.ConnectionPool.buildPool"));
                none$ = None$.MODULE$;
            }
        }
        return none$;
    }

    private static final Option $anonfun$1(String name$1) {
        return MODULE$.buildPool(name$1);
    }

    private static final Object getPool$$anonfun$1(String name$2) {
        return "unable to find pool " + name$2;
    }

    private static final Object buildPool$$anonfun$1() {
        return "Unknown connection pool implementation: " + JDBCConfig$.MODULE$ + ".ConnectionPoolImplementation";
    }

    private static final Object buildPool$$anonfun$2(String name$3) {
        return "No connection-pool defined for " + name$3;
    }

    private static final Object buildPool$$anonfun$3(String name$4, Exception ex$1) {
        return "Error loading connection pool " + name$4 + ": " + ex$1;
    }
}

