/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.remote;

import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.Data2Constants;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DefaultPushContext;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.IgnoreJDBCSchema$;
import com.elixirtech.data2.Parameter;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.TableIdentifier;
import com.elixirtech.data2.attributes.Comments;
import com.elixirtech.data2.attributes.ForeignKey;
import com.elixirtech.data2.attributes.Nullable;
import com.elixirtech.data2.attributes.PrimaryKey;
import com.elixirtech.data2.datasource.jdbc.JDBCConnector;
import com.elixirtech.data2.datasource.jdbc.JDBCDataSource;
import com.elixirtech.jdom.Content;
import com.elixirtech.jdom.Document;
import com.elixirtech.jdom.Element;
import com.elixirtech.remote.ISchemaAccess;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import scala.Function1;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.function.JProcedure1;
import sourcecode.FullName$;
import sourcecode.Line$;

public class LocalSchemaAccess
implements ISchemaAccess,
LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(LocalSchemaAccess.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public DataSchema inferSchema(IDataSource src, Map<String, String> values) {
        IDataSource iDataSource = src;
        if (iDataSource instanceof JDBCDataSource) {
            JDBCDataSource jds = (JDBCDataSource)iDataSource;
            DefaultPushContext cxt = new DefaultPushContext();
            cxt.setParameters(values);
            return jds.inferSchema((PushContext)cxt);
        }
        return new DataSchema();
    }

    @Override
    public Document getMetadata(JDBCConnector conn) {
        Document document;
        this.verifyParams(conn);
        try (Connection c = conn.getConnection((ArgumentMap.ICallback)new ArgumentMap.CallbackMap());){
            document = this.getMetadata(c);
        }
        catch (SQLException ex) {
            throw new RuntimeException("Error reading metadata: " + ex, ex);
        }
        return document;
    }

    public Document getMetadata(Connection c) {
        Document document;
        try {
            Element root = new Element("metadata", Data2Constants.NS_DATASOURCE);
            DatabaseMetaData metadata = c.getMetaData();
            root.addContent((Content)this.field("catalog-separator", metadata.getCatalogSeparator()));
            root.addContent((Content)this.field("catalog-term", metadata.getCatalogTerm()));
            root.addContent((Content)this.field("database-minor-version", metadata.getDatabaseMajorVersion()));
            root.addContent((Content)this.field("database-major-version", metadata.getDatabaseMinorVersion()));
            root.addContent((Content)this.field("database-product-name", metadata.getDatabaseProductName()));
            root.addContent((Content)this.field("database-product-version", metadata.getDatabaseProductVersion()));
            root.addContent((Content)this.field("driver-major-version", metadata.getDriverMajorVersion()));
            root.addContent((Content)this.field("driver-minor-version", metadata.getDriverMinorVersion()));
            root.addContent((Content)this.field("driver-name", metadata.getDriverName()));
            root.addContent((Content)this.field("driver-version", metadata.getDriverVersion()));
            root.addContent((Content)this.field("extra-name-characters", metadata.getExtraNameCharacters()));
            root.addContent((Content)this.field("identifier-quote-string", metadata.getIdentifierQuoteString()));
            root.addContent((Content)this.field("jdbc-major-version", metadata.getJDBCMajorVersion()));
            root.addContent((Content)this.field("jdbc-minor-version", metadata.getJDBCMinorVersion()));
            root.addContent((Content)this.field("numeric-functions", metadata.getNumericFunctions()));
            root.addContent((Content)this.field("procedure-term", metadata.getProcedureTerm()));
            root.addContent((Content)this.field("schema-term", metadata.getSchemaTerm()));
            root.addContent((Content)this.field("search-string-escape", metadata.getSearchStringEscape()));
            root.addContent((Content)this.field("sql-keywords", metadata.getSQLKeywords()));
            root.addContent((Content)this.field("string-functions", metadata.getStringFunctions()));
            root.addContent((Content)this.field("system-functions", metadata.getSystemFunctions()));
            root.addContent((Content)this.field("time-date-functions", metadata.getTimeDateFunctions()));
            document = new Document(root);
        }
        catch (SQLException ex) {
            throw new RuntimeException("Error reading metadata: " + ex, ex);
        }
        return document;
    }

    private Element field(String name, String value) {
        Element e = new Element("field", Data2Constants.NS_DATASOURCE);
        e.setAttribute("name", name);
        e.setText(value);
        return e;
    }

    private Element field(String name, int value) {
        Element e = new Element("field", Data2Constants.NS_DATASOURCE);
        e.setAttribute("name", name);
        e.setText(String.valueOf(value));
        return e;
    }

    @Override
    public Document getTableMetadata(JDBCConnector conn) {
        Document document;
        this.verifyParams(conn);
        try {
            Element root = new Element("metadata", Data2Constants.NS_DATASOURCE);
            Connection c = conn.getConnection((ArgumentMap.ICallback)new ArgumentMap.CallbackMap());
            DatabaseMetaData metadata = c.getMetaData();
            root.setAttribute("identifier-quote-string", metadata.getIdentifierQuoteString());
            this.buildTables(metadata, root);
            c.close();
            document = new Document(root);
        }
        catch (SQLException ex) {
            throw new DataException("Error reading table metadata: " + ex, (Throwable)ex);
        }
        return document;
    }

    private void buildTables(DatabaseMetaData metadata, Element root) {
        this.buildStruct(metadata, root, "table", "TABLE");
        this.buildStruct(metadata, root, "view", "VIEW");
    }

    private void buildStruct(DatabaseMetaData metadata, Element root, String type, String filter) {
        ResultSet tables = metadata.getTables(null, null, null, new String[]{filter});
        HashSet<String> tableTypes = new HashSet<String>();
        while (tables.next()) {
            String schema;
            String tableType = tables.getString("TABLE_TYPE");
            tableTypes.add(tableType);
            String catalog = tables.getString("TABLE_CAT");
            if (catalog == null) {
                catalog = "";
            }
            if ((schema = tables.getString("TABLE_SCHEM")) == null) {
                schema = "";
            }
            String tableName = tables.getString("TABLE_NAME");
            boolean ignore = IgnoreJDBCSchema$.MODULE$.ignore(schema);
            boolean systable = "SYSTEM TABLE".equalsIgnoreCase(tableType);
            boolean sys = "sys".equalsIgnoreCase(schema);
            boolean information = "INFORMATION_SCHEMA".equalsIgnoreCase(schema);
            if (!((List)new .colon.colon((Object)BoxesRunTime.boxToBoolean((boolean)ignore), (List)new .colon.colon((Object)BoxesRunTime.boxToBoolean((boolean)systable), (List)new .colon.colon((Object)BoxesRunTime.boxToBoolean((boolean)sys), (List)new .colon.colon((Object)BoxesRunTime.boxToBoolean((boolean)information), (List)Nil$.MODULE$))))).forall((Function1 & Serializable)_$1 -> LocalSchemaAccess.buildStruct$$anonfun$1(BoxesRunTime.unboxToBoolean((Object)_$1)))) continue;
            Element table = new Element(type, Data2Constants.NS_DATASOURCE);
            this.setAttribute(table, "catalog", catalog);
            this.setAttribute(table, "schema", schema);
            this.setAttribute(table, "name", tableName);
            root.addContent((Content)table);
        }
        tables.close();
        StringBuilder sb = new StringBuilder();
        CollectionConverters$.MODULE$.SetHasAsScala(tableTypes).asScala().foreach((Function1 & Serializable)s -> sb.append(s + ", "));
        this.log().info(() -> LocalSchemaAccess.buildStruct$$anonfun$3(sb), Line$.MODULE$.apply(141), FullName$.MODULE$.apply("com.elixirtech.remote.LocalSchemaAccess.buildStruct"));
    }

    private void setAttribute(Element e, String name, String value) {
        if (value != null) {
            e.setAttribute(name, value);
            return;
        }
    }

    @Override
    public Document getColumnMetadata(JDBCConnector conn, String catalog, String schema, String table) {
        Element root = new Element("table");
        if (catalog != null) {
            root.setAttribute("catalog", catalog);
        }
        if (schema != null) {
            root.setAttribute("schema", schema);
        }
        if (table != null) {
            root.setAttribute("name", table);
        }
        this.fillInColumnMetadata(conn, root);
        return new Document(root);
    }

    public void fillInColumnMetadata(JDBCConnector conn, Element table) throws DataException {
        this.verifyParams(conn);
        TableIdentifier tableId = new TableIdentifier();
        tableId.catalog = table.getAttributeValue("catalog");
        tableId.schema = table.getAttributeValue("schema");
        tableId.table = table.getAttributeValue("name");
        try {
            Connection c = conn.getConnection((ArgumentMap.ICallback)new ArgumentMap.CallbackMap());
            DatabaseMetaData metadata = c.getMetaData();
            this.buildColumns(metadata, table, tableId);
            c.close();
        }
        catch (SQLException ex) {
            throw new DataException("Error reading column metadata: " + ex, (Throwable)ex);
        }
    }

    public void buildColumns(DatabaseMetaData metadata, Element table, TableIdentifier id) throws SQLException {
        HashMap<String, PrimaryKey> pkeys = this.loadPrimaryKeys(metadata, id);
        HashMap<String, ForeignKey> fkeys = this.loadForeignKeys(metadata, id);
        String escape = this.getSearchStringEscape(metadata);
        ResultSet columns = metadata.getColumns(id.catalog, this.safe(escape, id.schema), this.safe(escape, id.table), null);
        while (columns.next()) {
            int nullable;
            Element col = new Element("column", Data2Constants.NS_DATASOURCE);
            String colName = columns.getString("COLUMN_NAME");
            this.setAttribute(col, "name", colName);
            this.setAttribute(col, "type", String.valueOf(columns.getInt("DATA_TYPE")));
            this.setAttribute(col, "type-name", columns.getString("TYPE_NAME"));
            this.setAttribute(col, "size", String.valueOf(columns.getInt("COLUMN_SIZE")));
            String defaultValue = columns.getString("COLUMN_DEF");
            if (defaultValue != null) {
                this.setAttribute(col, "default", defaultValue);
            }
            if ((nullable = columns.getInt("NULLABLE")) == 1) {
                col.addContent((Content)new Nullable(true).getElement());
            } else if (nullable == 0) {
                col.addContent((Content)new Nullable(false).getElement());
            }
            String comments = columns.getString("REMARKS");
            if (StringUtil.notEmpty((String)comments)) {
                col.addContent((Content)new Comments(comments).getElement());
            }
            if (pkeys.containsKey(colName)) {
                col.addContent((Content)pkeys.get(colName).getElement());
            }
            if (fkeys.containsKey(colName)) {
                col.addContent((Content)fkeys.get(colName).getElement());
            }
            table.addContent((Content)col);
        }
        columns.close();
    }

    private HashMap<String, PrimaryKey> loadPrimaryKeys(DatabaseMetaData metadata, TableIdentifier id) {
        HashMap<String, PrimaryKey> pkeys = new HashMap<String, PrimaryKey>();
        try {
            ResultSet keys = metadata.getPrimaryKeys(id.catalog, id.schema, id.table);
            if (keys != null) {
                while (keys.next()) {
                    String keyCol = keys.getString("COLUMN_NAME");
                    int seq = keys.getInt("KEY_SEQ");
                    String keyName = keys.getString("PK_NAME");
                    pkeys.put(keyCol, new PrimaryKey(seq, keyName));
                }
                keys.close();
            }
        }
        catch (SQLException ex) {}
        return pkeys;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HashMap<String, ForeignKey> loadForeignKeys(DatabaseMetaData metadata, TableIdentifier id) {
        HashMap<String, ForeignKey> fkeys = new HashMap<String, ForeignKey>();
        try {
            ResultSet keys = metadata.getImportedKeys(id.catalog, id.schema, id.table);
            if (keys == null) return fkeys;
            while (keys.next()) {
                String fkTable;
                String pkTable = keys.getString("PKTABLE_NAME");
                String pkColumn = keys.getString("PKCOLUMN_NAME");
                String string = fkTable = keys.getString("FKTABLE_NAME");
                String string2 = id.table;
                if (string == null ? string2 != null : !string.equals(string2)) {
                    throw Scala3RunTime$.MODULE$.assertFailed();
                }
                String fkColumn = keys.getString("FKCOLUMN_NAME");
                int seq = keys.getInt("KEY_SEQ");
                String name = keys.getString("FK_NAME");
                int updateRule = keys.getInt("UPDATE_RULE");
                int deleteRule = keys.getInt("DELETE_RULE");
                fkeys.put(fkColumn, new ForeignKey(pkTable, pkColumn, seq, name, updateRule, deleteRule));
            }
            keys.close();
            return fkeys;
        }
        catch (SQLException ex) {
            return fkeys;
        }
    }

    private String getSearchStringEscape(DatabaseMetaData metadata) {
        String escape = metadata.getSearchStringEscape();
        escape = escape.replace("//", "/");
        return escape;
    }

    private String safe(String escape, String s) {
        if (s == null) {
            return s;
        }
        String ret = s.replace("_", escape + "_");
        ret = ret.replace("%", escape + "%");
        return ret;
    }

    private void verifyParams(JDBCConnector conn) {
        ArgumentMap map = new ArgumentMap();
        conn.extractParameters(map);
        Buffer params = CollectionConverters$.MODULE$.ListHasAsScala(map.getParameters()).asScala();
        if (params.nonEmpty()) {
            params.foreach((Function1)(JProcedure1 & Serializable)p -> this.log().error(() -> LocalSchemaAccess.verifyParams$$anonfun$1$$anonfun$1(p), Line$.MODULE$.apply(283), FullName$.MODULE$.apply("com.elixirtech.remote.LocalSchemaAccess.verifyParams")));
            throw new RuntimeException("JDBCConnector has " + params.size() + " unresolved substitutions.");
        }
    }

    private static final /* synthetic */ boolean buildStruct$$anonfun$1(boolean _$1) {
        return !_$1;
    }

    private static final Object buildStruct$$anonfun$3(StringBuilder sb$2) {
        return "Table types found: " + sb$2.toString();
    }

    private static final Object verifyParams$$anonfun$1$$anonfun$1(Parameter p$1) {
        return "Unresolved substitution: " + p$1.getName();
    }
}

