/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.remote.a2021;

import com.elixirtech.arch.GUIClientRequest$;
import com.elixirtech.arch.HttpClientResponse;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.Path;
import com.elixirtech.arch.Path$;
import com.elixirtech.connector.A2021Connection;
import com.elixirtech.guiapi.ambience.URIHelper$;
import com.elixirtech.remote.a2021.A2021FileObject;
import com.elixirtech.remote.a2021.A2021FileSystem;
import com.elixirtech.remote.a2021.A2021Repository$;
import com.elixirtech.remote.a2021.A2021Repository$ChildFile$;
import com.elixirtech.remote.a2021.A2021Repository$ChildFolder$;
import com.elixirtech.remote.a2021.A2021Repository$Children$;
import com.elixirtech.remote.a2021.A2021Repository$ChildrenJson$;
import com.elixirtech.remote.a2021.A2021Repository$FilePath$;
import com.elixirtech.repository.FCLSupport;
import com.elixirtech.repository.FCLSupport$;
import com.elixirtech.repository.FileChangeListener;
import com.elixirtech.repository.FileEvent;
import com.elixirtech.v2.repository.FileObject;
import com.elixirtech.v2.repository.FileSystem;
import com.elixirtech.v2.repository.Repository;
import io.circe.Json;
import io.circe.Json$;
import io.circe.ParsingFailure;
import java.io.Serializable;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public class A2021Repository
implements Repository {
    private final String baseUri;
    private final Map cookie;
    private final FCLSupport fclSupport;
    private final A2021FileSystem fileSystem;
    private final HashMap<Path, List<FileChangeListener>> foListeners;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(A2021Repository$.class.getDeclaredField("log$lzy1"));

    public static Children decodeChildren(Path path, String string) {
        return A2021Repository$.MODULE$.decodeChildren(path, string);
    }

    public static LoggingInterface log() {
        return A2021Repository$.MODULE$.log();
    }

    public A2021Repository(A2021Connection connection) {
        this.baseUri = connection.connectionInfo().requestedServer();
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"Cookie");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)(connection.response().cookie()._1() + "=" + connection.response().cookie()._2()));
        this.cookie = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        this.fclSupport = new FCLSupport();
        this.fileSystem = new A2021FileSystem(this);
        this.foListeners = new HashMap();
    }

    public String baseUri() {
        return this.baseUri;
    }

    public Map<String, String> cookie() {
        return this.cookie;
    }

    public FCLSupport fclSupport() {
        return this.fclSupport;
    }

    public A2021FileSystem fileSystem() {
        return this.fileSystem;
    }

    public void activity() {
        A2021Repository$.MODULE$.log().info(A2021Repository::activity$$anonfun$1, Line$.MODULE$.apply(50), FullName$.MODULE$.apply("com.elixirtech.remote.a2021.A2021Repository.activity"));
        String string = this.baseUri() + "/activity";
        Map<String, String> map = GUIClientRequest$.MODULE$.get$default$2();
        GUIClientRequest$.MODULE$.get(string, map, this.cookie());
    }

    @Override
    public void addFileChangeListener(FileChangeListener fcl) {
        this.fclSupport().addFileChangeListener(fcl);
    }

    @Override
    public void removeFileChangeListener(FileChangeListener fcl) {
        this.fclSupport().removeFileChangeListener(fcl);
    }

    @Override
    public List<FileSystem> getFileSystems() {
        return (List)new .colon.colon((Object)this.fileSystem(), (List)Nil$.MODULE$);
    }

    @Override
    public Option<FileSystem> getFileSystem(String name) {
        return Some$.MODULE$.apply((Object)this.fileSystem());
    }

    @Override
    public Option<FileObject> getFile(String name) {
        Path path = Path$.MODULE$.apply(this.removePrefix(name));
        A2021Repository$.MODULE$.log().info(() -> A2021Repository.getFile$$anonfun$1(path), Line$.MODULE$.apply(69), FullName$.MODULE$.apply("com.elixirtech.remote.a2021.A2021Repository.getFile"));
        return this.fileSystem().find(path.toRelativeString());
    }

    @Override
    public FileObject createData(String name) {
        return this.fileSystem().createData(this.removePrefix(name));
    }

    @Override
    public FileObject createFolder(String name) {
        return this.fileSystem().createFolder(this.removePrefix(name));
    }

    @Override
    public void refresh() {
        FileEvent ev = new FileEvent(this.fileSystem().rootFO());
        this.fclSupport().dispatchEvent(ev, FCLSupport$.MODULE$.FILE_CHANGED());
    }

    @Override
    public void dispose() {
    }

    public void addFileChangeListener(FileObject fo, FileChangeListener fcl) {
        Path path = fo.getPath();
        List existing = (List)this.foListeners.getOrElse((Object)path, A2021Repository::$anonfun$1);
        Path path2 = (Path)Predef$.MODULE$.ArrowAssoc((Object)path);
        this.foListeners.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)path2, (Object)existing.$colon$colon((Object)fcl)));
    }

    public void removeFileChangeListener(FileObject fo, FileChangeListener fcl) {
        Path path = fo.getPath();
        List remaining = ((List)this.foListeners.getOrElse((Object)path, A2021Repository::$anonfun$2)).filter((Function1 & Serializable)_$1 -> {
            FileChangeListener fileChangeListener = _$1;
            FileChangeListener fileChangeListener2 = fcl;
            return fileChangeListener == null ? fileChangeListener2 != null : !fileChangeListener.equals(fileChangeListener2);
        });
        if (remaining.nonEmpty()) {
            Path path2 = (Path)Predef$.MODULE$.ArrowAssoc((Object)path);
            this.foListeners.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)path2, (Object)remaining));
            return;
        }
        this.foListeners.remove((Object)path);
    }

    @Override
    public void addRecentFile(FileObject fo) {
        throw new UnsupportedOperationException();
    }

    public List<A2021FileObject> getChildren(Path path) {
        Map<String, String> map;
        String string = this.baseUri() + "/repository/navigator?path=" + this.encodedQuery(path);
        HttpClientResponse response = GUIClientRequest$.MODULE$.get(string, map = GUIClientRequest$.MODULE$.get$default$2(), this.cookie());
        if (response.statusCode() != 200) {
            A2021Repository$.MODULE$.log().warn(() -> A2021Repository.getChildren$$anonfun$1(response), Line$.MODULE$.apply(108), FullName$.MODULE$.apply("com.elixirtech.remote.a2021.A2021Repository.getChildren"));
            return package$.MODULE$.Nil();
        }
        return A2021Repository$.MODULE$.decodeChildren(path, new String(response.body(), "UTF-8")).children().map((Function1 & Serializable)ci -> this.buildFO((ChildInfo)ci));
    }

    public boolean canWrite(Path path) {
        Map<String, String> map;
        String string = this.baseUri() + "/repository/api/v1/can-write?path=" + this.encodedQuery(path);
        HttpClientResponse response = GUIClientRequest$.MODULE$.get(string, map = GUIClientRequest$.MODULE$.get$default$2(), this.cookie());
        if (response.statusCode() != 200) {
            A2021Repository$.MODULE$.log().warn(() -> A2021Repository.canWrite$$anonfun$1(response), Line$.MODULE$.apply(117), FullName$.MODULE$.apply("com.elixirtech.remote.a2021.A2021Repository.canWrite"));
            return false;
        }
        Either either = io.circe.parser.package$.MODULE$.parse(new String(response.body(), "UTF-8"));
        if (either instanceof Right) {
            Json json = (Json)((Right)either).value();
            return BoxesRunTime.unboxToBoolean((Object)json.hcursor().downField("canWrite").focus().flatMap((Function1 & Serializable)_$2 -> _$2.asBoolean()).getOrElse(A2021Repository::canWrite$$anonfun$3));
        }
        if (either instanceof Left) {
            ParsingFailure err = (ParsingFailure)((Left)either).value();
            A2021Repository$.MODULE$.log().warn(() -> A2021Repository.canWrite$$anonfun$4(err), Line$.MODULE$.apply(125), FullName$.MODULE$.apply("com.elixirtech.remote.a2021.A2021Repository.canWrite"));
            return false;
        }
        throw new MatchError((Object)either);
    }

    public byte[] getBytes(Path path) {
        A2021Repository$.MODULE$.log().info(() -> A2021Repository.getBytes$$anonfun$1(path), Line$.MODULE$.apply(132), FullName$.MODULE$.apply("com.elixirtech.remote.a2021.A2021Repository.getBytes"));
        String string = this.baseUri() + "/repository/api/v1/read?path=" + this.encodedQuery(path);
        Map<String, String> map = GUIClientRequest$.MODULE$.get$default$2();
        HttpClientResponse response = GUIClientRequest$.MODULE$.get(string, map, this.cookie());
        if (response.statusCode() != 200) {
            A2021Repository$.MODULE$.log().warn(() -> A2021Repository.getBytes$$anonfun$2(response), Line$.MODULE$.apply(135), FullName$.MODULE$.apply("com.elixirtech.remote.a2021.A2021Repository.getBytes"));
            return Array$.MODULE$.emptyByteArray();
        }
        return response.body();
    }

    public void putBytes(Path path, byte[] bytes) {
        A2021Repository$.MODULE$.log().info(() -> A2021Repository.putBytes$$anonfun$1(path, bytes), Line$.MODULE$.apply(142), FullName$.MODULE$.apply("com.elixirtech.remote.a2021.A2021Repository.putBytes"));
        HttpClientResponse response = GUIClientRequest$.MODULE$.postBytes(this.baseUri() + "/repository/api/v1/write?path=" + this.encodedQuery(path), bytes, this.cookie());
        if (response.statusCode() != 200) {
            A2021Repository$.MODULE$.log().warn(() -> A2021Repository.putBytes$$anonfun$2(path, response), Line$.MODULE$.apply(146), FullName$.MODULE$.apply("com.elixirtech.remote.a2021.A2021Repository.putBytes"));
            throw new RuntimeException("Write " + path.toString() + " failed: " + new String(response.body(), "UTF-8"));
        }
    }

    public void addFolder(Path path, String name) {
        A2021Repository$.MODULE$.log().info(() -> A2021Repository.addFolder$$anonfun$1(path, name), Line$.MODULE$.apply(152), FullName$.MODULE$.apply("com.elixirtech.remote.a2021.A2021Repository.addFolder"));
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"path");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromString(path.toString()));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"name");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Json$.MODULE$.fromString(name));
        Json json = Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        HttpClientResponse response = GUIClientRequest$.MODULE$.postJson(this.baseUri() + "/repository/action/add-folder", json, this.cookie());
        if (response.statusCode() != 200) {
            A2021Repository$.MODULE$.log().warn(() -> A2021Repository.addFolder$$anonfun$2(path, name, response), Line$.MODULE$.apply(156), FullName$.MODULE$.apply("com.elixirtech.remote.a2021.A2021Repository.addFolder"));
            throw new RuntimeException("Add folder (" + path.toString() + "," + name + ") failed: " + new String(response.body(), "UTF-8"));
        }
    }

    public void renameFile(Path path, String name) {
        A2021Repository$.MODULE$.log().info(() -> A2021Repository.renameFile$$anonfun$1(path), Line$.MODULE$.apply(162), FullName$.MODULE$.apply("com.elixirtech.remote.a2021.A2021Repository.renameFile"));
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"path");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromString(path.toString()));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"name");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Json$.MODULE$.fromString(name));
        Json json = Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        HttpClientResponse response = GUIClientRequest$.MODULE$.postJson(this.baseUri() + "/repository/action/rename-file", json, this.cookie());
        if (response.statusCode() != 200) {
            A2021Repository$.MODULE$.log().warn(() -> A2021Repository.renameFile$$anonfun$2(path, response), Line$.MODULE$.apply(166), FullName$.MODULE$.apply("com.elixirtech.remote.a2021.A2021Repository.renameFile"));
            throw new RuntimeException("Rename file (" + path.toString() + "," + name + ") failed: " + new String(response.body(), "UTF-8"));
        }
    }

    public void renameFolder(Path path, String name) {
        A2021Repository$.MODULE$.log().info(() -> A2021Repository.renameFolder$$anonfun$1(path), Line$.MODULE$.apply(172), FullName$.MODULE$.apply("com.elixirtech.remote.a2021.A2021Repository.renameFolder"));
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"path");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromString(path.toString()));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"name");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Json$.MODULE$.fromString(name));
        Json json = Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        HttpClientResponse response = GUIClientRequest$.MODULE$.postJson(this.baseUri() + "/repository/action/rename-folder", json, this.cookie());
        if (response.statusCode() != 200) {
            A2021Repository$.MODULE$.log().warn(() -> A2021Repository.renameFolder$$anonfun$2(path, response), Line$.MODULE$.apply(176), FullName$.MODULE$.apply("com.elixirtech.remote.a2021.A2021Repository.renameFolder"));
            throw new RuntimeException("Rename folder (" + path.toString() + "," + name + ") failed: " + new String(response.body(), "UTF-8"));
        }
    }

    public void deleteFile(Path path) {
        A2021Repository$.MODULE$.log().info(() -> A2021Repository.deleteFile$$anonfun$1(path), Line$.MODULE$.apply(182), FullName$.MODULE$.apply("com.elixirtech.remote.a2021.A2021Repository.deleteFile"));
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"path");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromString(path.toString()));
        Json json = Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        HttpClientResponse response = GUIClientRequest$.MODULE$.postJson(this.baseUri() + "/repository/action/delete-file", json, this.cookie());
        if (response.statusCode() != 200) {
            A2021Repository$.MODULE$.log().warn(() -> A2021Repository.deleteFile$$anonfun$2(path, response), Line$.MODULE$.apply(186), FullName$.MODULE$.apply("com.elixirtech.remote.a2021.A2021Repository.deleteFile"));
            throw new RuntimeException("Delete file " + path.toString() + " failed: " + new String(response.body(), "UTF-8"));
        }
    }

    public void deleteFolder(Path path) {
        A2021Repository$.MODULE$.log().info(() -> A2021Repository.deleteFolder$$anonfun$1(path), Line$.MODULE$.apply(192), FullName$.MODULE$.apply("com.elixirtech.remote.a2021.A2021Repository.deleteFolder"));
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"path");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromString(path.toString()));
        Json json = Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        HttpClientResponse response = GUIClientRequest$.MODULE$.postJson(this.baseUri() + "/repository/action/delete-folder", json, this.cookie());
        if (response.statusCode() != 200) {
            A2021Repository$.MODULE$.log().warn(() -> A2021Repository.deleteFolder$$anonfun$2(path, response), Line$.MODULE$.apply(196), FullName$.MODULE$.apply("com.elixirtech.remote.a2021.A2021Repository.deleteFolder"));
            throw new RuntimeException("Delete folder " + path.toString() + " failed: " + new String(response.body(), "UTF-8"));
        }
    }

    public boolean setIgnore(Path path) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"path");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromString(path.toString()));
        Json json = Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        HttpClientResponse response = GUIClientRequest$.MODULE$.postJson(this.baseUri() + "/repository/action/add-git-push-ignore", json, this.cookie());
        return response.statusCode() == 200;
    }

    public boolean resetIgnore(Path path) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"path");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromString(path.toString()));
        Json json = Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        HttpClientResponse response = GUIClientRequest$.MODULE$.postJson(this.baseUri() + "/repository/action/remove-git-push-ignore", json, this.cookie());
        return response.statusCode() == 200;
    }

    private A2021FileObject buildFO(ChildInfo ci) {
        ChildInfo childInfo = ci;
        if (childInfo instanceof ChildFile) {
            ChildFile file = (ChildFile)childInfo;
            return new A2021FileObject(this, Path$.MODULE$.apply(file.path()), (Option<ChildFile>)Some$.MODULE$.apply((Object)file));
        }
        if (childInfo instanceof ChildFolder) {
            ChildFolder folder = (ChildFolder)childInfo;
            return new A2021FileObject(this, Path$.MODULE$.apply(folder.path()), (Option<ChildFile>)None$.MODULE$);
        }
        throw new MatchError((Object)childInfo);
    }

    private String removePrefix(String nameValue) {
        return StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(nameValue), "repository:")), "/");
    }

    private String encodedQuery(Path path) {
        return URIHelper$.MODULE$.encodeQueryItem(path.toString());
    }

    private static final Object activity$$anonfun$1() {
        return "activity";
    }

    private static final Object getFile$$anonfun$1(Path path$1) {
        return "getFile " + path$1;
    }

    private static final List $anonfun$1() {
        return package$.MODULE$.Nil();
    }

    private static final List $anonfun$2() {
        return package$.MODULE$.Nil();
    }

    private static final Object getChildren$$anonfun$1(HttpClientResponse response$1) {
        return "getChildren HTTP Error " + response$1.statusCode() + ": " + new String(response$1.body(), "UTF-8");
    }

    private static final Object canWrite$$anonfun$1(HttpClientResponse response$2) {
        return "canWrite HTTP Error " + response$2.statusCode() + ": " + new String(response$2.body(), "UTF-8");
    }

    private static final boolean canWrite$$anonfun$3() {
        return false;
    }

    private static final Object canWrite$$anonfun$4(ParsingFailure err$1) {
        return "canWrite parsing Error: " + err$1;
    }

    private static final Object getBytes$$anonfun$1(Path path$2) {
        return "getBytes(" + path$2.toString() + ")";
    }

    private static final Object getBytes$$anonfun$2(HttpClientResponse response$3) {
        return "getBytes HTTP Error " + response$3.statusCode() + ": " + new String(response$3.body(), "UTF-8");
    }

    private static final Object putBytes$$anonfun$1(Path path$3, byte[] bytes$1) {
        return "putBytes(" + path$3.toString() + ", <" + bytes$1.length + " bytes>)";
    }

    private static final Object putBytes$$anonfun$2(Path path$4, HttpClientResponse response$4) {
        return "putBytes(" + path$4.toString() + ") HTTP Error " + response$4.statusCode() + ": " + new String(response$4.body(), "UTF-8");
    }

    private static final Object addFolder$$anonfun$1(Path path$5, String name$1) {
        return "addFolder(" + path$5.toString() + "," + name$1 + ")";
    }

    private static final Object addFolder$$anonfun$2(Path path$6, String name$2, HttpClientResponse response$5) {
        return "addFolder(" + path$6.toString() + "," + name$2 + ") HTTP Error " + response$5.statusCode() + ": " + new String(response$5.body(), "UTF-8");
    }

    private static final Object renameFile$$anonfun$1(Path path$7) {
        return "renameFile(" + path$7.toString() + ")";
    }

    private static final Object renameFile$$anonfun$2(Path path$8, HttpClientResponse response$6) {
        return "renameFile(" + path$8.toString() + ") HTTP Error " + response$6.statusCode() + ": " + new String(response$6.body(), "UTF-8");
    }

    private static final Object renameFolder$$anonfun$1(Path path$9) {
        return "renameFile(" + path$9.toString() + ")";
    }

    private static final Object renameFolder$$anonfun$2(Path path$10, HttpClientResponse response$7) {
        return "renameFile(" + path$10.toString() + ") HTTP Error " + response$7.statusCode() + ": " + new String(response$7.body(), "UTF-8");
    }

    private static final Object deleteFile$$anonfun$1(Path path$11) {
        return "deleteFile(" + path$11.toString() + ")";
    }

    private static final Object deleteFile$$anonfun$2(Path path$12, HttpClientResponse response$8) {
        return "deleteFile(" + path$12.toString() + ") HTTP Error " + response$8.statusCode() + ": " + new String(response$8.body(), "UTF-8");
    }

    private static final Object deleteFolder$$anonfun$1(Path path$13) {
        return "deleteFolder(" + path$13.toString() + ")";
    }

    private static final Object deleteFolder$$anonfun$2(Path path$14, HttpClientResponse response$9) {
        return "deleteFolder(" + path$14.toString() + ") HTTP Error " + response$9.statusCode() + ": " + new String(response$9.body(), "UTF-8");
    }

    public static final class ChildFile
    implements Product,
    ChildInfo {
        private final String path;
        private final String tags;
        private final long length;
        private final long lastModified;

        public static ChildFile apply(String string, String string2, long l, long l2) {
            return A2021Repository$ChildFile$.MODULE$.apply(string, string2, l, l2);
        }

        public static ChildFile fromProduct(Product product) {
            return A2021Repository$ChildFile$.MODULE$.fromProduct(product);
        }

        public static ChildFile unapply(ChildFile childFile) {
            return A2021Repository$ChildFile$.MODULE$.unapply(childFile);
        }

        public ChildFile(String path, String tags, long length, long lastModified) {
            this.path = path;
            this.tags = tags;
            this.length = length;
            this.lastModified = lastModified;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.path()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.tags()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.length()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.lastModified()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ChildFile)) return false;
            ChildFile childFile = (ChildFile)object;
            if (this.length() != childFile.length()) return false;
            if (this.lastModified() != childFile.lastModified()) return false;
            String string = this.path();
            String string2 = childFile.path();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.tags();
            String string4 = childFile.tags();
            if (string3 == null) {
                if (string4 == null) return true;
                return false;
            } else {
                if (!string3.equals(string4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ChildFile;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "ChildFile";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return BoxesRunTime.boxToLong((long)this._3());
                }
                case 3: {
                    return BoxesRunTime.boxToLong((long)this._4());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "path";
                }
                case 1: {
                    return "tags";
                }
                case 2: {
                    return "length";
                }
                case 3: {
                    return "lastModified";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String path() {
            return this.path;
        }

        public String tags() {
            return this.tags;
        }

        public long length() {
            return this.length;
        }

        public long lastModified() {
            return this.lastModified;
        }

        public ChildFile copy(String path, String tags, long length, long lastModified) {
            return new ChildFile(path, tags, length, lastModified);
        }

        public String copy$default$1() {
            return this.path();
        }

        public String copy$default$2() {
            return this.tags();
        }

        public long copy$default$3() {
            return this.length();
        }

        public long copy$default$4() {
            return this.lastModified();
        }

        public String _1() {
            return this.path();
        }

        public String _2() {
            return this.tags();
        }

        public long _3() {
            return this.length();
        }

        public long _4() {
            return this.lastModified();
        }
    }

    public static final class ChildFolder
    implements Product,
    ChildInfo {
        private final String path;

        public static ChildFolder apply(String string) {
            return A2021Repository$ChildFolder$.MODULE$.apply(string);
        }

        public static ChildFolder fromProduct(Product product) {
            return A2021Repository$ChildFolder$.MODULE$.fromProduct(product);
        }

        public static ChildFolder unapply(ChildFolder childFolder) {
            return A2021Repository$ChildFolder$.MODULE$.unapply(childFolder);
        }

        public ChildFolder(String path) {
            this.path = path;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ChildFolder)) return false;
            ChildFolder childFolder = (ChildFolder)object;
            String string = this.path();
            String string2 = childFolder.path();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ChildFolder;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ChildFolder";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "path";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String path() {
            return this.path;
        }

        public ChildFolder copy(String path) {
            return new ChildFolder(path);
        }

        public String copy$default$1() {
            return this.path();
        }

        public String _1() {
            return this.path();
        }
    }

    public static interface ChildInfo
    extends Product,
    Serializable {
        public String path();
    }

    public static final class Children
    implements Product,
    Serializable {
        private final FilePath current;
        private final List children;

        public static Children apply(FilePath filePath, List<ChildInfo> list) {
            return A2021Repository$Children$.MODULE$.apply(filePath, list);
        }

        public static Children fromProduct(Product product) {
            return A2021Repository$Children$.MODULE$.fromProduct(product);
        }

        public static Children unapply(Children children) {
            return A2021Repository$Children$.MODULE$.unapply(children);
        }

        public Children(FilePath current, List<ChildInfo> children) {
            this.current = current;
            this.children = children;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Children)) return false;
            Children children = (Children)object;
            FilePath filePath = this.current();
            FilePath filePath2 = children.current();
            if (filePath == null) {
                if (filePath2 != null) {
                    return false;
                }
            } else if (!((Object)filePath).equals(filePath2)) return false;
            List<ChildInfo> list = this.children();
            List<ChildInfo> list2 = children.children();
            if (list == null) {
                if (list2 == null) return true;
                return false;
            } else {
                if (!list.equals(list2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Children;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Children";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "current";
            }
            if (1 == n2) {
                return "children";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public FilePath current() {
            return this.current;
        }

        public List<ChildInfo> children() {
            return this.children;
        }

        public Children copy(FilePath current, List<ChildInfo> children) {
            return new Children(current, children);
        }

        public FilePath copy$default$1() {
            return this.current();
        }

        public List<ChildInfo> copy$default$2() {
            return this.children();
        }

        public FilePath _1() {
            return this.current();
        }

        public List<ChildInfo> _2() {
            return this.children();
        }
    }

    public static final class ChildrenJson
    implements Product,
    Serializable {
        private final FilePath current;
        private final List children;

        public static ChildrenJson apply(FilePath filePath, List<Json> list) {
            return A2021Repository$ChildrenJson$.MODULE$.apply(filePath, list);
        }

        public static ChildrenJson fromProduct(Product product) {
            return A2021Repository$ChildrenJson$.MODULE$.fromProduct(product);
        }

        public static ChildrenJson unapply(ChildrenJson childrenJson) {
            return A2021Repository$ChildrenJson$.MODULE$.unapply(childrenJson);
        }

        public ChildrenJson(FilePath current, List<Json> children) {
            this.current = current;
            this.children = children;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ChildrenJson)) return false;
            ChildrenJson childrenJson = (ChildrenJson)object;
            FilePath filePath = this.current();
            FilePath filePath2 = childrenJson.current();
            if (filePath == null) {
                if (filePath2 != null) {
                    return false;
                }
            } else if (!((Object)filePath).equals(filePath2)) return false;
            List<Json> list = this.children();
            List<Json> list2 = childrenJson.children();
            if (list == null) {
                if (list2 == null) return true;
                return false;
            } else {
                if (!list.equals(list2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ChildrenJson;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ChildrenJson";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "current";
            }
            if (1 == n2) {
                return "children";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public FilePath current() {
            return this.current;
        }

        public List<Json> children() {
            return this.children;
        }

        public ChildrenJson copy(FilePath current, List<Json> children) {
            return new ChildrenJson(current, children);
        }

        public FilePath copy$default$1() {
            return this.current();
        }

        public List<Json> copy$default$2() {
            return this.children();
        }

        public FilePath _1() {
            return this.current();
        }

        public List<Json> _2() {
            return this.children();
        }
    }

    public static final class FilePath
    implements Product,
    Serializable {
        private final String path;

        public static FilePath apply(String string) {
            return A2021Repository$FilePath$.MODULE$.apply(string);
        }

        public static FilePath fromProduct(Product product) {
            return A2021Repository$FilePath$.MODULE$.fromProduct(product);
        }

        public static FilePath unapply(FilePath filePath) {
            return A2021Repository$FilePath$.MODULE$.unapply(filePath);
        }

        public FilePath(String path) {
            this.path = path;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof FilePath)) return false;
            FilePath filePath = (FilePath)object;
            String string = this.path();
            String string2 = filePath.path();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof FilePath;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "FilePath";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "path";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String path() {
            return this.path;
        }

        public FilePath copy(String path) {
            return new FilePath(path);
        }

        public String copy$default$1() {
            return this.path();
        }

        public String _1() {
            return this.path();
        }
    }
}

