/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.repertoire;

import com.elixirtech.arch.ByteUtil;
import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.ICachedFile;
import com.elixirtech.arch.repository.RepositoryConverter;
import com.elixirtech.data2.Data2Constants;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.datasource.DataSourceDefinition;
import com.elixirtech.data2.datasource.RawDataSource;
import com.elixirtech.jdom.Document;
import com.elixirtech.jdom.Element;
import com.elixirtech.jdom.JDOMException;
import com.elixirtech.jdom.input.SAXBuilder;
import com.elixirtech.util.FileUtil;
import com.elixirtech.v2.repository.FileObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.zip.GZIPInputStream;

public class DSUtil {
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(DSUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IDataSource load(FileObject fileObject) throws IOException {
        DataSourceManager dataSourceManager = (DataSourceManager)Elixir.get(DataSourceManager.class);
        m_Log.debug((Object)("Reading DataSource from file: " + fileObject.getName()));
        SAXBuilder sAXBuilder = new SAXBuilder();
        try {
            InputStream inputStream = fileObject.getInputStream();
            Document document = null;
            try {
                document = sAXBuilder.build(inputStream);
            }
            finally {
                FileUtil.close(inputStream);
            }
            assert (document != null);
            IDataSource iDataSource = DataSourceDefinition.load((DataSourceManager)dataSourceManager, (Element)(document = DSUtil.decryptIfNecessary(sAXBuilder, document)).getRootElement());
            if (iDataSource == null) {
                m_Log.error((Object)("Can't load " + fileObject.getName()));
                throw new IOException("Unable to load " + fileObject.getName());
            }
            DSUtil.postprocessLoad(fileObject, iDataSource);
            if (DSUtil.needsClone(iDataSource)) {
                iDataSource = DataSourceDefinition.clone((DataSourceManager)dataSourceManager, (IDataSource)iDataSource);
            }
            return iDataSource;
        }
        catch (Exception exception) {
            m_Log.error((Object)("Can't load " + fileObject.getName() + " : " + String.valueOf(exception)), (Throwable)exception);
            throw new IOException("Unable to load " + fileObject.getName() + " : " + String.valueOf(exception));
        }
    }

    private static Document decryptIfNecessary(SAXBuilder sAXBuilder, Document document) throws IOException, JDOMException {
        Element element = document.getRootElement();
        if (element.getName().equals("encrypted-datasource") && element.getNamespace().equals((Object)Data2Constants.NS_DATASOURCE)) {
            m_Log.info((Object)"loading encrypted datasource");
            String string = element.getAttributeValue("version");
            if (!"1".equals(string)) {
                throw new IOException("Incorrect encryption version: " + string);
            }
            String string2 = element.getText();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(ByteUtil.decodeBase64((String)string2));
            GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            Document document2 = sAXBuilder.build((InputStream)gZIPInputStream);
            gZIPInputStream.close();
            return document2;
        }
        return document;
    }

    private static void postprocessLoad(FileObject fileObject, IDataSource iDataSource) {
        String string = fileObject.getName();
        if (string.endsWith(".ds")) {
            string = string.substring(0, string.length() - 3);
        }
        DSUtil.setName(iDataSource, string);
        DSUtil.setFileObject(iDataSource, fileObject);
    }

    private static boolean needsClone(IDataSource iDataSource) {
        return !(iDataSource instanceof RawDataSource);
    }

    public static void setName(IDataSource iDataSource, String string) {
        if (!iDataSource.getName().equals(string)) {
            Class<?> clazz = iDataSource.getClass();
            try {
                Method method = clazz.getMethod("setName", String.class);
                method.invoke((Object)iDataSource, string);
            }
            catch (Exception exception) {
                m_Log.error((Object)("Unable to set name of " + String.valueOf(iDataSource)), (Throwable)exception);
            }
        }
    }

    public static void setFileObject(IDataSource iDataSource, FileObject fileObject) {
        ICachedFile iCachedFile = (ICachedFile)iDataSource.getAdapter(ICachedFile.class);
        if (iCachedFile != null) {
            iCachedFile.setFileObject(RepositoryConverter.toFO(fileObject));
        }
    }
}

