/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.repertoire;

import com.elixirtech.arch.CustomSysConfig;
import com.elixirtech.arch.DefaultConsoleManager;
import com.elixirtech.arch.DefaultUser;
import com.elixirtech.arch.Designer;
import com.elixirtech.arch.DesignerFrame;
import com.elixirtech.arch.DesignerFrameErrorHandler;
import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.GUIMarker;
import com.elixirtech.arch.IApplication;
import com.elixirtech.arch.IConsoleManager;
import com.elixirtech.arch.IDesigner;
import com.elixirtech.arch.IErrorHandler;
import com.elixirtech.arch.IThrobber;
import com.elixirtech.arch.IUser;
import com.elixirtech.arch.IViewModel;
import com.elixirtech.arch.MultiViewModel;
import com.elixirtech.arch.SystemConfig;
import com.elixirtech.arch.ViewBar;
import com.elixirtech.arch.licence.EmptyLicenceHolder;
import com.elixirtech.arch.licence.ILicence;
import com.elixirtech.arch.licence.ILicenceHolder;
import com.elixirtech.arch.licence.IProduct;
import com.elixirtech.arch.licence.NoLicence;
import com.elixirtech.arch.mime.DefaultMIMEManager;
import com.elixirtech.arch.mime.IMIMEManager;
import com.elixirtech.arch.repository.FileTypeManager;
import com.elixirtech.arch.repository.IFileTypeManager;
import com.elixirtech.arch.repository.IRepositoryActions;
import com.elixirtech.arch.repository.RepositoryActions;
import com.elixirtech.arch.repository.RepositoryExplorer;
import com.elixirtech.arch.repository.StandaloneRepositoryExplorer;
import com.elixirtech.arch.txt.TxtFileType;
import com.elixirtech.arch.worker.WorkerManager;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.datasource.cache2.CacheManager;
import com.elixirtech.data2.datasource.cache2.ICacheManager;
import com.elixirtech.data2.datasource.transform.ITransformWizardFactory;
import com.elixirtech.data2.datasource.transform.TransformUIConfigurator;
import com.elixirtech.data2.function.IFunctionFactory;
import com.elixirtech.data2.function.LocalFunctionFactory;
import com.elixirtech.ensemble.DataSourceFileType;
import com.elixirtech.ensemble.ds.DataAccess;
import com.elixirtech.ensemble.ds.IDataAccess2;
import com.elixirtech.erd.ERDGlobalProperties;
import com.elixirtech.erd.TemplateFileType;
import com.elixirtech.erd.images.ImageGifFileType;
import com.elixirtech.erd.images.ImageJPGFileType;
import com.elixirtech.erd.images.ImagePNGFileType;
import com.elixirtech.erd.reportdesigner.data.DataField;
import com.elixirtech.erd.reportdesigner.data.DataFieldSet;
import com.elixirtech.erd.reportdesigner.dnd.DNDProvider;
import com.elixirtech.erd.reportdesigner.dnd.DataFieldDNDTrigger;
import com.elixirtech.erd.reportdesigner.dnd.ImageDNDTrigger;
import com.elixirtech.erd.reportdesigner.dnd.ReportTemplateDNDTrigger;
import com.elixirtech.erd.reportdesigner.property.ControlSourceRenderer;
import com.elixirtech.erd.reportdesigner.property.FilePathRenderer;
import com.elixirtech.erd.reportdesigner.property.FormatRenderer;
import com.elixirtech.erd.reportdesigner.property.LocaleRenderer;
import com.elixirtech.erd.reportdesigner.property.ScriptRenderer;
import com.elixirtech.erd.reportdesigner.property.StringSyntaxRenderer;
import com.elixirtech.erd.reportdesigner.property.WizardRenderer;
import com.elixirtech.i18n.IUIFactory;
import com.elixirtech.i18n.UIFactory;
import com.elixirtech.js.JavaScriptEngine;
import com.elixirtech.map.MapFileType;
import com.elixirtech.opc.doc.DOCXFileType;
import com.elixirtech.property.IMasterPropertyList;
import com.elixirtech.property.PropertyType;
import com.elixirtech.remote.ConnectionPool;
import com.elixirtech.remote.ISchemaAccess;
import com.elixirtech.remote.LocalSchemaAccess;
import com.elixirtech.remote.MongoConnectionPool;
import com.elixirtech.remote.RemoteRepository;
import com.elixirtech.repertoire.Application;
import com.elixirtech.repertoire.ConfigLoader;
import com.elixirtech.repertoire.Product;
import com.elixirtech.repertoire.RMLEngineRepository;
import com.elixirtech.repertoire.Setup;
import com.elixirtech.repertoire.StandaloneDSM;
import com.elixirtech.repertoire.StandaloneReportAccess;
import com.elixirtech.repertoire.StartupTests;
import com.elixirtech.report2.IPipelineFactory;
import com.elixirtech.report2.IRenderFactory;
import com.elixirtech.report2.IReportAccess;
import com.elixirtech.report2.PipelineFactory;
import com.elixirtech.report2.RenderFactory;
import com.elixirtech.report2.raw.property.IPropertyTypeList;
import com.elixirtech.report2.raw.property.MasterPropertyList;
import com.elixirtech.report2.raw.property.PropertyTypes;
import com.elixirtech.report2.raw.property.UiPropertyTypeList;
import com.elixirtech.report2.ui.type.GlintFileType;
import com.elixirtech.repository.RMLRepository;
import com.elixirtech.repository.Validator;
import com.elixirtech.ui.SwingUtils;
import com.elixirtech.ui.Throbber;
import com.elixirtech.ui.property.IPropertyRenderer;
import com.elixirtech.ui.property.RendererFactory;
import com.elixirtech.util.ClassUtil;
import com.elixirtech.v2.repository.Repository;
import com.typesafe.config.Config;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class Repertoire {
    public Repertoire() {
        assert (SwingUtilities.isEventDispatchThread());
        ElxLoggerJ.getLogger((String)"Repertoire").info((Object)"Repertoire Logging configured");
        SwingUtils.enableNimbus();
        Config config = ConfigLoader.config();
        StartupTests.run(config);
        com.elixirtech.arch.licence.Product product = new com.elixirtech.arch.licence.Product("ElixirRepertoire8-Designer-license.txt", "Elixir Repertoire", 8);
        Elixir.registerInstance(Config.class, (Object)config);
        Elixir.registerInstance(SystemConfig.class, (Object)new CustomSysConfig(config));
        Elixir.register(IDesigner.class, Designer.class);
        Elixir.register(IViewModel.class, MultiViewModel.class);
        Elixir.register(ViewBar.class, ViewBar.class);
        Elixir.register(RepositoryExplorer.class, StandaloneRepositoryExplorer.class);
        Elixir.register(Repository.class, RemoteRepository.class);
        Elixir.register(RMLRepository.class, RMLEngineRepository.class);
        Elixir.register(IRepositoryActions.class, RepositoryActions.class);
        Elixir.register(IUser.class, DefaultUser.class);
        Elixir.register(IThrobber.class, Throbber.class);
        Elixir.register(IMIMEManager.class, DefaultMIMEManager.class);
        Elixir.register(WorkerManager.class, WorkerManager.class);
        Elixir.register(DataSourceManager.class, StandaloneDSM.class);
        Elixir.register(IReportAccess.class, StandaloneReportAccess.class);
        Elixir.register(IPipelineFactory.class, PipelineFactory.class);
        Elixir.register(IFunctionFactory.class, LocalFunctionFactory.class);
        Elixir.register(ICacheManager.class, CacheManager.class);
        Elixir.register(Validator.class);
        Elixir.register(IDataAccess2.class, DataAccess.class);
        Elixir.register(ISchemaAccess.class, LocalSchemaAccess.class);
        Elixir.registerInstance(IProduct.class, (Object)product);
        Elixir.register(ILicenceHolder.class, EmptyLicenceHolder.class);
        Elixir.register(ILicence.class, NoLicence.class);
        Elixir.register(IFileTypeManager.class, FileTypeManager.class);
        Elixir.register(ITransformWizardFactory.class, TransformUIConfigurator.class);
        Setup.init();
        this.registerApplication();
        Elixir.register(GUIMarker.class, GUIMarker.class);
        Elixir.registerInstance(IRenderFactory.class, (Object)new RenderFactory());
        ConnectionPool.prestartPools();
        MongoConnectionPool.prestartPools();
        String string = System.getProperty("elixir.reset.preferences");
        if (string != null) {
            DefaultUser.resetState(((IApplication)Elixir.get(IApplication.class)).getClass());
            DefaultUser.resetState(RepositoryExplorer.class);
        }
        Elixir.register(IUIFactory.class, UIFactory.class);
        Elixir.register(IConsoleManager.class, DefaultConsoleManager.class);
        Elixir.register(IPropertyTypeList.class, UiPropertyTypeList.class);
        Elixir.register(IMasterPropertyList.class, MasterPropertyList.class);
        Elixir.register(ERDGlobalProperties.class, ERDGlobalProperties.class);
        Elixir.register(ElixirFrame.class, DesignerFrame.class);
        Elixir.register(IErrorHandler.class, DesignerFrameErrorHandler.class);
        Elixir.register(JavaScriptEngine.class, JavaScriptEngine.class);
        this.registerFileTypes();
        this.registerTransforms();
        this.initStyles();
        Elixir.get(ERDGlobalProperties.class);
        Elixir.get(IDesigner.class);
    }

    protected void error(String string, String string2) {
        this.licenseError(string, string2);
        System.exit(-1);
    }

    protected void licenseError(String string, String string2) {
        JOptionPane.showMessageDialog(null, string2, string, 0);
    }

    protected void registerApplication() {
        Elixir.registerInstance(Product.class, (Object)this.getProduct());
        Elixir.register(IApplication.class, Application.class);
    }

    protected Product getProduct() {
        return new Product("Elixir Repertoire", 10);
    }

    protected void registerFileTypes() {
        TemplateFileType templateFileType = new TemplateFileType();
        ImageGifFileType imageGifFileType = new ImageGifFileType();
        ImagePNGFileType imagePNGFileType = new ImagePNGFileType();
        ImageJPGFileType imageJPGFileType = new ImageJPGFileType();
        DNDProvider.registerDragAndDrop(new ReportTemplateDNDTrigger(templateFileType.getFlavor()));
        DNDProvider.registerDragAndDrop(new DataFieldDNDTrigger(DataField.DATAFIELD_FLAVOR));
        DNDProvider.registerDragAndDrop(new DataFieldDNDTrigger(DataFieldSet.DATAFIELD_SET_FLAVOR));
        DNDProvider.registerDragAndDrop(new ImageDNDTrigger(ImageGifFileType.FLAVOR));
        DNDProvider.registerDragAndDrop(new ImageDNDTrigger(ImagePNGFileType.FLAVOR));
        DNDProvider.registerDragAndDrop(new ImageDNDTrigger(ImageJPGFileType.FLAVOR));
        RepositoryExplorer repositoryExplorer = (RepositoryExplorer)Elixir.get(RepositoryExplorer.class);
        repositoryExplorer.addFileType(templateFileType);
        repositoryExplorer.addFileType(new TxtFileType());
        repositoryExplorer.addFileType(new DataSourceFileType());
        repositoryExplorer.addFileType(new GlintFileType());
        repositoryExplorer.addFileType(new DOCXFileType());
        repositoryExplorer.addFileType(new MapFileType());
        repositoryExplorer.addFileType(imageGifFileType);
        repositoryExplorer.addFileType(imagePNGFileType);
        repositoryExplorer.addFileType(imageJPGFileType);
    }

    private void registerTransforms() {
        ClassUtil.newInstance("com.elixirtech.data.transform.TransformConfigurator");
        ClassUtil.newInstance("com.elixirtech.data.transform.ui.TransformUIConfigurator");
    }

    public void setArgs(String[] stringArray) {
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!"-maxWorkspace".equals(stringArray[i])) continue;
            bl = true;
        }
        if (bl) {
            IDesigner iDesigner = (IDesigner)Elixir.get(IDesigner.class);
            iDesigner.collapseRepositoryExplorer();
        }
    }

    protected void initStyles() {
        Repertoire.register(PropertyTypes.CONTROL_SOURCE, ControlSourceRenderer.class);
        Repertoire.register(PropertyTypes.LOCALE, LocaleRenderer.class);
        Repertoire.register(PropertyTypes.SCRIPT, ScriptRenderer.class);
        Repertoire.register(PropertyTypes.FILE_PATH, FilePathRenderer.class);
        Repertoire.register(PropertyTypes.WIZARD, WizardRenderer.class);
        Repertoire.register(PropertyTypes.FORMAT, FormatRenderer.class);
        Repertoire.register(PropertyTypes.STRING_SYNTAX, StringSyntaxRenderer.class);
    }

    private static void register(PropertyType propertyType, Class<? extends IPropertyRenderer> clazz) {
        RendererFactory.addRenderer(propertyType, clazz);
    }
}

