/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.physical.viewer;

import com.elixirtech.arch.ElixirJ;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.glint.viewer.IViewerCanvas;
import com.elixirtech.glint.viewer.PrintHandler;
import com.elixirtech.report2.I18N;
import com.elixirtech.util.FileUtil;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;

public class LPTCanvas
extends JEditorPane
implements IViewerCanvas,
PrintHandler {
    public static final char CARRIAGE_RETURN = '\r';
    public static final char LINE_FEED = '\n';
    public static final char FORM_FEED = '\f';
    private List<String> m_Pages = new ArrayList<String>();
    private int m_PageNo = 1;
    private List<ChangeListener> m_Listeners = new ArrayList<ChangeListener>();
    private File m_File;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(LPTCanvas.class);

    public LPTCanvas() {
        this.setFont(new Font("Monospaced", 0, 12));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObject(Object object) {
        Reader reader = null;
        try {
            Object object2;
            if (object instanceof File) {
                this.m_File = (File)object;
                object2 = new FileInputStream(this.m_File);
                reader = new InputStreamReader((InputStream)object2, "UTF-8");
            } else {
                reader = new StringReader(object.toString());
            }
            try {
                int n;
                object2 = new StringBuffer();
                while ((n = reader.read()) >= 0) {
                    if (n == 13) continue;
                    if (n == 10) {
                        ((StringBuffer)object2).append(System.getProperty("line.separator"));
                        continue;
                    }
                    if (n == 12) {
                        this.m_Pages.add(((StringBuffer)object2).toString());
                        object2 = new StringBuffer();
                        continue;
                    }
                    ((StringBuffer)object2).append((char)n);
                }
                if (((StringBuffer)object2).length() > 0) {
                    this.m_Pages.add(((StringBuffer)object2).toString());
                }
            }
            catch (IOException iOException) {
                m_Log.error((Object)("Error reading object: " + String.valueOf(iOException)), (Throwable)iOException);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (IOException iOException) {
            m_Log.error((Object)("Error reading object: " + String.valueOf(iOException)), (Throwable)iOException);
        }
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        this.m_Listeners.add(changeListener);
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        this.m_Listeners.remove(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(File file) throws IOException {
        this.m_File = file;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.m_File);
            this.read(fileInputStream);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void read(InputStream inputStream) throws IOException {
        try {
            int n;
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            StringBuffer stringBuffer = new StringBuffer();
            while ((n = inputStreamReader.read()) >= 0) {
                if (n == 10) {
                    stringBuffer.append(System.getProperty("line.separator"));
                    continue;
                }
                if (n == 12) {
                    this.m_Pages.add(stringBuffer.toString());
                    stringBuffer = new StringBuffer();
                    continue;
                }
                stringBuffer.append((char)n);
            }
            if (stringBuffer.length() > 0) {
                this.m_Pages.add(stringBuffer.toString());
            }
        }
        catch (IOException iOException) {
            m_Log.error((Object)("Error reading input: " + String.valueOf(iOException)), (Throwable)iOException);
        }
    }

    @Override
    public void update() {
        if (!this.m_Pages.isEmpty()) {
            this.setText(this.m_Pages.get(this.m_PageNo - 1));
            this.setCaretPosition(0);
        }
    }

    @Override
    public int getPageCount() {
        return this.m_Pages.size();
    }

    @Override
    public void setPageNo(int n) {
        this.m_PageNo = n;
    }

    @Override
    public int getPageNo() {
        return this.m_PageNo;
    }

    @Override
    public JComponent getCanvasComponent() {
        return this;
    }

    public String getStatus() {
        return "";
    }

    @Override
    public boolean canPrint() {
        return this.m_File != null;
    }

    @Override
    public void doPrint() {
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        DocFlavor.BYTE_ARRAY bYTE_ARRAY = DocFlavor.BYTE_ARRAY.AUTOSENSE;
        try {
            PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(bYTE_ARRAY, null);
            if (printServiceArray.length == 0) {
                ElixirJ.userError(I18N.ERD.getString("LPTCanvas.error-noprinter"));
                return;
            }
            PrintService printService = PrintServiceLookup.lookupDefaultPrintService();
            Container container = this.getParent();
            Point point = new Point(0, 0);
            Dimension dimension = container.getSize();
            SwingUtilities.convertPointToScreen(point, container);
            point.x += dimension.width / 2 - 200;
            point.y += dimension.height / 2 - 200;
            PrintService printService2 = ServiceUI.printDialog(null, point.x, point.y, printServiceArray, printService, bYTE_ARRAY, hashPrintRequestAttributeSet);
            if (printService2 != null) {
                byte[] byArray = FileUtil.loadBytes(this.m_File);
                DocPrintJob docPrintJob = printService2.createPrintJob();
                SimpleDoc simpleDoc = new SimpleDoc(byArray, bYTE_ARRAY, null);
                docPrintJob.print(simpleDoc, hashPrintRequestAttributeSet);
            }
        }
        catch (Exception exception) {
            ElixirJ.error(I18N.ERD.getString("LPTCanvas.error-printtext") + String.valueOf(exception), exception);
        }
    }

    @Override
    public void first() {
        this.m_PageNo = 1;
        this.update();
    }

    @Override
    public boolean previous() {
        if (this.m_PageNo > 1) {
            --this.m_PageNo;
            this.update();
            return true;
        }
        return false;
    }

    @Override
    public boolean next() {
        if (this.m_PageNo < this.m_Pages.size()) {
            ++this.m_PageNo;
            this.update();
            return true;
        }
        return false;
    }

    @Override
    public void last() {
        this.m_PageNo = this.m_Pages.size();
        this.update();
    }

    @Override
    public boolean gotoPage(int n) {
        if (n > 0 && n <= this.m_Pages.size()) {
            this.m_PageNo = n;
            this.update();
            return true;
        }
        return false;
    }
}

