/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.raw;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.ISecurity;
import com.elixirtech.arch.repository.RepositoryAttributes;
import com.elixirtech.arch.repository.RepositoryConverter;
import com.elixirtech.jaxen.jdom.JDOMXPath;
import com.elixirtech.jdom.Attribute;
import com.elixirtech.jdom.Document;
import com.elixirtech.jdom.Element;
import com.elixirtech.jdom.input.SAXBuilder;
import com.elixirtech.report2.raw.Migrator;
import com.elixirtech.report2.raw.RMLSAXOut;
import com.elixirtech.report2.raw.model.DataSource;
import com.elixirtech.report2.raw.model.Metadata;
import com.elixirtech.report2.raw.model.Parameter;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.RawReportSAX;
import com.elixirtech.report2.raw.model.Section;
import com.elixirtech.sax.BasicSAXDelegate;
import com.elixirtech.sax.EncryptedBean;
import com.elixirtech.sax.delegates.EncryptedSAX;
import com.elixirtech.util.FileUtil;
import com.elixirtech.util.base64.Base64Encoder;
import com.elixirtech.v2.XMLWriter;
import com.elixirtech.v2.repository.FileObject;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.SwingUtilities;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ReportLoader {
    public static final String RAW_REPORT = "RawReport";
    public static final int VERSION = 2;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(ReportLoader.class);

    public static RawReport readRML(FileObject fileObject) throws IOException {
        return ReportLoader.readRML(fileObject, true);
    }

    public static RawReport readRML(FileObject fileObject, boolean bl) throws IOException {
        if (bl) {
            RawReport rawReport = (RawReport)RepositoryAttributes.get(fileObject, RAW_REPORT);
            if (rawReport == null || !rawReport.isUpToDate()) {
                rawReport = ReportLoader.doReadRML(fileObject, bl);
            }
            return rawReport;
        }
        return ReportLoader.doReadRML(fileObject, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RawReport doReadRML(final FileObject fileObject, boolean bl) throws IOException {
        m_Log.debug((Object)("readRML(" + fileObject.getName() + ")"));
        try {
            int n;
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            EncryptedSAX encryptedSAX = new EncryptedSAX((BasicSAXDelegate)new RawReportSAX());
            InputStream inputStream = fileObject.getInputStream();
            try {
                sAXParser.parse(inputStream, (DefaultHandler)encryptedSAX);
            }
            finally {
                FileUtil.close(inputStream);
            }
            RawReport rawReport = (RawReport)encryptedSAX.getObject();
            rawReport.setFileObject(RepositoryConverter.toFO(fileObject));
            boolean bl2 = !fileObject.canWrite() || rawReport.getSecurity().isReadOnly();
            rawReport.getSecurity().setReadOnly(bl2);
            rawReport.loaded();
            Metadata metadata = rawReport.getMetadata();
            int n2 = n = metadata == null ? 1 : metadata.getVersion();
            if (n != 2) {
                new Migrator(rawReport, n);
            }
            if (bl) {
                if (Elixir.isHeadless() || SwingUtilities.isEventDispatchThread()) {
                    RepositoryAttributes.set(fileObject, RAW_REPORT, rawReport);
                } else {
                    final RawReport rawReport2 = rawReport;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RepositoryAttributes.set(fileObject, ReportLoader.RAW_REPORT, rawReport2);
                        }
                    });
                }
            }
            return rawReport;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            m_Log.error((Object)("readRML: " + String.valueOf(parserConfigurationException)), (Throwable)parserConfigurationException);
            throw new IOException(parserConfigurationException.toString());
        }
        catch (SAXException sAXException) {
            m_Log.error((Object)("readRML: " + String.valueOf(sAXException)), (Throwable)sAXException);
            throw new IOException(sAXException.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeRML(RawReport rawReport, FileObject fileObject) throws IOException {
        m_Log.debug((Object)("writeRML(" + fileObject.getName() + ")"));
        try (Writer writer = null;){
            Object object;
            Metadata metadata = rawReport.getMetadata();
            if (metadata == null) {
                metadata = new Metadata();
                rawReport.setMetadata(metadata);
            }
            metadata.setVersion(2);
            metadata.setLocation(fileObject.getPath().toString());
            RawReport rawReport2 = null;
            ISecurity iSecurity = (ISecurity)rawReport.getAdapter(ISecurity.class);
            if (iSecurity.isEncrypted()) {
                object = new ByteArrayOutputStream();
                GZIPOutputStream gZIPOutputStream = new GZIPOutputStream((OutputStream)object);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)gZIPOutputStream, Charset.forName("UTF-8"));
                XMLWriter xMLWriter = new XMLWriter(outputStreamWriter);
                RMLSAXOut.process((ContentHandler)xMLWriter, (Object)rawReport, (boolean)true);
                xMLWriter.flush();
                gZIPOutputStream.close();
                rawReport2 = new EncryptedBean(Base64Encoder.encode(((ByteArrayOutputStream)object).toByteArray()));
            } else {
                rawReport2 = rawReport;
            }
            writer = new OutputStreamWriter(fileObject.getOutputStream(), StandardCharsets.UTF_8);
            object = new XMLWriter(writer);
            RMLSAXOut.process((ContentHandler)object, (Object)rawReport2, (boolean)true);
            ((XMLWriter)object).flush();
            RepositoryAttributes.set(fileObject, RAW_REPORT, rawReport);
            rawReport.setDirty(false);
        }
        rawReport.setFileObject(RepositoryConverter.toFO(fileObject));
    }

    public static void writeRML(RawReport rawReport, OutputStream outputStream) throws IOException {
        Object object;
        Closeable closeable;
        Metadata metadata = rawReport.getMetadata();
        if (metadata == null) {
            metadata = new Metadata();
            rawReport.setMetadata(metadata);
        }
        metadata.setVersion(2);
        FileObject fileObject = RepositoryConverter.toFO(rawReport.getFileObject());
        if (fileObject != null) {
            metadata.setLocation(fileObject.getPath().toString());
        }
        RawReport rawReport2 = null;
        ISecurity iSecurity = (ISecurity)rawReport.getAdapter(ISecurity.class);
        if (iSecurity.isEncrypted()) {
            closeable = new ByteArrayOutputStream();
            object = new GZIPOutputStream((OutputStream)closeable);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)object, Charset.forName("UTF-8"));
            XMLWriter xMLWriter = new XMLWriter(outputStreamWriter);
            RMLSAXOut.process((ContentHandler)xMLWriter, (Object)rawReport, (boolean)true);
            xMLWriter.flush();
            ((DeflaterOutputStream)object).close();
            rawReport2 = new EncryptedBean(Base64Encoder.encode(((ByteArrayOutputStream)closeable).toByteArray()));
        } else {
            rawReport2 = rawReport;
        }
        closeable = new OutputStreamWriter(outputStream, Charset.forName("UTF-8"));
        object = new XMLWriter((Writer)closeable);
        RMLSAXOut.process((ContentHandler)object, (Object)rawReport2, (boolean)true);
        ((XMLWriter)object).flush();
    }

    public static void close(RawReport rawReport) {
        FileObject fileObject = RepositoryConverter.toFO(rawReport.getFileObject());
        if (fileObject != null) {
            RepositoryAttributes.set(fileObject, RAW_REPORT, null);
        }
    }

    public static RawReport deepCopy(RawReport rawReport) {
        RawReport rawReport2 = rawReport.deepCopy();
        rawReport2.setFileObject(rawReport.getFileObject());
        rawReport2.loaded();
        return rawReport2;
    }

    public static List<String> getSectionNames(RawReport rawReport) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = rawReport.getSectionIterator();
        while (iterator.hasNext()) {
            arrayList.add(((Section)iterator.next()).getName());
        }
        return arrayList;
    }

    public static List<String> getSectionNames(FileObject fileObject) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        RawReport rawReport = (RawReport)RepositoryAttributes.get(fileObject, RAW_REPORT);
        if (rawReport != null) {
            Iterator iterator = rawReport.getSectionIterator();
            while (iterator.hasNext()) {
                arrayList.add(((Section)iterator.next()).getName());
            }
        } else {
            SAXBuilder sAXBuilder = new SAXBuilder();
            try (InputStream inputStream = null;){
                inputStream = fileObject.getInputStream();
                Document document = sAXBuilder.build(inputStream);
                JDOMXPath jDOMXPath = new JDOMXPath("/rml:report/rml:sections/rml:section/@name");
                jDOMXPath.addNamespace("rml", "http://www.elixirtech.com/ElixirReport/RML");
                for (Attribute attribute : jDOMXPath.selectNodes((Object)document)) {
                    arrayList.add(attribute.getValue());
                }
            }
        }
        return arrayList;
    }

    public static List<String> getDataSourceNames(RawReport rawReport) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = rawReport.getDataSourceIterator();
        while (iterator.hasNext()) {
            arrayList.add(((DataSource)iterator.next()).getName());
        }
        return arrayList;
    }

    public static List<String> getDataSourceNames(FileObject fileObject) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        RawReport rawReport = (RawReport)RepositoryAttributes.get(fileObject, RAW_REPORT);
        if (rawReport != null) {
            Iterator iterator = rawReport.getDataSourceIterator();
            while (iterator.hasNext()) {
                arrayList.add(((DataSource)iterator.next()).getName());
            }
        } else {
            SAXBuilder sAXBuilder = new SAXBuilder();
            try (InputStream inputStream = null;){
                inputStream = fileObject.getInputStream();
                Document document = sAXBuilder.build(inputStream);
                JDOMXPath jDOMXPath = new JDOMXPath("/rml:report/rml:datasources/rml:datasource/@name");
                jDOMXPath.addNamespace("rml", "http://www.elixirtech.com/ElixirReport/RML");
                for (Attribute attribute : jDOMXPath.selectNodes((Object)document)) {
                    arrayList.add(attribute.getValue());
                }
            }
        }
        return arrayList;
    }

    public static List<Parameter> getParameters(FileObject fileObject) throws IOException {
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
        RawReport rawReport = (RawReport)RepositoryAttributes.get(fileObject, RAW_REPORT);
        if (rawReport != null) {
            Iterator iterator = rawReport.getParameterIterator();
            while (iterator.hasNext()) {
                arrayList.add((Parameter)iterator.next());
            }
        } else {
            SAXBuilder sAXBuilder = new SAXBuilder();
            try (InputStream inputStream = null;){
                inputStream = fileObject.getInputStream();
                Document document = sAXBuilder.build(inputStream);
                JDOMXPath jDOMXPath = new JDOMXPath("/rml:report/rml:parameters/rml:param");
                jDOMXPath.addNamespace("rml", "http://www.elixirtech.com/ElixirReport/RML");
                for (Element element : jDOMXPath.selectNodes((Object)document)) {
                    if (!"Yes".equals(element.getAttributeValue("enabled"))) continue;
                    String string = element.getAttributeValue("key");
                    String string2 = element.getText();
                    arrayList.add(new Parameter(string, string2));
                }
            }
        }
        return arrayList;
    }
}

