/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.ui.type;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.ElixirJ;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.IPanelView;
import com.elixirtech.arch.repository.FileType;
import com.elixirtech.glint.Eye;
import com.elixirtech.glint.IEye;
import com.elixirtech.i18n.Bundle;
import com.elixirtech.i18n.I18NUtil;
import com.elixirtech.icons.FileIcons;
import com.elixirtech.report2.ui.type.GlintPanelView;
import com.elixirtech.report2.ui.type.GlintProperties;
import com.elixirtech.v2.repository.FileObject;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class GlintFileType
extends FileType {
    public static final DataFlavor TEMPLATE_FLAVOR = new DataFlavor("application/x-glint", null);
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(GlintFileType.class);

    public GlintFileType() {
        super("Glint File", "glint", FileIcons.GLINT_FILE, TEMPLATE_FLAVOR);
    }

    @Override
    public String getMimeType() {
        return "application/x-glint";
    }

    @Override
    public Action getAddAction(FileObject fileObject) {
        return null;
    }

    @Override
    public Action getPropertiesAction(FileObject fileObject) {
        return new OpenGlintProperties(fileObject);
    }

    @Override
    public Action[] getPopupActions(FileObject fileObject) {
        return new Action[]{new OpenGlintProperties(fileObject)};
    }

    @Override
    public IPanelView createView(FileObject fileObject) {
        try {
            return new GlintPanelView(fileObject);
        }
        catch (IOException iOException) {
            ElixirJ.error(I18NUtil.getString(Bundle.ARCH, "Error.CANT_READ_FILE_X", fileObject.getName()), iOException);
            return null;
        }
    }

    @Override
    public IPanelView createView(Object object) {
        if (object instanceof Eye) {
            return new GlintPanelView((IEye)((Eye)object));
        }
        return null;
    }

    private static class OpenGlintProperties
    extends AbstractAction {
        private FileObject m_FileObject;

        public OpenGlintProperties(FileObject fileObject) {
            super("Open Properties...");
            this.m_FileObject = fileObject;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            m_Log.info((Object)("open properties " + String.valueOf(this.m_FileObject.getPath())));
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            elixirFrame.showWizard(new GlintProperties(this.m_FileObject));
        }
    }
}

