/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.ui.type;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirJ;
import com.elixirtech.arch.IPanelView;
import com.elixirtech.arch.IViewModel;
import com.elixirtech.arch.UINavigatorPath;
import com.elixirtech.glint.IEye;
import com.elixirtech.glint.viewer.GlintCanvas;
import com.elixirtech.icons.FileIcons;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.ui.viewer.ViewerToolBar;
import com.elixirtech.repository.FileAttributeEvent;
import com.elixirtech.repository.FileChangeAdapter;
import com.elixirtech.repository.FileChangeListener;
import com.elixirtech.repository.FileDeletedEvent;
import com.elixirtech.repository.FileEvent;
import com.elixirtech.repository.FileRenameEvent;
import com.elixirtech.v2.repository.FileObject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;

public class GlintPanelView
implements IPanelView {
    private FileObject m_File;
    private JPanel m_Panel;
    private GlintCanvas m_Canvas;
    private ViewerToolBar m_ToolBar;
    private List<PropertyChangeListener> m_Listeners = new ArrayList<PropertyChangeListener>();
    private FileChangeListener m_FCL = new FCL();

    public GlintPanelView(FileObject fileObject) throws IOException {
        this.m_File = fileObject;
        this.m_File.getRepository().addFileChangeListener(this.m_FCL);
        this.m_Canvas = new GlintCanvas();
        this.m_ToolBar = new ViewerToolBar(30);
        this.m_ToolBar.setViewer(this.m_Canvas);
        this.m_Panel = new JPanel(new BorderLayout());
        this.m_Panel.add((Component)this.m_ToolBar, "North");
        this.m_Panel.add((Component)new JScrollPane(this.m_Canvas), "Center");
        try {
            InputStream inputStream = fileObject.getInputStream();
            this.m_ToolBar.open(inputStream);
            inputStream.close();
        }
        catch (Exception exception) {
            ElixirJ.error(I18N.ERD.getString("GlintPanelView.error-load") + fileObject.getName() + " : " + String.valueOf(exception), exception);
            exception.printStackTrace();
        }
    }

    public GlintPanelView(IEye iEye) {
        this.m_Canvas = new GlintCanvas();
        this.m_ToolBar = new ViewerToolBar(30);
        this.m_ToolBar.setViewer(this.m_Canvas);
        this.m_Panel = new JPanel(new BorderLayout());
        this.m_Panel.add((Component)this.m_ToolBar, "North");
        this.m_Panel.add((Component)new JScrollPane(this.m_Canvas), "Center");
        this.m_ToolBar.open(iEye);
    }

    public GlintPanelView(IEye iEye, ViewerToolBar viewerToolBar) {
        this.m_Canvas = new GlintCanvas();
        this.m_ToolBar = viewerToolBar;
        this.m_ToolBar.setViewer(this.m_Canvas);
        this.m_Panel = new JPanel(new BorderLayout());
        this.m_Panel.add((Component)new JScrollPane(this.m_Canvas), "Center");
        this.m_ToolBar.open(iEye);
    }

    public void showUINavigator(UINavigatorPath uINavigatorPath) {
    }

    @Override
    public JComponent getComponent() {
        return this.m_Panel;
    }

    @Override
    public FileObject getFileObject() {
        return this.m_File;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_Listeners.add(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_Listeners.remove(propertyChangeListener);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        IViewModel iViewModel = (IViewModel)Elixir.get(IViewModel.class);
        iViewModel.refreshView();
    }

    @Override
    public boolean canSave() {
        return false;
    }

    @Override
    public boolean canSaveAs() {
        return false;
    }

    @Override
    public void save() throws IOException {
    }

    @Override
    public void saveAs(FileObject fileObject) throws IOException {
    }

    @Override
    public void setCurrent(boolean bl) {
        if (!bl) {
            // empty if block
        }
    }

    @Override
    public String getName() {
        if (this.m_File != null) {
            return this.m_File.getPath().toString();
        }
        return this.m_Canvas.getEye().getName();
    }

    @Override
    public Icon getIcon() {
        return FileIcons.GLINT_FILE;
    }

    public GlintCanvas getCanvas() {
        return this.m_Canvas;
    }

    @Override
    public void dispose() {
        if (this.m_File != null) {
            this.m_File.getRepository().removeFileChangeListener(this.m_FCL);
        }
    }

    protected void firePropertyChanged(String string, Object object, Object object2) {
        Iterator<PropertyChangeListener> iterator = this.m_Listeners.iterator();
        if (iterator.hasNext()) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
            while (iterator.hasNext()) {
                PropertyChangeListener propertyChangeListener = iterator.next();
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
        }
    }

    private class FCL
    extends FileChangeAdapter {
        private FCL() {
        }

        public boolean relevant(FileEvent fileEvent) {
            return fileEvent.getFile().getPathString().equals(GlintPanelView.this.m_File.getPathString());
        }

        @Override
        public void fileDeleted(FileDeletedEvent fileDeletedEvent) {
            if (this.relevant(fileDeletedEvent)) {
                IViewModel iViewModel = (IViewModel)Elixir.get(IViewModel.class);
                iViewModel.removeView(GlintPanelView.this);
            }
        }

        @Override
        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
            if (this.relevant(fileAttributeEvent)) {
                GlintPanelView.this.firePropertyChanged(fileAttributeEvent.getName(), fileAttributeEvent.getOldValue(), fileAttributeEvent.getNewValue());
            }
        }

        @Override
        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            if (this.relevant(fileRenameEvent)) {
                GlintPanelView.this.firePropertyChanged("Filename", fileRenameEvent.getOldPath(), fileRenameEvent.getNewPath());
            }
        }
    }
}

