/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.ui.type;

import com.elixirtech.glint.EyeReader;
import com.elixirtech.i18n.I18NBypass;
import com.elixirtech.report2.I18N;
import com.elixirtech.ui.ImageManager;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.Wizard;
import com.elixirtech.ui.wizard.WizardPage;
import com.elixirtech.util.StrBuffer;
import com.elixirtech.v2.repository.FileObject;
import java.awt.BorderLayout;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

public class GlintProperties
extends Wizard {
    private FileObject m_GlintFile;

    public GlintProperties(FileObject fileObject) {
        super(I18N.ERD.getString("GlintProperties.title"));
        this.m_GlintFile = fileObject;
        this.buildPages();
    }

    protected void buildPages() {
        this.m_Pages.add(new GlintPage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getHTML() throws IOException {
        StrBuffer strBuffer = new StrBuffer();
        strBuffer.append("<html>");
        strBuffer.append("<h3>" + String.valueOf(this.m_GlintFile.getPath()) + "</h3>");
        EyeReader eyeReader = null;
        try (InputStream inputStream = this.m_GlintFile.getInputStream();){
            int n;
            eyeReader = new EyeReader(inputStream);
            strBuffer.append("Name: " + eyeReader.getName() + "<br>");
            strBuffer.append("Width: " + eyeReader.getWidth() + " Height: " + eyeReader.getHeight() + "<br>");
            int n2 = eyeReader.getPageCount();
            if (n2 == 1) {
                strBuffer.append("One Page<br>");
            } else {
                strBuffer.append(n2 + " Pages<br>");
            }
            int n3 = eyeReader.getResourceCount();
            strBuffer.append("<table border=\"1\" width=\"100%\">");
            strBuffer.append("<tr><th>Section</th><th>Size (bytes)</th></tr>");
            for (n = 0; n < n3; ++n) {
                strBuffer.append("<tr><td>Resource " + (n + 1) + "</td><td>" + eyeReader.getResources(n).length + "</td></tr>");
            }
            for (n = 1; n <= n2; ++n) {
                strBuffer.append("<tr><td>Page " + n + "</td><td>" + eyeReader.getPage(n).length + "</td></tr>");
            }
            strBuffer.append("</table>");
            strBuffer.append("</html>");
        }
        return strBuffer.toString();
    }

    private class GlintPage
    extends WizardPage {
        public GlintPage() {
            super("Glint", null);
            this.setTitle("Glint Properties");
            this.setMessage("Review glint file properties");
            this.setIcon(ImageManager.getIconResource("com/elixirtech/report2/ui/type/images/glint-logo.png"));
            this.setWizard(GlintProperties.this);
        }

        @Override
        public void setWizard(IWizard iWizard) {
            super.setWizard(iWizard);
            this.m_Component.setLayout(new BorderLayout());
            this.m_Component.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            String string = "";
            try {
                string = GlintProperties.this.getHTML();
            }
            catch (Exception exception) {
                this.setError(exception.toString());
            }
            JLabel jLabel = I18NBypass.newLabel(string);
            jLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.m_Component.add(new JScrollPane(jLabel));
        }

        @Override
        public boolean isPageComplete() {
            return true;
        }
    }
}

