/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.ui.viewer;

import com.elixirtech.glint.viewer.IViewerCanvas;
import com.elixirtech.report2.ui.viewer.ViewerToolBar;
import com.elixirtech.ui.SwingUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;

public abstract class AbstractMain {
    private JFrame m_Frame;
    private ViewerToolBar m_ToolBar;
    private IViewerCanvas m_Canvas;

    protected void build() {
        this.m_Frame = new JFrame(this.getTitle());
        this.m_Frame.setDefaultCloseOperation(2);
        SwingUtil.setupDropTarget(this.m_Frame, new Drop());
        Container container = this.m_Frame.getContentPane();
        this.m_Canvas = this.getCanvas();
        this.m_ToolBar = this.buildToolBar();
        container.add((Component)this.m_ToolBar, "North");
        container.add((Component)new JScrollPane(this.m_Canvas.getCanvasComponent()), "Center");
        this.m_Frame.pack();
        Dimension dimension = this.m_Frame.getSize();
        if (dimension.width < 400) {
            dimension.width = 600;
        }
        if (dimension.height < 500) {
            dimension.height = 500;
        }
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        if (dimension.width > dimension2.width) {
            dimension.width = dimension2.width;
        }
        if (dimension.height > dimension2.height) {
            dimension.height = dimension2.height;
        }
        this.m_Frame.setSize(dimension);
    }

    public JFrame getFrame() {
        return this.m_Frame;
    }

    public ViewerToolBar getToolBar() {
        return this.m_ToolBar;
    }

    protected ViewerToolBar buildToolBar() {
        ViewerToolBar viewerToolBar = new ViewerToolBar();
        viewerToolBar.setViewer(this.m_Canvas);
        viewerToolBar.setFileFilter(this.getFileFilter());
        return viewerToolBar;
    }

    protected abstract String getTitle();

    protected abstract IViewerCanvas getCanvas();

    protected abstract FileFilter getFileFilter();

    private class Drop
    implements DropTargetListener {
        private Drop() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            try {
                Transferable transferable = dropTargetDropEvent.getTransferable();
                if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    dropTargetDropEvent.acceptDrop(1);
                    List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    AbstractMain.this.m_ToolBar.open((File)list.get(0));
                    dropTargetDropEvent.dropComplete(true);
                    return;
                }
            }
            catch (Exception exception) {
                System.out.println("Drop Error: " + exception.toString());
            }
            dropTargetDropEvent.rejectDrop();
            dropTargetDropEvent.dropComplete(false);
        }
    }
}

