/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.ui.viewer;

import com.elixirtech.glint.viewer.GlintCanvas;
import com.elixirtech.glint.viewer.IViewerCanvas;
import com.elixirtech.report2.ui.viewer.AbstractMain;
import com.elixirtech.report2.ui.viewer.I18N;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;

public class GlintMain
extends AbstractMain {
    private static String TITLE = "GlintViewer";
    private static String FILES = "Glint Files";

    public static void main(String[] stringArray) {
        GlintMain glintMain = new GlintMain();
        JFrame jFrame = glintMain.getFrame();
        jFrame.setDefaultCloseOperation(3);
        if (I18N.VIEWER != null) {
            TITLE = I18N.VIEWER.getString("GlintMain.Title");
            FILES = I18N.VIEWER.getString("GlintMain.Files");
        }
        jFrame.setVisible(true);
    }

    public GlintMain() {
        this.build();
    }

    @Override
    protected String getTitle() {
        return TITLE;
    }

    @Override
    protected IViewerCanvas getCanvas() {
        return new GlintCanvas();
    }

    @Override
    protected FileFilter getFileFilter() {
        return new FileFilter(){

            @Override
            public String getDescription() {
                return FILES;
            }

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.getName().endsWith(".glint");
            }
        };
    }
}

