/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.ui.viewer;

import com.elixirtech.glint.viewer.IViewerCanvas;
import com.elixirtech.glint.viewer.PrintHandler;
import com.elixirtech.glint.viewer.Zoomable;
import com.elixirtech.print.IPrinter;
import com.elixirtech.print.Printable;
import com.elixirtech.print.PrinterUtil;
import com.elixirtech.report2.ui.viewer.I18N;
import com.elixirtech.ui.INavigation;
import com.elixirtech.ui.JNavigationPanel;
import com.elixirtech.ui.images.Icons;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.filechooser.FileFilter;

public class ViewerToolBar
extends JToolBar
implements Serializable,
ActionListener {
    private static final String[] ZOOM_LABELS = new String[]{"50%", "75%", "100%", "150%", "200%", "300%", "400%", "800%", "1000%", "2000%"};
    private static final int[] ZOOM_VALUES = new int[]{50, 75, 100, 150, 200, 300, 400, 800, 1000, 2000};
    public static final int OPEN = 1;
    public static final int PRINT = 2;
    public static final int ZOOM = 4;
    public static final int NAVIGATE = 8;
    public static final int SAVE = 16;
    private IViewerCanvas m_Bean;
    private JComboBox m_Zoom;
    private JButton m_Open;
    private JButton m_Print;
    private JNavigationPanel m_NavPanel;
    private FileFilter m_FileFilter;

    public ViewerToolBar() {
        this(31);
    }

    public ViewerToolBar(int n) {
        this.setFloatable(false);
        this.setRollover(true);
        this.setLayout(new FlowLayout(0));
        String string = "Open";
        String string2 = "Print";
        if (I18N.VIEWER != null) {
            string = I18N.VIEWER.getString("ViewerToolBar.Open");
            string2 = I18N.VIEWER.getString("ViewerToolBar.Print");
        }
        if ((n & 4) != 0) {
            this.m_Zoom = new JComboBox<String>(ZOOM_LABELS);
            this.m_Zoom.setBorder(null);
            this.m_Zoom.setSelectedIndex(2);
            this.m_Zoom.setEnabled(false);
            this.m_Zoom.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ViewerToolBar.this.setZoomPercent(ZOOM_VALUES[ViewerToolBar.this.m_Zoom.getSelectedIndex()]);
                }
            });
            this.add(this.m_Zoom);
        }
        if ((n & 8) != 0) {
            this.m_NavPanel = new JNavigationPanel(new Navigator());
            this.m_NavPanel.setBorder(null);
            this.add(this.m_NavPanel);
        }
        if ((n & 1) != 0) {
            this.m_Open = new JButton(Icons.OPEN);
            this.m_Open.setActionCommand("Open");
            this.m_Open.setToolTipText(string);
            this.m_Open.setEnabled(false);
            this.m_Open.addActionListener(this);
            this.add(this.m_Open);
        }
        if ((n & 2) != 0) {
            this.m_Print = new JButton(Icons.PRINT);
            this.m_Print.setActionCommand("Print");
            this.m_Print.setToolTipText(string2);
            this.m_Print.addActionListener(this);
            this.add(this.m_Print);
        }
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.m_FileFilter = fileFilter;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Open")) {
            int n;
            JFileChooser jFileChooser = new JFileChooser();
            if (this.m_FileFilter != null) {
                jFileChooser.setFileFilter(this.m_FileFilter);
            }
            if ((n = jFileChooser.showOpenDialog(this.getFrame())) == 0) {
                this.open(jFileChooser.getSelectedFile());
            }
        } else if (actionEvent.getActionCommand().equals("Print")) {
            if (this.m_Bean instanceof Printable) {
                IPrinter iPrinter = PrinterUtil.getPrinter();
                iPrinter.print((Printable)((Object)this.m_Bean), new Properties(), this.getFrame());
            } else if (this.m_Bean instanceof PrintHandler) {
                ((PrintHandler)((Object)this.m_Bean)).doPrint();
            }
        }
    }

    public void open(File file) {
        if (this.m_Bean != null) {
            try {
                this.m_Bean.read(file);
                if (this.m_NavPanel != null) {
                    this.m_NavPanel.refresh();
                    this.m_NavPanel.setStatus();
                }
                if (this.m_Bean instanceof Zoomable && this.m_Zoom != null) {
                    ((Zoomable)((Object)this.m_Bean)).setZoomPercent(ZOOM_VALUES[this.m_Zoom.getSelectedIndex()]);
                }
                this.m_Bean.update();
                if (this.m_Print != null) {
                    this.m_Print.setEnabled(this.canPrint());
                }
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this.getFrame(), "Can't load file: " + String.valueOf(iOException));
            }
        }
    }

    public void open(Object object) {
        if (this.m_Bean != null) {
            this.m_Bean.setObject(object);
            if (this.m_NavPanel != null) {
                this.m_NavPanel.refresh();
                this.m_NavPanel.setStatus();
            }
            if (this.m_Bean instanceof Zoomable && this.m_Zoom != null) {
                ((Zoomable)((Object)this.m_Bean)).setZoomPercent(ZOOM_VALUES[this.m_Zoom.getSelectedIndex()]);
            }
            this.m_Bean.update();
            if (this.m_Print != null) {
                this.m_Print.setEnabled(this.canPrint());
            }
        }
    }

    public void open(InputStream inputStream) {
        if (this.m_Bean != null) {
            try {
                this.m_Bean.read(inputStream);
                if (this.m_NavPanel != null) {
                    this.m_NavPanel.refresh();
                    this.m_NavPanel.setStatus();
                }
                if (this.m_Bean instanceof Zoomable && this.m_Zoom != null) {
                    ((Zoomable)((Object)this.m_Bean)).setZoomPercent(ZOOM_VALUES[this.m_Zoom.getSelectedIndex()]);
                }
                this.m_Bean.update();
                if (this.m_Print != null) {
                    this.m_Print.setEnabled(this.canPrint());
                }
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this.getFrame(), "Can't load file: " + String.valueOf(iOException));
            }
        }
    }

    public void setViewer(IViewerCanvas iViewerCanvas) {
        this.m_Bean = iViewerCanvas;
        if (this.m_Zoom != null) {
            this.m_Zoom.setEnabled(this.m_Bean instanceof Zoomable);
        }
        if (this.m_Print != null) {
            this.m_Print.setEnabled(this.canPrint());
        }
        if (this.m_Open != null) {
            this.m_Open.setEnabled(this.m_Bean != null);
        }
        if (this.m_NavPanel != null) {
            this.m_NavPanel.refresh();
            this.m_NavPanel.setStatus();
        }
        if (this.m_Bean instanceof Zoomable && this.m_Zoom != null) {
            ((Zoomable)((Object)this.m_Bean)).setZoomPercent(ZOOM_VALUES[this.m_Zoom.getSelectedIndex()]);
        }
    }

    public IViewerCanvas getViewer() {
        return this.m_Bean;
    }

    private void setZoomPercent(int n) {
        if (this.m_Bean instanceof Zoomable) {
            ((Zoomable)((Object)this.m_Bean)).setZoomPercent(n);
            this.m_Bean.update();
        }
    }

    private boolean canPrint() {
        if (this.m_Bean instanceof Printable) {
            return true;
        }
        if (this.m_Bean instanceof PrintHandler) {
            return ((PrintHandler)((Object)this.m_Bean)).canPrint();
        }
        return false;
    }

    private JFrame getFrame() {
        Container container = this.getParent();
        while (!(container instanceof JFrame)) {
            if ((container = container.getParent()) != null) continue;
            return null;
        }
        return (JFrame)container;
    }

    private class Navigator
    implements INavigation {
        private Navigator() {
        }

        @Override
        public void first() {
            if (ViewerToolBar.this.m_Bean != null) {
                ViewerToolBar.this.m_Bean.first();
            }
        }

        @Override
        public boolean previous() {
            if (ViewerToolBar.this.m_Bean != null) {
                return ViewerToolBar.this.m_Bean.previous();
            }
            return false;
        }

        @Override
        public boolean next() {
            if (ViewerToolBar.this.m_Bean != null) {
                return ViewerToolBar.this.m_Bean.next();
            }
            return false;
        }

        @Override
        public void last() {
            if (ViewerToolBar.this.m_Bean != null) {
                ViewerToolBar.this.m_Bean.last();
            }
        }

        @Override
        public boolean gotoPage(int n) {
            if (ViewerToolBar.this.m_Bean != null) {
                return ViewerToolBar.this.m_Bean.gotoPage(n);
            }
            return false;
        }

        @Override
        public int getPageCount() {
            if (ViewerToolBar.this.m_Bean != null) {
                return ViewerToolBar.this.m_Bean.getPageCount();
            }
            return 0;
        }

        @Override
        public int getPageNo() {
            if (ViewerToolBar.this.m_Bean != null) {
                return ViewerToolBar.this.m_Bean.getPageNo();
            }
            return 0;
        }
    }
}

