/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.repository;

import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.Path;
import com.elixirtech.arch.Path$;
import com.elixirtech.repository.FileUtil;
import com.elixirtech.v2.repository.FileObject;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some$;
import scala.collection.immutable.List;
import scala.package$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;
import sourcecode.FullName$;
import sourcecode.Line$;

public abstract class AbstractFileObject
implements FileObject,
LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(AbstractFileObject.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String toString() {
        return "FileObject: " + this.getName();
    }

    @Override
    public FileObject getParent() {
        return (FileObject)this.getOptParent().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Override
    public String getPathString() {
        return this.getPath().toString();
    }

    @Override
    public OutputStream getOutputStream() {
        return this.getOutputStream(false);
    }

    @Override
    public String getExtension() {
        String name = this.getName();
        int idx = name.lastIndexOf(".");
        if (idx >= 0) {
            return name.substring(idx + 1);
        }
        return "";
    }

    @Override
    public int compareTo(FileObject o) {
        return this.getName().compareTo(o.getName());
    }

    @Override
    public FileObject copy(FileObject targetFolder, String name) throws IOException {
        FileObject fo = targetFolder.getChildJ(name);
        if (this.isData()) {
            if (fo != null && fo.isFolder()) {
                throw new IOException("Existing folder name is identical to new file name");
            }
            if (fo == null) {
                fo = targetFolder.createData(name);
            }
            FileUtil.copy(this, fo);
        } else {
            if (FileUtil.isParentChild(this, targetFolder)) {
                throw new IOException("Cannot copy tree to itself");
            }
            if (fo != null && fo.isData()) {
                throw new IOException("Existing file name is identical to new folder name");
            }
            if (fo == null) {
                fo = targetFolder.createFolder(name);
            }
            List<FileObject> children = this.getChildren();
            int i = 0;
            while (i < children.length()) {
                ((FileObject)children.apply(i)).copy(fo, ((FileObject)children.apply(i)).getName());
                int cfr_ignored_0 = ++i - 1;
            }
        }
        return fo;
    }

    @Override
    public FileObject move(FileObject targetFolder, String name) throws IOException {
        FileObject parent = this.getParent();
        if (parent == null) {
            throw new IOException("Cannot move root");
        }
        if (targetFolder == parent) {
            return this.rename(name);
        }
        FileObject ret = this.copy(targetFolder, name);
        this.delete();
        return ret;
    }

    @Override
    public Option<FileObject> getChild(String name) {
        return this.getChildren().find((Function1 & Serializable)_$1 -> {
            String string = _$1.getName();
            String string2 = name;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
    }

    @Override
    public Option<FileObject> find(String path) {
        None$ none$;
        block9: {
            ObjectRef p = ObjectRef.create((Object)path);
            try {
                String string = (String)p.elem;
                String string2 = "";
                if (!(string != null ? !string.equals(string2) : string2 != null) && this.isFolder()) {
                    return Some$.MODULE$.apply((Object)this);
                }
                String string3 = (String)p.elem;
                String string4 = ".";
                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                    return Some$.MODULE$.apply((Object)this);
                }
                if (((String)p.elem).startsWith("/")) {
                    return this.getRepository().getFile((String)p.elem);
                }
                if (((String)p.elem).startsWith("./")) {
                    p.elem = ((String)p.elem).substring(2);
                }
                String string5 = (String)p.elem;
                String string6 = "..";
                if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                    return Some$.MODULE$.apply((Object)this.getParent());
                }
                if (((String)p.elem).startsWith("../")) {
                    FileObject parent = this.getParent();
                    return parent.find(((String)p.elem).substring(3));
                }
                int idx = ((String)p.elem).indexOf(47);
                if (idx >= 0) {
                    Option<FileObject> optFirst = this.find(((String)p.elem).substring(0, idx));
                    none$ = optFirst.flatMap((Function1 & Serializable)_$2 -> _$2.find(((String)p$1.elem).substring(idx + 1)));
                    break block9;
                }
                none$ = this.getChildren().find((Function1 & Serializable)_$3 -> {
                    String string = _$3.getName();
                    String string2 = (String)p$2.elem;
                    return !(string != null ? !string.equals(string2) : string2 != null);
                });
            }
            catch (Throwable t) {
                this.log().warn(() -> AbstractFileObject.find$$anonfun$3(path, t), Line$.MODULE$.apply(95), FullName$.MODULE$.apply("com.elixirtech.repository.AbstractFileObject.find"));
                none$ = None$.MODULE$;
            }
        }
        return none$;
    }

    @Override
    public Path getPath() {
        return (Path)this.getOptParent().map((Function1 & Serializable)parent -> parent.getPath().$div(this.getName())).getOrElse(AbstractFileObject::getPath$$anonfun$2);
    }

    public FileObject getFileObject(String name) {
        if (this.isData()) {
            throw new UnsupportedOperationException("Not a folder");
        }
        return this.getChildJ(name);
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public boolean equals(Object o) {
        Object object = o;
        if (object instanceof FileObject) {
            FileObject fo = (FileObject)object;
            Path path = this.getPath();
            Path path2 = fo.getPath();
            return !(path != null ? !path.equals(path2) : path2 != null);
        }
        return false;
    }

    @Override
    public String getTags() {
        return "";
    }

    public void ensureDeletable() throws IOException {
        if (!this.canWrite()) {
            throw new IOException("File " + this.getName() + " not deletable");
        }
        List<FileObject> children = this.getChildren();
        children.collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(FileObject x) {
                FileObject fileObject = x;
                if (fileObject instanceof AbstractFileObject) {
                    AbstractFileObject afo = (AbstractFileObject)fileObject;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(FileObject x, Function1 function1) {
                FileObject fileObject = x;
                if (fileObject instanceof AbstractFileObject) {
                    AbstractFileObject afo = (AbstractFileObject)fileObject;
                    return afo;
                }
                return function1.apply((Object)x);
            }
        }).foreach((Function1)(JProcedure1 & Serializable)_$4 -> _$4.ensureDeletable());
    }

    public void recursiveDelete() throws IOException {
        this.getChildren().foreach((Function1)(JProcedure1 & Serializable)_$5 -> _$5.delete());
    }

    private static final Object find$$anonfun$3(String path$1, Throwable t$1) {
        return "Reporting file " + path$1 + " not found due to exception: " + t$1;
    }

    private static final Path getPath$$anonfun$2() {
        return Path$.MODULE$.apply((List)package$.MODULE$.Nil());
    }
}

