/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.repository;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.repository.AbstractFileSystem;
import com.elixirtech.repository.local.LocalFileSystem;
import java.util.HashMap;
import java.util.Map;

public class FileSystemFactory {
    private static Map<String, Class<? extends AbstractFileSystem>> m_Map = new HashMap<String, Class<? extends AbstractFileSystem>>();
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(FileSystemFactory.class);

    public static void register(String string, Class<? extends AbstractFileSystem> clazz) {
        m_Map.put(string, clazz);
    }

    public static AbstractFileSystem newFileSystem(String string) {
        Class<? extends AbstractFileSystem> clazz = m_Map.get(string);
        if (clazz != null) {
            try {
                return clazz.newInstance();
            }
            catch (Exception exception) {
                m_Log.error((Object)("Can't load filesystem type " + string + ": " + String.valueOf(exception)));
            }
        }
        return null;
    }

    static {
        FileSystemFactory.register(LocalFileSystem.TYPE(), LocalFileSystem.class);
    }
}

