/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.repository;

import com.elixirtech.arch.repository.RepositoryAttributes;
import com.elixirtech.i18n.Bundle;
import com.elixirtech.repository.AbstractFileSystem;
import com.elixirtech.util.StrBuffer;
import com.elixirtech.v2.repository.FileObject;
import com.elixirtech.v2.repository.FileSystem;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.MessageFormat;

public class FileUtil {
    public static FileObject getUniqueChild(FileObject fileObject, String string, String string2) throws IOException {
        int n = 0;
        String string3 = string + "." + string2;
        while (fileObject.getChild(string3) != null) {
            string3 = string + ++n + "." + string2;
        }
        return fileObject.createData(string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(FileObject fileObject, FileObject fileObject2) throws IOException {
        InputStream inputStream = fileObject.getInputStream();
        OutputStream outputStream = null;
        try {
            int n;
            byte[] byArray = new byte[8192];
            outputStream = fileObject2.getOutputStream();
            while ((n = inputStream.read(byArray)) > 0) {
                outputStream.write(byArray, 0, n);
            }
        }
        finally {
            inputStream.close();
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    public static void deepCopy(FileObject fileObject, FileObject fileObject2) throws IOException {
        if (FileUtil.isParentChild(fileObject, fileObject2)) {
            throw new IOException("Can't copy a folder to its own child");
        }
        if (fileObject.getParent().equals(fileObject2)) {
            if (fileObject.isData()) {
                String string = FileUtil.getFreeName(fileObject2, fileObject.getName());
                FileObject fileObject3 = fileObject2.createData(string);
                FileUtil.copy(fileObject, fileObject3);
            } else {
                String string = FileUtil.getFreeName(fileObject2, fileObject.getName());
                FileObject fileObject4 = fileObject2.createFolder(string);
                for (FileObject fileObject5 : fileObject.getChildrenJ()) {
                    FileUtil.deepCopy(fileObject5, fileObject4);
                }
            }
        } else if (fileObject.isData()) {
            FileObject fileObject6 = fileObject2.getChildJ(fileObject.getName());
            if (fileObject6 == null) {
                fileObject6 = fileObject2.createData(fileObject.getName());
            }
            if (fileObject6.isFolder()) {
                throw new IOException("Target already exists as a folder");
            }
            FileUtil.copy(fileObject, fileObject6);
        } else {
            FileObject fileObject7 = fileObject2.getChildJ(fileObject.getName());
            if (fileObject7 == null) {
                fileObject7 = fileObject2.createFolder(fileObject.getName());
            }
            if (fileObject7.isData()) {
                throw new IOException("Target already exists as a file");
            }
            for (FileObject fileObject8 : fileObject.getChildrenJ()) {
                FileUtil.deepCopy(fileObject8, fileObject7);
            }
        }
    }

    public static String getFreeName(FileObject fileObject, String string) {
        String string2 = Bundle.ARCH.getString("FileUtil.Copy");
        String string3 = Bundle.ARCH.getString("FileUtil.Copy2");
        String string4 = MessageFormat.format(string2, string);
        if (fileObject.getChild(string4) == null) {
            return string4;
        }
        int n = 2;
        while (fileObject.getChild(string4 = MessageFormat.format(string3, String.valueOf(n), string)) != null) {
            ++n;
        }
        return string4;
    }

    public static boolean isParentChild(FileObject fileObject, FileObject fileObject2) {
        for (FileObject fileObject3 = fileObject2; fileObject3 != null; fileObject3 = fileObject3.getParent()) {
            if (!fileObject.equals(fileObject3)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytes(FileObject fileObject) throws IOException {
        try (InputStream inputStream = null;){
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[8192];
            inputStream = fileObject.getInputStream();
            while ((n = inputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getString(FileObject fileObject) throws IOException {
        try (BufferedReader bufferedReader = null;){
            String string;
            StrBuffer strBuffer = new StrBuffer();
            InputStreamReader inputStreamReader = new InputStreamReader(fileObject.getInputStream());
            bufferedReader = new BufferedReader(inputStreamReader);
            while ((string = bufferedReader.readLine()) != null) {
                strBuffer.append(string).append('\n');
            }
            string = strBuffer.toString();
            return string;
        }
    }

    public static String getLastPath(String string) {
        if (string == null) {
            return "";
        }
        int n = string.lastIndexOf(47);
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    public static void putBytes(FileObject fileObject, byte[] byArray) throws IOException {
        OutputStream outputStream = fileObject.getOutputStream();
        outputStream.write(byArray);
        outputStream.close();
    }

    public static void clearCachedAttributes(FileObject fileObject) {
        String string = fileObject.getExtension();
        if ("ds".equals(string)) {
            RepositoryAttributes.set(fileObject, "DataSource", null);
        } else if ("rml".equals(string)) {
            RepositoryAttributes.set(fileObject, "RawReport", null);
        } else if ("pml".equals(string)) {
            RepositoryAttributes.set(fileObject, "Perspective", null);
        } else if ("pool".equals(string)) {
            RepositoryAttributes.set(fileObject, "ConnectionPool", null);
        } else if ("job".equals(string)) {
            RepositoryAttributes.set(fileObject, "Job", null);
        } else if ("trigger".equals(string)) {
            RepositoryAttributes.set(fileObject, "Trigger", null);
        }
    }

    public static boolean isReadOnly(FileSystem fileSystem) {
        if (fileSystem instanceof AbstractFileSystem) {
            return ((AbstractFileSystem)fileSystem).isReadOnly();
        }
        return false;
    }

    public static String getType(FileSystem fileSystem) {
        if (fileSystem instanceof AbstractFileSystem) {
            return ((AbstractFileSystem)fileSystem).getType();
        }
        return "";
    }

    public static void refresh(FileSystem fileSystem) {
        if (fileSystem instanceof AbstractFileSystem) {
            ((AbstractFileSystem)fileSystem).refresh();
        }
    }

    public static boolean hasACL(FileSystem fileSystem) {
        if (fileSystem instanceof AbstractFileSystem) {
            return ((AbstractFileSystem)fileSystem).hasACL();
        }
        return true;
    }
}

