/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.repository;

import com.elixirtech.arch.Elixir;
import com.elixirtech.repository.IValidator;
import com.elixirtech.v2.repository.FileObject;
import com.elixirtech.v2.repository.FileSystem;
import com.elixirtech.v2.repository.Repository;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Validator {
    private final Map<String, IValidator> m_Map = new HashMap<String, IValidator>();

    public void register(String string, IValidator iValidator) {
        this.m_Map.put(string, iValidator);
    }

    public List<IValidator.Issue> validate() {
        ListCollector listCollector = new ListCollector();
        this.validate(listCollector);
        return listCollector.issues;
    }

    public void validate(IValidator.IssueCollector issueCollector) {
        Repository repository = (Repository)Elixir.get(Repository.class);
        for (FileSystem fileSystem : repository.getFileSystemsJ()) {
            this.validate(issueCollector, fileSystem.getRoot());
        }
    }

    public void validate(IValidator.IssueCollector issueCollector, FileObject fileObject) {
        if (fileObject.isFolder()) {
            for (FileObject fileObject2 : fileObject.getChildrenJ()) {
                this.validate(issueCollector, fileObject2);
            }
        } else {
            IValidator iValidator = this.m_Map.get(fileObject.getExtension());
            if (iValidator != null) {
                iValidator.validate(fileObject, issueCollector);
            }
        }
    }

    public static class ListCollector
    implements IValidator.IssueCollector {
        public List<IValidator.Issue> issues = new ArrayList<IValidator.Issue>();

        @Override
        public void add(IValidator.Issue issue) {
            this.issues.add(issue);
        }
    }
}

