/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.repository.acl;

import com.elixirtech.repository.acl.AccessType;
import com.elixirtech.repository.acl.UserType;
import com.elixirtech.util.StrBuffer;

public abstract class AccessControlList
implements Cloneable {
    public abstract int getOwner();

    public abstract int getGroup();

    public abstract int getAccessControl();

    public boolean canAccess(long l, UserType userType, AccessType accessType) {
        switch (accessType) {
            case Read: {
                return this.canRead(l, userType);
            }
            case Write: {
                return this.canWrite(l, userType);
            }
        }
        return false;
    }

    public boolean getAccess(UserType userType, AccessType accessType) {
        return accessType.isValid(userType.unshift(this.getAccessControl()));
    }

    public boolean canRead(long l, UserType userType) {
        if (!this.isUser(l, userType)) {
            return false;
        }
        return AccessType.Read.isValid(userType.unshift(this.getAccessControl()));
    }

    public boolean canWrite(long l, UserType userType) {
        if (!this.isUser(l, userType)) {
            return false;
        }
        return AccessType.Write.isValid(userType.unshift(this.getAccessControl()));
    }

    private boolean isUser(long l, UserType userType) {
        switch (userType) {
            case Owner: {
                return l == (long)this.getOwner();
            }
            case Group: {
                return l == (long)this.getGroup();
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        AccessControlList accessControlList = (AccessControlList)object;
        if (accessControlList.getAccessControl() != this.getAccessControl()) {
            return false;
        }
        if (accessControlList.getOwner() != this.getOwner()) {
            return false;
        }
        return accessControlList.getGroup() == this.getGroup();
    }

    private Boolean canReadAsBoolean(long l, UserType userType) {
        return this.canRead(l, userType);
    }

    private Boolean canWriteAsBoolean(long l, UserType userType) {
        return this.canWrite(l, userType);
    }

    public String toString() {
        long l = this.getOwner();
        long l2 = this.getGroup();
        StrBuffer strBuffer = new StrBuffer("owner=");
        strBuffer.append(l).append(", access:").append(this.canReadAsBoolean(l, UserType.Owner)).append(", ").append(this.canWriteAsBoolean(l, UserType.Owner)).append(" group=").append(l2).append(", access:").append(this.canReadAsBoolean(l2, UserType.Group)).append(", ").append(this.canWriteAsBoolean(l2, UserType.Group)).append(" other").append(", access:").append(this.canReadAsBoolean(0L, UserType.Others)).append(", ").append(this.canWriteAsBoolean(0L, UserType.Others));
        return strBuffer.toString();
    }
}

