/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.repository.acl;

import com.elixirtech.repository.acl.AccessControlList;
import com.elixirtech.repository.acl.AccessType;
import com.elixirtech.repository.acl.UserType;
import java.util.EnumSet;

public class DefaultAccessControlList
extends AccessControlList {
    private int m_Owner;
    private int m_Group;
    private int m_AccessControl;

    public DefaultAccessControlList() {
    }

    public DefaultAccessControlList(int n, int n2, int n3) {
        this.m_Owner = n;
        this.m_Group = n2;
        this.m_AccessControl = n3;
    }

    public DefaultAccessControlList(AccessControlList accessControlList) {
        this.m_Owner = accessControlList.getOwner();
        this.m_Group = accessControlList.getGroup();
        this.m_AccessControl = accessControlList.getAccessControl();
    }

    @Override
    public int getOwner() {
        return this.m_Owner;
    }

    public void setOwner(int n) {
        this.m_Owner = n;
    }

    @Override
    public int getGroup() {
        return this.m_Group;
    }

    public void setGroup(int n) {
        this.m_Group = n;
    }

    public void setUserID(UserType userType, int n) {
        if (UserType.Owner == userType) {
            this.setOwner(n);
        } else if (UserType.Group == userType) {
            this.setGroup(n);
        }
    }

    @Override
    public int getAccessControl() {
        return this.m_AccessControl;
    }

    public void setAccessControl(int n) {
        this.m_AccessControl = n;
    }

    public void setAccessControl(UserType userType, EnumSet<AccessType> enumSet) {
        this.setRead(userType, enumSet.contains((Object)AccessType.Read));
        this.setWrite(userType, enumSet.contains((Object)AccessType.Write));
    }

    public void setRead(UserType userType, boolean bl) {
        int n = userType.shift(AccessType.Read.value());
        this.m_AccessControl = bl ? this.m_AccessControl | n : this.m_AccessControl & ~n;
    }

    public void setWrite(UserType userType, boolean bl) {
        int n = userType.shift(AccessType.Write.value());
        this.m_AccessControl = bl ? this.m_AccessControl | n : this.m_AccessControl & ~n;
    }

    public Object clone() {
        DefaultAccessControlList defaultAccessControlList = new DefaultAccessControlList();
        defaultAccessControlList.m_Owner = this.m_Owner;
        defaultAccessControlList.m_Group = this.m_Group;
        defaultAccessControlList.m_AccessControl = this.m_AccessControl;
        return defaultAccessControlList;
    }
}

