/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.repository.local;

import com.elixirtech.arch.Path;
import com.elixirtech.i18n.Bundle;
import com.elixirtech.i18n.I18NUtil;
import com.elixirtech.repository.AbstractFileObject;
import com.elixirtech.repository.FCLSupport$;
import com.elixirtech.repository.FileDeletedEvent;
import com.elixirtech.repository.FileEvent;
import com.elixirtech.repository.FileRenameEvent;
import com.elixirtech.repository.IEventDispatcher;
import com.elixirtech.repository.local.LocalFileObject$;
import com.elixirtech.repository.local.LocalFileSystem;
import com.elixirtech.repository.local.SafeOutputStream;
import com.elixirtech.repository.local.SafeOutputStream$;
import com.elixirtech.v2.repository.FileObject;
import com.elixirtech.v2.repository.FileSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Vector;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.LazyBoolean;
import scala.runtime.function.JProcedure1;

public class LocalFileObject
extends AbstractFileObject {
    private final LocalFileSystem fs;
    private long m_LastKnownModified;
    private Option m_OptParent;
    private File m_File;
    private List m_Children;
    private String m_Name;
    private HashMap m_Attributes;
    private Option optEventDispatcher;

    public static String ATTR_LENGTH() {
        return LocalFileObject$.MODULE$.ATTR_LENGTH();
    }

    public LocalFileObject(LocalFileSystem fs, Option<LocalFileObject> initOptParent, File localFile) {
        this.fs = fs;
        this.m_LastKnownModified = 0L;
        this.m_OptParent = initOptParent;
        this.m_File = localFile;
        this.m_Children = package$.MODULE$.Nil();
        this.m_Name = localFile.getName();
        this.m_Attributes = new HashMap();
        this.optEventDispatcher = Some$.MODULE$.apply((Object)fs);
        this.refresh();
    }

    public LocalFileSystem fs() {
        return this.fs;
    }

    public long m_LastKnownModified() {
        return this.m_LastKnownModified;
    }

    public void m_LastKnownModified_$eq(long x$1) {
        this.m_LastKnownModified = x$1;
    }

    public Option<LocalFileObject> m_OptParent() {
        return this.m_OptParent;
    }

    public void m_OptParent_$eq(Option<LocalFileObject> x$1) {
        this.m_OptParent = x$1;
    }

    public File m_File() {
        return this.m_File;
    }

    public void m_File_$eq(File x$1) {
        this.m_File = x$1;
    }

    public List<LocalFileObject> m_Children() {
        return this.m_Children;
    }

    public void m_Children_$eq(List<LocalFileObject> x$1) {
        this.m_Children = x$1;
    }

    public String m_Name() {
        return this.m_Name;
    }

    public void m_Name_$eq(String x$1) {
        this.m_Name = x$1;
    }

    public HashMap<String, Object> m_Attributes() {
        return this.m_Attributes;
    }

    public void m_Attributes_$eq(HashMap<String, Object> x$1) {
        this.m_Attributes = x$1;
    }

    public Option<IEventDispatcher> optEventDispatcher() {
        return this.optEventDispatcher;
    }

    public void optEventDispatcher_$eq(Option<IEventDispatcher> x$1) {
        this.optEventDispatcher = x$1;
    }

    @Override
    public FileSystem getFileSystem() {
        return this.fs();
    }

    @Override
    public Option<FileObject> getOptParent() {
        return this.m_OptParent();
    }

    public File getLocalFile() {
        return this.m_File();
    }

    public boolean isRoot() {
        return this.m_OptParent().isEmpty();
    }

    @Override
    public String getName() {
        if (this.isRoot()) {
            return "";
        }
        return this.m_Name();
    }

    @Override
    public FileObject rename(String name) {
        Option<LocalFileObject> option = this.m_OptParent();
        if (None$.MODULE$.equals(option)) {
            throw new IOException(Bundle.ARCH.getString("LocalFileObject.CANNOT_MOVE_ROOT"));
        }
        if (option instanceof Some) {
            LocalFileObject parent = (LocalFileObject)((Some)option).value();
            Path oldPath = this.getPath();
            File newFile = new File(this.m_File().getParentFile(), name);
            if (this.m_File().renameTo(newFile)) {
                File oldFile = this.m_File();
                this.m_File_$eq(newFile);
                this.m_Name_$eq(name);
                this.m_LastKnownModified_$eq(this.m_File().lastModified());
                Path newPath = this.getPath();
                parent.sortChildren();
                if (this.isFolder()) {
                    String oldFileName = oldFile.getAbsolutePath();
                    String newFileName = newFile.getAbsolutePath();
                    this.m_Children().foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.parentRenamed(oldFileName, newFileName));
                }
                this.optEventDispatcher().foreach((Function1)(JProcedure1 & Serializable)dispatcher -> {
                    FileRenameEvent ev = new FileRenameEvent(this, oldPath.toString(), newPath.toString());
                    dispatcher.dispatch(ev, FCLSupport$.MODULE$.FILE_RENAMED());
                });
                return this;
            }
            throw new IOException(Bundle.ARCH.getString("LocalFileObject.RENAME_FAILED"));
        }
        throw new MatchError(option);
    }

    @Override
    public boolean isFolder() {
        return this.m_File().isDirectory();
    }

    @Override
    public boolean isData() {
        return this.m_File().isFile();
    }

    @Override
    public long lastModified() {
        return this.m_File().lastModified();
    }

    @Override
    public void delete() {
        Option<LocalFileObject> option = this.m_OptParent();
        if (None$.MODULE$.equals(option)) {
            throw new IOException(Bundle.ARCH.getString("LocalFileObject.CANNOT_DELETE_ROOT"));
        }
        if (option instanceof Some) {
            LocalFileObject parent = (LocalFileObject)((Some)option).value();
            this.ensureDeletable();
            File backup = SafeOutputStream$.MODULE$.getBackup(this.m_File());
            File dummy = SafeOutputStream$.MODULE$.getDummy(this.m_File());
            boolean ok = true;
            if (backup.exists()) {
                ok = backup.renameTo(dummy);
            }
            if (ok) {
                ok = this.m_File().renameTo(backup);
            }
            if (ok) {
                dummy.delete();
            }
            Option<IEventDispatcher> ed = this.optEventDispatcher();
            this.optEventDispatcher_$eq((Option<IEventDispatcher>)None$.MODULE$);
            int idx = parent.removeChild(this);
            if (idx >= 0) {
                ed.foreach((Function1)(JProcedure1 & Serializable)dispatcher -> {
                    FileDeletedEvent ev = new FileDeletedEvent(this, parent, idx);
                    dispatcher.dispatch(ev, FCLSupport$.MODULE$.FILE_DELETED());
                });
                return;
            }
            return;
        }
        throw new MatchError(option);
    }

    @Override
    public InputStream getInputStream() {
        if (this.isFolder()) {
            String msg = I18NUtil.getString(Bundle.ARCH, "LocalFileObject.FOLDER_HAS_NO_INPUT_STREAM", this.getPath());
            throw new FileNotFoundException(msg);
        }
        return new FileInputStream(this.m_File());
    }

    @Override
    public OutputStream getOutputStream(boolean append) {
        if (append) {
            return new Appender(this, this.m_File());
        }
        return new Outputter(this, this.m_File());
    }

    @Override
    public List<FileObject> getChildren() {
        return this.m_Children();
    }

    @Override
    public FileObject createFolder(String name) {
        if (this.isData()) {
            throw new UnsupportedOperationException(Bundle.ARCH.getString("LocalFileObject.NOT_A_FOLDER"));
        }
        if (!this.canWrite()) {
            throw new IOException(Bundle.ARCH.getString("LocalFileObject.FOLDER_CANNOT_BE_WRITTEN"));
        }
        File folder = new File(this.m_File(), name);
        if (folder.exists()) {
            throw new IOException(Bundle.ARCH.getString("LocalFileObject.FOLDER_ALREADY_EXISTS"));
        }
        if (!folder.mkdirs()) {
            throw new IOException(Bundle.ARCH.getString("LocalFileObject.FOLDER_NAME_OR_ACCESS_RIGHTS_ERROR"));
        }
        LocalFileObject fo = this.fs().newLocalFileObject((Option<LocalFileObject>)Some$.MODULE$.apply((Object)this), folder);
        this.addChild(fo);
        this.optEventDispatcher().foreach((Function1)(JProcedure1 & Serializable)dispatcher -> {
            FileEvent ev = new FileEvent(fo);
            dispatcher.dispatch(ev, FCLSupport$.MODULE$.FOLDER_CREATED());
        });
        return fo;
    }

    @Override
    public FileObject createData(String name) {
        if (this.isData()) {
            throw new UnsupportedOperationException(Bundle.ARCH.getString("LocalFileObject.NOT_A_FOLDER"));
        }
        if (!this.canWrite()) {
            throw new IOException(Bundle.ARCH.getString("LocalFileObject.FILE_CANNOT_BE_WRITTEN"));
        }
        File file = new File(this.m_File(), name);
        if (file.exists()) {
            throw new IOException(I18NUtil.getString(Bundle.ARCH, "LocalFileObject.FILE_ALREADY_EXISTS", file.getAbsolutePath()));
        }
        if (!file.createNewFile()) {
            throw new IOException(Bundle.ARCH.getString("LocalFileObject.FILE_NAME_OR_ACCESS_RIGHTS_ERROR"));
        }
        LocalFileObject fo = this.fs().newLocalFileObject((Option<LocalFileObject>)Some$.MODULE$.apply((Object)this), file);
        this.addChild(fo);
        this.optEventDispatcher().foreach((Function1)(JProcedure1 & Serializable)dispatcher -> {
            FileEvent ev = new FileEvent(fo);
            dispatcher.dispatch(ev, FCLSupport$.MODULE$.DATA_CREATED());
        });
        return fo;
    }

    @Override
    public boolean canWrite() {
        LazyBoolean lazyBoolean = new LazyBoolean();
        if (!this.m_File().exists()) {
            return true;
        }
        if (this.isData() && !this.parentCanWrite$1(lazyBoolean)) {
            return false;
        }
        return this.m_File().canWrite();
    }

    @Override
    public boolean canRead() {
        return this.m_File().canRead();
    }

    @Override
    public FileObject refresh() {
        Map oldChildren = this.m_Children().map((Function1 & Serializable)c -> {
            File file = (File)Predef$.MODULE$.ArrowAssoc((Object)c.m_File());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)file, c);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Vector files = (Vector)Predef$.MODULE$.wrapRefArray((Object[])Option$.MODULE$.apply((Object)this.m_File().listFiles()).getOrElse(LocalFileObject::$anonfun$2)).toVector().filterNot((Function1 & Serializable)f -> this.isReserved((File)f));
        ListBuffer children = new ListBuffer();
        files.foreach((Function1)(JProcedure1 & Serializable)f -> {
            Option option = oldChildren.get(f);
            if (option instanceof Some) {
                LocalFileObject old = (LocalFileObject)((Some)option).value();
                LocalFileObject fo = null;
                if (f.isDirectory() || old.m_LastKnownModified() == f.lastModified()) {
                    old.refresh();
                    fo = old;
                } else {
                    fo = this.fs().newLocalFileObject((Option<LocalFileObject>)Some$.MODULE$.apply((Object)this), (File)f);
                }
                if (fo.canRead()) {
                    children.$plus$eq((Object)fo);
                    return;
                }
                return;
            }
            if (None$.MODULE$.equals(option)) {
                LocalFileObject fo = this.fs().newLocalFileObject((Option<LocalFileObject>)Some$.MODULE$.apply((Object)this), (File)f);
                if (fo.canRead()) {
                    children.$plus$eq((Object)fo);
                    return;
                }
                return;
            }
            throw new MatchError((Object)option);
        });
        this.m_Children_$eq((List<LocalFileObject>)children.toList());
        this.sortChildren();
        return this;
    }

    public boolean isReserved(File f) {
        String name = f.getName();
        return name.startsWith(".") || name.endsWith(".bak") || name.endsWith(".sos");
    }

    @Override
    public long getLength() {
        return this.m_File().length();
    }

    public void refresh(File f) {
    }

    public void compact() {
    }

    public int removeChild(LocalFileObject obj) {
        int idx = this.m_Children().indexOf((Object)obj);
        if (idx >= 0) {
            this.m_Children_$eq((List<LocalFileObject>)((List)this.m_Children().patch(idx, (IterableOnce)package$.MODULE$.Nil(), 1)));
        }
        return idx;
    }

    private void addChild(LocalFileObject fo) {
        this.m_Children_$eq((List<LocalFileObject>)((List)this.m_Children().$colon$colon((Object)fo).sortBy((Function1 & Serializable)_$3 -> _$3.m_Name(), (Ordering)Ordering.String$.MODULE$)));
    }

    public void parentRenamed(String oldFileName, String newFileName) {
        Object myName = this.m_File().getAbsolutePath();
        if (!((String)myName).startsWith(oldFileName)) {
            throw new IOException(Bundle.ARCH.getString("LocalFileObject.CANNOT_UPDATE_CHILDREN"));
        }
        myName = newFileName + ((String)myName).substring(oldFileName.length());
        this.m_File_$eq(new File((String)myName));
        if (this.isFolder()) {
            this.m_Children().foreach((Function1)(JProcedure1 & Serializable)_$4 -> _$4.parentRenamed(oldFileName, newFileName));
            return;
        }
    }

    public void sortChildren() {
        this.m_Children_$eq((List<LocalFileObject>)((List)this.m_Children().sortBy((Function1 & Serializable)_$5 -> _$5.getName(), (Ordering)Ordering.String$.MODULE$)));
    }

    private final boolean parentCanWrite$lzyINIT1$1(LazyBoolean parentCanWrite$lzy1$1) {
        boolean bl;
        LazyBoolean lazyBoolean = parentCanWrite$lzy1$1;
        synchronized (lazyBoolean) {
            bl = parentCanWrite$lzy1$1.initialized() ? parentCanWrite$lzy1$1.value() : parentCanWrite$lzy1$1.initialize(this.m_OptParent().exists((Function1 & Serializable)_$2 -> _$2.canWrite()));
        }
        return bl;
    }

    private final boolean parentCanWrite$1(LazyBoolean parentCanWrite$lzy1$2) {
        if (parentCanWrite$lzy1$2.initialized()) {
            return parentCanWrite$lzy1$2.value();
        }
        return this.parentCanWrite$lzyINIT1$1(parentCanWrite$lzy1$2);
    }

    private static final File[] $anonfun$2() {
        return (File[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class));
    }

    public class Appender
    extends OutputStream {
        private final File f;
        private final FileOutputStream m_Out;
        private final /* synthetic */ LocalFileObject $outer;

        public Appender(LocalFileObject $outer, File f) {
            this.f = f;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.m_Out = new FileOutputStream(f, true);
        }

        public File f() {
            return this.f;
        }

        public FileOutputStream m_Out() {
            return this.m_Out;
        }

        @Override
        public void write(int i) {
            this.m_Out().write(i);
        }

        @Override
        public void write(byte[] b) {
            this.m_Out().write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) {
            this.m_Out().write(b, off, len);
        }

        @Override
        public void close() {
            this.m_Out().close();
            this.$outer.m_LastKnownModified_$eq(this.$outer.m_File().lastModified());
            this.$outer.optEventDispatcher().foreach((Function1)(JProcedure1 & Serializable)dispatcher -> {
                FileEvent ev = new FileEvent(this.$outer);
                dispatcher.dispatch(ev, FCLSupport$.MODULE$.FILE_CHANGED());
            });
        }

        public final /* synthetic */ LocalFileObject com$elixirtech$repository$local$LocalFileObject$Appender$$$outer() {
            return this.$outer;
        }
    }

    public class Outputter
    extends SafeOutputStream {
        private final File f;
        private final /* synthetic */ LocalFileObject $outer;

        public Outputter(LocalFileObject $outer, File f) {
            this.f = f;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super(f);
        }

        public File f() {
            return this.f;
        }

        @Override
        public void close() {
            super.close();
            this.$outer.m_LastKnownModified_$eq(this.m_File().lastModified());
            if (!this.m_HasError()) {
                this.$outer.optEventDispatcher().foreach((Function1)(JProcedure1 & Serializable)dispatcher -> {
                    FileEvent ev = new FileEvent(this.$outer);
                    dispatcher.dispatch(ev, FCLSupport$.MODULE$.FILE_CHANGED());
                });
                return;
            }
        }

        public final /* synthetic */ LocalFileObject com$elixirtech$repository$local$LocalFileObject$Outputter$$$outer() {
            return this.$outer;
        }
    }
}

