/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.repository.local;

import com.elixirtech.arch.Path;
import com.elixirtech.arch.Path$;
import com.elixirtech.repository.AbstractFileSystem;
import com.elixirtech.repository.FCLSupport;
import com.elixirtech.repository.local.LocalFileObject;
import com.elixirtech.repository.local.LocalFileSystem$;
import com.elixirtech.repository.local.LocalRepository;
import com.elixirtech.v2.repository.FileObject;
import com.elixirtech.v2.repository.Repository;
import java.io.File;
import scala.None$;
import scala.Option;
import scala.collection.immutable.List;
import scala.package$;
import sourcecode.FullName$;
import sourcecode.Line$;

public class LocalFileSystem
extends AbstractFileSystem {
    private final LocalRepository repository;
    private final File rootFile;
    private final LocalFileObject rootFO;

    public static String TYPE() {
        return LocalFileSystem$.MODULE$.TYPE();
    }

    public LocalFileSystem(LocalRepository repository, File rootFile) {
        this.repository = repository;
        this.rootFile = rootFile;
        if (!rootFile.exists() || !rootFile.isDirectory()) {
            this.log().error(() -> LocalFileSystem.$init$$$anonfun$1(rootFile), Line$.MODULE$.apply(14), FullName$.MODULE$.apply("com.elixirtech.repository.local.LocalFileSystem"));
        }
        this.rootFO = this.newLocalFileObject((Option<LocalFileObject>)None$.MODULE$, rootFile);
    }

    @Override
    public LocalFileObject rootFO() {
        return this.rootFO;
    }

    @Override
    public Repository getRepository() {
        return this.repository;
    }

    @Override
    public FCLSupport fclSupport() {
        return this.repository.fclSupport();
    }

    public File getRootFile() {
        return this.rootFile;
    }

    @Override
    public Path getPath() {
        return Path$.MODULE$.apply((List)package$.MODULE$.Nil());
    }

    @Override
    public String getType() {
        return LocalFileSystem$.MODULE$.TYPE();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public void refresh(File f) {
        this.rootFO().refresh(f);
    }

    public void compact() {
        this.rootFO().compact();
    }

    public String getLocalPath(FileObject fo) {
        LocalFileObject lfo = (LocalFileObject)fo;
        return lfo.getLocalFile().getAbsolutePath();
    }

    public LocalFileObject newLocalFileObject(Option<LocalFileObject> parent, File file) {
        return new LocalFileObject(this, parent, file);
    }

    private static final Object $init$$$anonfun$1(File rootFile$1) {
        return "Root directory does not exist: " + rootFile$1.getAbsolutePath();
    }
}

