/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.repository.tree;

import com.elixirtech.repository.ExtraTodo;
import com.elixirtech.repository.TreeNode;
import com.elixirtech.repository.TreeNodeFilter;
import com.elixirtech.repository.tree.HideBackupFilter;
import com.elixirtech.repository.tree.ITreeModel;
import com.elixirtech.ui.IPresentation;
import com.elixirtech.ui.tree.TreeModelEx;
import com.elixirtech.util.collections.WeakList;
import com.elixirtech.v2.repository.FileSystem;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;

public class FileSystemTreeModel
implements TreeModelEx,
ITreeModel {
    private FileSystem m_FileSystem;
    private IPresentation m_Presentation;
    private WeakList<TreeModelListener> m_Listeners = new WeakList();
    private TreeNodeFilter m_Filter = new HideBackupFilter();

    public FileSystemTreeModel(FileSystem fileSystem, IPresentation iPresentation) {
        this.m_FileSystem = fileSystem;
        this.m_Presentation = iPresentation;
    }

    @Override
    public void setFilter(TreeNodeFilter treeNodeFilter) {
        this.m_Filter = treeNodeFilter;
    }

    @Override
    public TreeNodeFilter getFilter() {
        return this.m_Filter;
    }

    @Override
    public Icon getIcon(Object object) {
        return this.m_Presentation.getIcon(object);
    }

    @Override
    public String getLabel(Object object) {
        return this.m_Presentation.getLabel(object);
    }

    @Override
    public void setLabel(Object object, String string) {
    }

    @Override
    public JPopupMenu getPopupMenu(Object object) {
        return null;
    }

    @Override
    public void doDoubleClick(Object object) {
    }

    @Override
    public Object getRoot() {
        return ExtraTodo.getFileSystemTreeNode(this.m_FileSystem);
    }

    @Override
    public TreePath getTreePath(TreeNode treeNode) {
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        for (TreeNode treeNode2 = treeNode; treeNode2 != null; treeNode2 = treeNode2.getParent()) {
            arrayList.add(0, treeNode2);
        }
        Object[] objectArray = new Object[arrayList.size()];
        arrayList.toArray(objectArray);
        return new TreePath(objectArray);
    }

    @Override
    public int getChildCount(Object object) {
        return this.getChildren((TreeNode)object).size();
    }

    @Override
    public boolean isLeaf(Object object) {
        return ((TreeNode)object).isLeaf();
    }

    @Override
    public Object getChild(Object object, int n) {
        return this.getChildren((TreeNode)object).get(n);
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        return this.getChildren((TreeNode)object).indexOf(object2);
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.m_Listeners.add(treeModelListener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.m_Listeners.remove(treeModelListener);
    }

    @Override
    public void dispose() {
    }

    protected List<TreeNode> getChildren(TreeNode treeNode) {
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        int n = treeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            TreeNode treeNode2 = treeNode.getChild(i);
            if (!this.accept(treeNode2)) continue;
            arrayList.add(treeNode2);
        }
        return arrayList;
    }

    protected boolean accept(TreeNode treeNode) {
        return this.m_Filter.accept(treeNode);
    }
}

