/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.repository.tree;

import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.Path;
import com.elixirtech.repository.ExtraTodo$;
import com.elixirtech.repository.FileChangeListener;
import com.elixirtech.repository.TreeNode;
import com.elixirtech.repository.TreeNodeFilter;
import com.elixirtech.repository.tree.HideBackupFilter$;
import com.elixirtech.repository.tree.ITreeModel;
import com.elixirtech.repository.tree.RepositoryTreeModel$;
import com.elixirtech.repository.tree.RepositoryTreeModel$Children$;
import com.elixirtech.repository.tree.RepositoryTreeModelFCL;
import com.elixirtech.ui.IPresentation;
import com.elixirtech.ui.SwingEventThreadProxy;
import com.elixirtech.ui.tree.TreeModelEx;
import com.elixirtech.v2.repository.Repository;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class RepositoryTreeModel
implements TreeModelEx,
ITreeModel,
LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(RepositoryTreeModel.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final String m_Name;
    private final Repository r;
    private final IPresentation m_Presentation;
    private final ListBuffer<TreeModelListener> m_Listeners;
    private final FileChangeListener m_FCL;
    private TreeNodeFilter m_Filter;
    private final HashMap<Path, Children> cachedChildren;
    private final Repository m_Repository;

    public static int CacheLimit() {
        return RepositoryTreeModel$.MODULE$.CacheLimit();
    }

    public RepositoryTreeModel(String m_Name, Repository r, IPresentation m_Presentation) {
        this.m_Name = m_Name;
        this.r = r;
        this.m_Presentation = m_Presentation;
        this.m_Listeners = new ListBuffer();
        this.m_FCL = SwingEventThreadProxy.newInstance(FileChangeListener.class, new RepositoryTreeModelFCL(this));
        this.m_Filter = HideBackupFilter$.MODULE$;
        this.cachedChildren = new HashMap();
        this.m_Repository = r;
        this.m_Repository().addFileChangeListener(this.m_FCL);
        this.assertSwingThread();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String m_Name() {
        return this.m_Name;
    }

    public Repository r() {
        return this.r;
    }

    public IPresentation m_Presentation() {
        return this.m_Presentation;
    }

    public Repository m_Repository() {
        return this.m_Repository;
    }

    @Override
    public void setFilter(TreeNodeFilter filter) {
        this.m_Filter = filter;
    }

    @Override
    public TreeNodeFilter getFilter() {
        return this.m_Filter;
    }

    @Override
    public Icon getIcon(Object o) {
        this.assertSwingThread();
        return this.m_Presentation().getIcon(o);
    }

    @Override
    public String getLabel(Object o) {
        this.assertSwingThread();
        return this.m_Presentation().getLabel(o);
    }

    @Override
    public void setLabel(Object o, String s) {
    }

    @Override
    public JPopupMenu getPopupMenu(Object o) {
        return null;
    }

    public void refresh() {
        TreeNode root = (TreeNode)this.getRoot();
        this.fireStructureChangedEvent(this.getTreePath(root));
    }

    @Override
    public void doDoubleClick(Object o) {
        this.assertSwingThread();
    }

    @Override
    public Object getRoot() {
        this.assertSwingThread();
        return ExtraTodo$.MODULE$.getRootTreeNode(this.m_Repository());
    }

    @Override
    public TreePath getTreePath(TreeNode node) {
        this.assertSwingThread();
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.buildPathList(node).toArray(ClassTag$.MODULE$.apply(Object.class)));
        return new TreePath((Object[])ArrayOps$.MODULE$.reverse$extension(object));
    }

    public List<TreeNode> buildPathList(TreeNode node2) {
        Option option = Option$.MODULE$.apply((Object)node2);
        if (option instanceof Some) {
            TreeNode n = (TreeNode)((Some)option).value();
            return ((List)Option$.MODULE$.apply((Object)node2.getParent()).map((Function1 & Serializable)node -> this.buildPathList((TreeNode)node)).getOrElse(RepositoryTreeModel::buildPathList$$anonfun$2)).$colon$colon((Object)n);
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Nil();
        }
        throw new MatchError((Object)option);
    }

    @Override
    public int getChildCount(Object parent) {
        this.assertSwingThread();
        Object object = parent;
        if (object instanceof TreeNode) {
            TreeNode tn = (TreeNode)object;
            return this.getChildren(tn).size();
        }
        return 0;
    }

    @Override
    public boolean isLeaf(Object node) {
        this.assertSwingThread();
        Object object = node;
        if (object instanceof TreeNode) {
            TreeNode tn = (TreeNode)object;
            return tn.isLeaf();
        }
        return true;
    }

    @Override
    public Object getChild(Object parent, int index) {
        this.assertSwingThread();
        Object object = parent;
        if (object instanceof TreeNode) {
            TreeNode tn = (TreeNode)object;
            return (TreeNode)((Option)this.getChildren(tn).lift().apply((Object)BoxesRunTime.boxToInteger((int)index))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        return null;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        this.assertSwingThread();
        Object object = parent;
        if (object instanceof TreeNode) {
            TreeNode tn = (TreeNode)object;
            return this.getChildren(tn).indexOf(child);
        }
        return -1;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.m_Listeners.$plus$eq((Object)l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.m_Listeners.$minus$eq((Object)l);
    }

    public List<TreeNode> getChildren(TreeNode parent) {
        Children children;
        this.assertSwingThread();
        long now = System.currentTimeMillis();
        Option option = this.cachedChildren.get((Object)parent.path());
        if (option instanceof Some && (children = (Children)((Some)option).value()).ts() > now - (long)RepositoryTreeModel$.MODULE$.CacheLimit()) {
            return children.nodes();
        }
        List ret = parent.getChildren().filter((Function1 & Serializable)node -> this.accept((TreeNode)node));
        this.cachedChildren.put((Object)parent.path(), (Object)RepositoryTreeModel$Children$.MODULE$.apply(now, (List<TreeNode>)ret));
        return ret;
    }

    public boolean accept(TreeNode node) {
        return this.m_Filter.accept(node);
    }

    public void fireInsertedEvent(TreePath tp, int[] cidx, Object[] children) {
        this.assertSwingThread();
        TreeModelEvent ev = new TreeModelEvent((Object)this, tp, cidx, children);
        this.fireInsertedEvent(ev);
    }

    public void fireRemovedEvent(TreePath tp, int[] cidx, Object[] children) {
        this.assertSwingThread();
        TreeModelEvent ev = new TreeModelEvent((Object)this, tp, cidx, children);
        this.fireRemovedEvent(ev);
    }

    public void fireChangedEvent(TreePath tp, int[] cidx, Object[] children) {
        this.assertSwingThread();
        TreeModelEvent ev = new TreeModelEvent((Object)this, tp, cidx, children);
        this.fireChangedEvent(ev);
    }

    public void fireInsertedEvent(TreePath tp) {
        this.assertSwingThread();
        TreeModelEvent ev = new TreeModelEvent((Object)this, tp);
        this.fireInsertedEvent(ev);
    }

    public void fireRemovedEvent(TreePath tp) {
        this.assertSwingThread();
        TreeModelEvent ev = new TreeModelEvent((Object)this, tp);
        this.fireRemovedEvent(ev);
    }

    public void fireChangedEvent(TreePath tp) {
        this.assertSwingThread();
        TreeModelEvent ev = new TreeModelEvent((Object)this, tp);
        this.fireChangedEvent(ev);
    }

    public void fireStructureChangedEvent(TreePath tp) {
        this.assertSwingThread();
        TreeModelEvent ev = new TreeModelEvent((Object)this, tp);
        this.fireStructureChangedEvent(ev);
    }

    @Override
    public void dispose() {
        this.assertSwingThread();
        this.clearCache();
        this.m_Repository().removeFileChangeListener(this.m_FCL);
    }

    public String toString() {
        return "RepositoryTreeModel: " + this.m_Name();
    }

    private void fireInsertedEvent(TreeModelEvent event) {
        this.assertSwingThread();
        this.clearCache();
        this.m_Listeners.foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.treeNodesInserted(event));
    }

    private void fireRemovedEvent(TreeModelEvent event) {
        this.assertSwingThread();
        this.clearCache();
        this.m_Listeners.foreach((Function1)(JProcedure1 & Serializable)_$2 -> _$2.treeNodesRemoved(event));
    }

    private void fireChangedEvent(TreeModelEvent event) {
        this.assertSwingThread();
        this.clearCache();
        this.m_Listeners.foreach((Function1)(JProcedure1 & Serializable)_$3 -> _$3.treeNodesChanged(event));
    }

    private void fireStructureChangedEvent(TreeModelEvent event) {
        this.assertSwingThread();
        this.clearCache();
        this.m_Listeners.foreach((Function1)(JProcedure1 & Serializable)_$4 -> _$4.treeStructureChanged(event));
    }

    public int normalizeIndex(TreeNode parent, int idx) {
        IntRef pos = IntRef.create((int)0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), idx).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            if (this.accept(parent.getChild(i))) {
                ++pos$1.elem;
                return;
            }
        });
        return pos.elem;
    }

    public void clearCache(Path path) {
        this.cachedChildren.remove((Object)path);
    }

    public void clearCache() {
        this.cachedChildren.clear();
    }

    public void assertSwingThread() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError((Object)"Not Swing Thread");
        }
    }

    public void dump() {
        this.dump(ExtraTodo$.MODULE$.getRootTreeNode(this.m_Repository()), "");
    }

    public void dump(TreeNode n, String indent) {
        Predef$.MODULE$.println((Object)(indent + n.getName() + " with " + n.getChildCount() + " children"));
        n.getChildren().foreach((Function1)(JProcedure1 & Serializable)c -> this.dump((TreeNode)c, indent + "--"));
    }

    private static final List buildPathList$$anonfun$2() {
        return package$.MODULE$.Nil();
    }

    public static final class Children
    implements Product,
    Serializable {
        private final long ts;
        private final List nodes;

        public static Children apply(long l, List<TreeNode> list) {
            return RepositoryTreeModel$Children$.MODULE$.apply(l, list);
        }

        public static Children fromProduct(Product product) {
            return RepositoryTreeModel$Children$.MODULE$.fromProduct(product);
        }

        public static Children unapply(Children children) {
            return RepositoryTreeModel$Children$.MODULE$.unapply(children);
        }

        public Children(long ts, List<TreeNode> nodes) {
            this.ts = ts;
            this.nodes = nodes;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.ts()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.nodes()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Children)) return false;
            Children children = (Children)object;
            if (this.ts() != children.ts()) return false;
            List<TreeNode> list = this.nodes();
            List<TreeNode> list2 = children.nodes();
            if (list != null) {
                if (!list.equals(list2)) return false;
                return true;
            }
            if (list2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Children;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Children";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return BoxesRunTime.boxToLong((long)this._1());
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "ts";
            }
            if (1 == n2) {
                return "nodes";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public long ts() {
            return this.ts;
        }

        public List<TreeNode> nodes() {
            return this.nodes;
        }

        public Children copy(long ts, List<TreeNode> nodes) {
            return new Children(ts, nodes);
        }

        public long copy$default$1() {
            return this.ts();
        }

        public List<TreeNode> copy$default$2() {
            return this.nodes();
        }

        public long _1() {
            return this.ts();
        }

        public List<TreeNode> _2() {
            return this.nodes();
        }
    }
}

