/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.tree;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class TreeDropTarget
extends DropTarget {
    protected JTree m_Tree;
    private Rectangle m_LastRowBounds;
    private Point m_MostRecentLocation;
    private int m_MostRecentInsert;
    private static final int INSERT_MARGIN = 4;
    public static final int INSERT_ABOVE = 1;
    public static final int INSERT_BELOW = 2;
    public static final int INSERT_AT = 3;
    private static final int AUTOSCROLL_INSET = 20;

    public TreeDropTarget(JTree jTree) {
        this.m_Tree = jTree;
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        Point point = dropTargetDragEvent.getLocation();
        this.updateDragMark(point);
        this.autoscroll(point);
    }

    public void dragExit(DropTargetDragEvent dropTargetDragEvent) {
        this.m_Tree.repaint();
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        this.m_Tree.repaint();
    }

    private void autoscroll(Point point) {
        Rectangle rectangle = this.m_Tree.getVisibleRect();
        Rectangle rectangle2 = new Rectangle(rectangle.x + 20, rectangle.y + 20, rectangle.width - 40, rectangle.height - 40);
        if (!rectangle2.contains(point)) {
            Rectangle rectangle3 = new Rectangle(point.x - 20, point.y - 20, 40, 40);
            this.m_Tree.scrollRectToVisible(rectangle3);
        }
    }

    public void updateDragMark(Point point) {
        this.m_MostRecentLocation = point;
        int n = this.m_Tree.getRowForPath(this.m_Tree.getClosestPathForLocation(point.x, point.y));
        TreePath treePath = this.m_Tree.getPathForRow(n);
        if (treePath != null) {
            Rectangle rectangle = this.m_Tree.getPathBounds(treePath);
            this.m_MostRecentInsert = this.getInsert(rectangle, point.y);
            if (this.m_MostRecentInsert == 1) {
                this.paintTopInsertMarker(point);
            } else if (this.m_MostRecentInsert == 2) {
                this.paintBottomInsertMarker(point);
            } else {
                this.markNode(point);
            }
        }
    }

    public Point getMostRecentDragLocation() {
        return this.m_MostRecentLocation;
    }

    public int getMostRecentInsert() {
        return this.m_MostRecentInsert;
    }

    private void markNode(Point point) {
        TreePath treePath = this.m_Tree.getClosestPathForLocation(point.x, point.y);
        if (treePath != null) {
            if (this.m_LastRowBounds != null) {
                this.m_Tree.paintImmediately(this.m_LastRowBounds);
            }
            this.m_Tree.setSelectionPath(treePath);
            this.m_Tree.expandPath(treePath);
        }
    }

    private void paintTopInsertMarker(Point point) {
        this.m_Tree.clearSelection();
        int n = this.m_Tree.getRowForPath(this.m_Tree.getClosestPathForLocation(point.x, point.y));
        TreePath treePath = this.m_Tree.getPathForRow(n);
        if (treePath != null) {
            Rectangle rectangle = this.m_Tree.getPathBounds(treePath);
            if (this.m_LastRowBounds != null) {
                this.m_Tree.paintImmediately(this.m_LastRowBounds);
            }
            if (rectangle != null) {
                Graphics graphics = this.m_Tree.getGraphics();
                graphics.setColor(Color.black);
                int n2 = rectangle.y;
                graphics.drawLine(rectangle.x, n2, rectangle.x + rectangle.width - 1, n2);
                graphics.dispose();
            }
            this.m_LastRowBounds = rectangle;
        }
    }

    private void paintBottomInsertMarker(Point point) {
        this.m_Tree.clearSelection();
        int n = this.m_Tree.getRowForPath(this.m_Tree.getClosestPathForLocation(point.x, point.y));
        TreePath treePath = this.m_Tree.getPathForRow(n);
        if (treePath != null) {
            Rectangle rectangle = this.m_Tree.getPathBounds(treePath);
            if (this.m_LastRowBounds != null) {
                this.m_Tree.paintImmediately(this.m_LastRowBounds);
            }
            if (rectangle != null) {
                Graphics graphics = this.m_Tree.getGraphics();
                graphics.setColor(Color.black);
                int n2 = rectangle.y + rectangle.height - 1;
                graphics.drawLine(rectangle.x, n2, rectangle.x + rectangle.width - 1, n2);
                graphics.dispose();
            }
            this.m_LastRowBounds = rectangle;
        }
    }

    private int getInsert(Rectangle rectangle, int n) {
        if (n <= rectangle.y + 4) {
            return 1;
        }
        if (n >= rectangle.y + rectangle.height - 4) {
            return 2;
        }
        return 3;
    }
}

