/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.i18n.Bundle;
import com.elixirtech.ui.table.ElxTableModel;
import com.elixirtech.util.collections.BeanMap;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BeanTableModel
extends ElxTableModel {
    private static final String[] COLUMNS = new String[]{"TableModel.Name", "TableModel.Value"};
    private BeanMap m_BeanMap = new BeanMap();
    private List<String> m_Names = new ArrayList<String>();

    public BeanTableModel() {
        super(Bundle.ARCH, COLUMNS);
    }

    public void setBean(Object object) {
        BeanMap beanMap = this.m_BeanMap;
        this.m_BeanMap = new BeanMap(object);
        this.m_BeanMap.putAllWriteable(beanMap);
        this.m_Names.clear();
        this.m_Names.addAll(this.m_BeanMap.keySet());
        this.m_Names.remove("class");
        Collections.sort(this.m_Names);
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.m_Names.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        String string = this.m_Names.get(n);
        if (n2 == 0) {
            return string;
        }
        Object object = this.m_BeanMap.get(string);
        Method method = this.m_BeanMap.getWriteMethod(string);
        if (method == null) {
            object = String.valueOf(object) + " " + Bundle.ARCH.getString("BeanTableModel.READ_ONLY");
        }
        return object;
    }

    public boolean isWritable(String string) {
        return this.m_BeanMap.getWriteMethod(string) != null;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (n2 == 1) {
            String string = this.m_Names.get(n);
            Method method = this.m_BeanMap.getWriteMethod(string);
            return method != null;
        }
        return false;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        String string = this.m_Names.get(n);
        try {
            this.m_BeanMap.put(string, object);
        }
        catch (Throwable throwable) {
            ElxLoggerJ.getLogger(BeanTableModel.class).error((Object)("Can't set value: " + string + " = " + String.valueOf(object)));
        }
    }

    public Map<Object, Object> getMap() {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        hashMap.putAll(this.m_BeanMap);
        hashMap.remove("class");
        return hashMap;
    }

    public BeanMap getBeanMap() {
        return this.m_BeanMap;
    }
}

