/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;

public class ClipboardUtil {
    private static Owner m_Owner = new Owner();
    private static final DataFlavor[] FLAVORS = new DataFlavor[]{DataFlavor.stringFlavor};

    public static void setText(String string) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = ClipboardUtil.getTransferable(string);
        clipboard.setContents(transferable, m_Owner);
    }

    public static String getText() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(null);
        try {
            return (String)transferable.getTransferData(FLAVORS[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected static Transferable getTransferable(String string) {
        return new StringSelection(string);
    }

    private static class Owner
    implements ClipboardOwner {
        private Owner() {
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        }
    }
}

