/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui;

import com.elixirtech.ui.StandardColor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;

public class ColorView
extends JComponent {
    private String m_ColorName;
    private Color m_Color;

    public ColorView(String string) {
        this.m_ColorName = string;
        this.m_Color = StandardColor.lookup(this.m_ColorName, (Color)null);
    }

    public ColorView(Color color) {
        this.m_Color = color;
    }

    public void setColor(String string) {
        this.m_ColorName = string;
        this.m_Color = StandardColor.lookup(this.m_ColorName, (Color)null);
    }

    public void setColor(Color color) {
        this.m_Color = color;
        this.repaint();
    }

    public String getColorName() {
        if (this.m_ColorName != null) {
            return this.m_ColorName;
        }
        return StandardColor.getColorName(this.m_Color);
    }

    public Color getColor() {
        return this.m_Color;
    }

    @Override
    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (dimension.width > 0 && dimension.height > 0) {
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            graphics.setColor(Color.gray);
            int n = dimension.height / 2;
            boolean bl = true;
            for (int i = 0; i < dimension.width; i += n) {
                if (bl) {
                    graphics.fillRect(i, 0, n, n);
                } else {
                    graphics.fillRect(i, n, n, n + 1);
                }
                bl = !bl;
            }
            if (this.m_Color != null) {
                graphics.setColor(this.m_Color);
                graphics.fillRect(0, 0, dimension.width, dimension.height);
            }
        }
    }
}

