/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui;

import com.elixirtech.i18n.Bundle;
import com.elixirtech.icons.StandardIcons;
import com.elixirtech.ui.ColorView;
import com.elixirtech.ui.JColorChooserEx;
import com.elixirtech.ui.StandardColor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ColorViewPanel
extends JPanel
implements ActionListener {
    private final JButton m_Button;
    private final ColorView m_View;
    private String m_Title;
    private List<ChangeListener> m_Listeners = new ArrayList<ChangeListener>();

    public ColorViewPanel() {
        this((String)null);
    }

    public ColorViewPanel(String string) {
        if (string != null) {
            this.setName(string);
        }
        this.setLayout(new BorderLayout());
        this.m_Button = new JButton(StandardIcons.COLOR);
        this.m_Button.setMargin(new Insets(0, 0, 0, 0));
        this.m_Button.addActionListener(this);
        this.m_View = new ColorView(StandardColor.TRANSPARENT);
        this.add((Component)this.m_Button, "West");
        this.add((Component)this.m_View, "Center");
        this.m_Title = Bundle.ARCH.getString("ColorViewPanel.DialogTitle");
    }

    public void setDialogTitle(String string) {
        this.m_Title = string;
    }

    public void setColor(Color color) {
        this.m_View.setColor(color);
    }

    public Color getColor() {
        return this.m_View.getColor();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Color color = JColorChooserEx.showDialog(this, this.m_Title, this.m_View.getColor());
        if (color != null) {
            this.m_View.setColor(color);
            ChangeEvent changeEvent = new ChangeEvent(this);
            for (ChangeListener changeListener : this.m_Listeners) {
                changeListener.stateChanged(changeEvent);
            }
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.m_Button.setEnabled(bl);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.m_Listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.m_Listeners.remove(changeListener);
    }
}

