/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui;

import com.elixirtech.i18n.Bundle;
import com.elixirtech.icons.StandardIcons;
import com.elixirtech.ui.SwingFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class EditableList
extends JPanel
implements ListSelectionListener,
ActionListener {
    public static final String PLUS = "plus";
    public static final String EDIT = "edit";
    public static final String MINUS = "minus";
    public static final String COPY = "copy";
    public static final String PASTE = "paste";
    protected JList m_List;
    protected Box m_Items;
    protected List<ActionListener> m_Listeners = new ArrayList<ActionListener>();
    protected JButton m_Plus = this.button("plus", "Add", StandardIcons.NEW);
    protected JButton m_Edit = this.button("edit", "Edit", StandardIcons.PROPERTIES);
    protected JButton m_Minus = this.button("minus", "Delete", StandardIcons.DELETE);
    protected JButton m_Copy = this.button("copy", "Copy", StandardIcons.COPY);
    protected JButton m_Paste = this.button("paste", "Paste", StandardIcons.PASTE);
    protected int m_MinRows;
    protected boolean m_CanAdd = true;

    public EditableList(ListModel listModel) {
        this(listModel, true);
    }

    public EditableList(ListModel listModel, boolean bl) {
        this.setLayout(new BorderLayout());
        this.m_Items = new Box(1);
        this.initButtons(bl);
        this.m_List = SwingFactory.newList(listModel);
        this.m_List.addMouseListener(new ML());
        ListSelectionModel listSelectionModel = this.m_List.getSelectionModel();
        listSelectionModel.addListSelectionListener(this);
        this.add((Component)this.m_Items, "West");
        JScrollPane jScrollPane = new JScrollPane(this.m_List);
        this.add((Component)jScrollPane, "Center");
        KeyStroke keyStroke = KeyStroke.getKeyStroke(127, 0);
        NamedAction namedAction = new NamedAction(MINUS);
        this.m_List.getActionMap().put(namedAction, namedAction);
        this.m_List.getInputMap(0).put(keyStroke, namedAction);
        if (bl) {
            KeyStroke keyStroke2 = KeyStroke.getKeyStroke(67, 2);
            NamedAction namedAction2 = new NamedAction(COPY);
            this.m_List.getActionMap().put(namedAction2, namedAction2);
            this.m_List.getInputMap(0).put(keyStroke2, namedAction2);
            KeyStroke keyStroke3 = KeyStroke.getKeyStroke(86, 2);
            NamedAction namedAction3 = new NamedAction(PASTE);
            this.m_List.getActionMap().put(namedAction3, namedAction3);
            this.m_List.getInputMap(0).put(keyStroke3, namedAction3);
        }
        this.checkEnabled();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.m_List.setEnabled(bl);
        this.checkEnabled();
    }

    public void setModel(ListModel listModel) {
        this.m_List.setModel(listModel);
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        ListSelectionModel listSelectionModel = this.m_List.getSelectionModel();
        listSelectionModel.addListSelectionListener(listSelectionListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        ListSelectionModel listSelectionModel = this.m_List.getSelectionModel();
        listSelectionModel.removeListSelectionListener(listSelectionListener);
    }

    public JList getList() {
        return this.m_List;
    }

    public void setSingleSelectionMode() {
        ListSelectionModel listSelectionModel = this.m_List.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
    }

    public void setMinRows(int n) {
        this.m_MinRows = n;
    }

    public int getRowCount() {
        return this.m_List.getModel().getSize();
    }

    public void addActionListener(ActionListener actionListener) {
        this.m_Listeners.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.m_Listeners.remove(actionListener);
    }

    protected JButton button(String string, String string2, Icon icon) {
        JButton jButton = new JButton(null, icon);
        jButton.setActionCommand(string);
        jButton.setToolTipText(Bundle.ARCH.getString(string2));
        jButton.addActionListener(this);
        return jButton;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.height = this.m_Items.getPreferredSize().height;
        Border border = this.getBorder();
        if (border != null) {
            Insets insets = border.getBorderInsets(this);
            dimension.height += insets.top + insets.bottom;
        }
        return dimension;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public int getSelectedRow() {
        return this.m_List.getSelectedIndex();
    }

    public int[] getSelectedRows() {
        return this.m_List.getSelectedIndices();
    }

    public void select(int n) {
        this.m_List.getSelectionModel().setSelectionInterval(n, n);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.checkEnabled();
    }

    public void setCellRenderer(ListCellRenderer listCellRenderer) {
        this.m_List.setCellRenderer(listCellRenderer);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        for (ActionListener actionListener : this.m_Listeners) {
            actionListener.actionPerformed(actionEvent);
        }
    }

    public void checkEnabled() {
        boolean bl = this.isEnabled();
        int n = this.m_List.getSelectedIndex();
        this.m_Plus.setEnabled(bl);
        this.m_Edit.setEnabled(bl && n >= 0 && this.m_List.getSelectedIndices().length == 1);
        this.m_Edit.setToolTipText(bl ? Bundle.ARCH.getString("Edit") : Bundle.ARCH.getString("View"));
        this.m_Minus.setEnabled(bl && n >= 0 && this.m_List.getModel().getSize() > this.m_MinRows);
        this.m_Copy.setEnabled(bl && n >= 0);
        this.m_Paste.setEnabled(bl);
    }

    protected void initButtons(boolean bl) {
        this.m_Items.add(this.m_Plus);
        this.m_Items.add(this.m_Edit);
        this.m_Items.add(this.m_Minus);
        if (bl) {
            this.m_Items.add(this.m_Copy);
            this.m_Items.add(this.m_Paste);
        }
    }

    protected void edit() {
        ActionEvent actionEvent = new ActionEvent(this, 1001, EDIT);
        this.actionPerformed(actionEvent);
    }

    protected void view() {
        ActionEvent actionEvent = new ActionEvent(this, 1001, "view");
        this.actionPerformed(actionEvent);
    }

    private class ML
    extends MouseAdapter {
        private ML() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Point point;
            int n;
            if (mouseEvent.getClickCount() == 2 && (n = EditableList.this.m_List.locationToIndex(point = mouseEvent.getPoint())) >= 0) {
                EditableList.this.m_List.setSelectedIndex(n);
                if (EditableList.this.isEnabled()) {
                    EditableList.this.edit();
                } else {
                    EditableList.this.view();
                }
            }
        }
    }

    private class NamedAction
    extends AbstractAction {
        private String m_Name;

        public NamedAction(String string) {
            this.m_Name = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (EditableList.this.m_List.getSelectedIndices().length > 0) {
                ActionEvent actionEvent2 = new ActionEvent(this, 1001, this.m_Name);
                EditableList.this.actionPerformed(actionEvent2);
            }
        }
    }
}

